/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.FormGroupBindingCompletor;
import org.eclipse.edt.compiler.core.ast.ConstantFormField;
import org.eclipse.edt.compiler.core.ast.FormField;
import org.eclipse.edt.compiler.core.ast.FormGroup;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class FormGroupBinder
extends DefaultBinder {
    private FormGroupBinding formGroupBinding;
    private Scope fileScope;

    public FormGroupBinder(FormGroupBinding formGroupBinding, Scope fileScope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(fileScope, formGroupBinding, dependencyRequestor, problemRequestor, compilerOptions);
        this.formGroupBinding = formGroupBinding;
        this.fileScope = fileScope;
    }

    @Override
    public boolean visit(FormGroup formGroup) {
        formGroup.accept(new FormGroupBindingCompletor(this.fileScope, this.formGroupBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        return true;
    }

    @Override
    public boolean visit(VariableFormField variableFormField) {
        return this.visitFormField(variableFormField);
    }

    @Override
    public boolean visit(ConstantFormField constantFormField) {
        return this.visitFormField(constantFormField);
    }

    public boolean visitFormField(FormField field) {
        if (field.hasSettingsBlock()) {
            field.getSettingsBlock().accept(this);
        }
        return false;
    }
}

