/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.GetMethodAnnotationValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.annotation.SetMethodAnnotationValueValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class EGLPropertyValidator
implements IAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding ann = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"eglProperty"));
        if (allAnnotations.get(InternUtil.intern((String)"getMethod")) == null && allAnnotations.get(InternUtil.intern((String)"setMethod")) == null) {
            if (ann == null || ann.getDeclaringPart() == null || !(target instanceof ClassDataDeclaration)) {
                return;
            }
            ClassDataDeclaration decl = (ClassDataDeclaration)target;
            for (Name name : decl.getNames()) {
                String getterName = "get" + name.getCanonicalName();
                String setterName = "set" + name.getCanonicalName();
                IFunctionBinding getter = ann.getDeclaringPart().findFunction(InternUtil.intern((String)getterName));
                IFunctionBinding setter = ann.getDeclaringPart().findFunction(InternUtil.intern((String)setterName));
                if (Binding.isValidBinding(getter)) {
                    new GetMethodAnnotationValueValidator().validateGetMethod(errorNode, target, getter, ann.getDeclaringPart(), problemRequestor, compilerOptions);
                } else {
                    problemRequestor.acceptProblem(errorNode, 6746, 2, new String[]{getterName});
                }
                if (Binding.isValidBinding(setter)) {
                    new SetMethodAnnotationValueValidator().validateSetMethod(errorNode, target, setter, ann.getDeclaringPart(), problemRequestor, compilerOptions);
                    continue;
                }
                problemRequestor.acceptProblem(errorNode, 6746, 2, new String[]{setterName});
            }
        }
    }
}

