/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IValueValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class GetMethodAnnotationValueValidator
implements IValueValidationRule {
    @Override
    public void validate(Node errorNode, Node target, IAnnotationBinding annotationBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (annotationBinding.getValue() != null && annotationBinding.getValue() != IBinding.NOT_FOUND_BINDING && annotationBinding.getValue() instanceof IFunctionBinding) {
            this.validateGetMethod(errorNode, target, (IFunctionBinding)annotationBinding.getValue(), annotationBinding.getDeclaringPart(), problemRequestor, compilerOptions);
        }
    }

    public void validateGetMethod(Node errorNode, Node target, IFunctionBinding function, IPartBinding declarer, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IPartBinding valueDeclarer = function.getDeclarer();
        if (valueDeclarer != null && declarer != valueDeclarer) {
            problemRequestor.acceptProblem(errorNode, 3461, new String[]{"getMethod", declarer.getCaseSensitiveName()});
        }
        if (function.getParameters().size() > 0) {
            problemRequestor.acceptProblem(errorNode, 3385, new String[]{function.getCaseSensitiveName(), "getMethod"});
        }
        final ITypeBinding[] fieldType = new ITypeBinding[1];
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                fieldType[0] = classDataDeclaration.getType().resolveTypeBinding();
                return false;
            }
        };
        target.accept(visitor);
        if (Binding.isValidBinding(fieldType[0]) && (function.getReturnType() == null || fieldType[0] != function.getReturnType())) {
            problemRequestor.acceptProblem(errorNode, 3386, new String[]{function.getCaseSensitiveName(), "getMethod", StatementValidator.getShortTypeString(fieldType[0])});
        }
    }
}

