/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IPartContentAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class JSFHandlerValidationOrderValidator
implements IPartContentAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node target, Map allAnnotations, IProblemRequestor problemRequestor) {
        TreeMap validationOrderAnnotationsMap = new TreeMap();
        Map validationOrderAnnotations = (Map)allAnnotations.get(InternUtil.intern((String)"validationOrder"));
        if (validationOrderAnnotations != null) {
            for (IAnnotationBinding validationOrderAnnotation : validationOrderAnnotations.keySet()) {
                ArrayList annotations = (ArrayList)validationOrderAnnotationsMap.get(validationOrderAnnotation.getValue());
                if (annotations == null) {
                    annotations = new ArrayList();
                    validationOrderAnnotationsMap.put(validationOrderAnnotation.getValue(), annotations);
                }
                annotations.add(validationOrderAnnotations.get(validationOrderAnnotation));
            }
            this.validateDuplicateValues(validationOrderAnnotationsMap, problemRequestor);
        }
    }

    private void validateDuplicateValues(Map validationOrderAnnotations, IProblemRequestor problemRequestor) {
        for (Integer nextValue : validationOrderAnnotations.keySet()) {
            ArrayList expressions = (ArrayList)validationOrderAnnotations.get(nextValue);
            if (expressions.size() <= 1) continue;
            for (Object[] nextExpr : expressions) {
                problemRequestor.acceptProblem((Node)nextExpr[0], 3140, new String[]{((IDataBinding)nextExpr[1]).getCaseSensitiveName(), nextValue.toString()});
            }
        }
    }
}

