/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ConstructorBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IInstantiationValidationRule;

public class JavaObjectInstantiationValidator
implements IInstantiationValidationRule {
    @Override
    public void validate(Node node, final ITypeBinding typeBinding, IPartBinding declaringPart, final IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (!Binding.isValidBinding(typeBinding) || typeBinding.isNullable()) {
            return;
        }
        node.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(StructureItem structureItem) {
                if (!JavaObjectInstantiationValidator.this.hasDefaultConstructor(typeBinding)) {
                    this.errorNoDefaultConstructor(structureItem.getType());
                }
                return false;
            }

            @Override
            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                if (!JavaObjectInstantiationValidator.this.hasDefaultConstructor(typeBinding)) {
                    this.errorNoDefaultConstructor(classDataDeclaration.getType());
                }
                return false;
            }

            @Override
            public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                if (!JavaObjectInstantiationValidator.this.hasDefaultConstructor(typeBinding)) {
                    this.errorNoDefaultConstructor(functionDataDeclaration.getType());
                }
                return false;
            }

            @Override
            public boolean visit(NewExpression newExpression) {
                if (newExpression.getType().resolveTypeBinding().getKind() == 2) {
                    ArrayType arrType = (ArrayType)newExpression.getType();
                    if (arrType.hasInitialSize() && !DefaultBinder.isZeroLiteral(arrType.getInitialSize()) && !JavaObjectInstantiationValidator.this.hasDefaultConstructor(typeBinding)) {
                        this.errorNoDefaultConstructor(arrType.getBaseType());
                    }
                } else if (!(newExpression.hasArgumentList() && newExpression.getArguments().size() != 0 || JavaObjectInstantiationValidator.this.hasDefaultConstructor(typeBinding))) {
                    this.errorNoDefaultConstructor(newExpression.getType());
                }
                return false;
            }

            private void errorNoDefaultConstructor(Node errorNode) {
                problemRequestor.acceptProblem(errorNode, 3429, new String[]{typeBinding.getCaseSensitiveName()});
            }
        });
    }

    private boolean hasDefaultConstructor(ITypeBinding typeBinding) {
        if (typeBinding.getKind() != 28) {
            return false;
        }
        List list = ((ExternalTypeBinding)typeBinding).getConstructors();
        if (list.size() == 0) {
            return true;
        }
        for (ConstructorBinding constructor : list) {
            if (constructor.getParameters().size() != 0) continue;
            return true;
        }
        return false;
    }
}

