/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.FieldContentValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.MustBeDLINameAnnotationValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class MustBeDLINameForDLISegmentAnnotationValidator
extends FieldContentValidationAnnotationTypeBinding {
    IAnnotationTypeBinding annotationTypeBinding;

    public MustBeDLINameForDLISegmentAnnotationValidator(IAnnotationTypeBinding annotationTypeBinding) {
        super(InternUtil.internCaseSensitive((String)"MustBeDLINameAnnotationValidator"));
        this.annotationTypeBinding = annotationTypeBinding;
    }

    @Override
    public void validate(final Node errorNode, Node target, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, final IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(this.annotationTypeBinding.getName());
        if (annotationBinding != null && annotationBinding.getValue() != null) {
            final String name = annotationBinding.getValue().toString();
            MustBeDLINameAnnotationValidator.checkDLIName(name, new MustBeDLINameAnnotationValidator.DLINameProblemRequestor(){

                @Override
                public void nameTooLong() {
                    problemRequestor.acceptProblem(errorNode, 7851, new String[]{name});
                }

                @Override
                public void badFirstCharacter() {
                    problemRequestor.acceptProblem(errorNode, 7852, new String[]{name});
                }

                @Override
                public void badCharacter() {
                    problemRequestor.acceptProblem(errorNode, 7853, new String[]{name});
                }
            });
        }
    }
}

