/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.ValueValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class NonNegativeIntegerAnnotationValidator
extends ValueValidationAnnotationTypeBinding {
    private String annotationName;
    private int problemKindForError;

    public NonNegativeIntegerAnnotationValidator(String annotationName, int problemKindForError) {
        super(InternUtil.internCaseSensitive((String)"NonNegativeIntegerAnnotationValidator"));
        this.problemKindForError = problemKindForError;
        this.annotationName = annotationName;
    }

    @Override
    public void validate(Node errorNode, Node target, IAnnotationBinding annotationBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        boolean valueIsValid = false;
        try {
            if (Integer.parseInt(annotationBinding.getValue().toString()) >= 0) {
                valueIsValid = true;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if (!valueIsValid) {
            problemRequestor.acceptProblem(errorNode, this.problemKindForError, new String[]{this.annotationName, this.getCanonicalName(target)});
        }
    }

    private String getCanonicalName(Node target) {
        return this.getEnclosingPart(target).getName().getCanonicalName();
    }

    private Part getEnclosingPart(Node node) {
        if (node instanceof Part) {
            return (Part)node;
        }
        return this.getEnclosingPart(node.getParent());
    }
}

