/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class TypeAheadFunctionAnnotationValidator
extends DefaultFieldContentAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"typeAheadFunction"));
        if (annotationBinding != null && annotationBinding.getValue() != null && containerBinding != null && containerBinding != IBinding.NOT_FOUND_BINDING && containerBinding.getKind() == 3) {
            this.internalValidate(annotationBinding, errorNode, container, containerBinding, canonicalContainerName, allAnnotations, problemRequestor, compilerOptions);
        }
    }

    protected void internalValidate(IAnnotationBinding annotationBinding, Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IFunctionBinding value = (IFunctionBinding)annotationBinding.getValue();
        if (value != null && value != IBinding.NOT_FOUND_BINDING) {
            ITypeBinding baseType;
            ITypeBinding retTypeBinding;
            Primitive prim;
            List params;
            FunctionParameterBinding paramBinding;
            ITypeBinding paramTypeBinding;
            boolean isValidSignature = false;
            if (value.getParameters().size() == 1 && (paramTypeBinding = (paramBinding = (FunctionParameterBinding)(params = value.getParameters()).get(0)).getType()) != null && paramTypeBinding != IBinding.NOT_FOUND_BINDING && paramTypeBinding.getKind() == 3 && Primitive.isStringType(prim = ((PrimitiveTypeBinding)paramTypeBinding).getPrimitive()) && (retTypeBinding = value.getReturnType()) != null && retTypeBinding != IBinding.NOT_FOUND_BINDING && retTypeBinding.getKind() == 2 && (baseType = retTypeBinding.getBaseType()) != null && baseType != IBinding.NOT_FOUND_BINDING && baseType.getKind() == 3 && Primitive.isStringType(prim = ((PrimitiveTypeBinding)baseType).getPrimitive())) {
                isValidSignature = true;
            }
            if (!isValidSignature) {
                problemRequestor.acceptProblem(errorNode, 3269, new String[]{value.getCaseSensitiveName()});
            }
            if (containerBinding != null && containerBinding != IBinding.NOT_FOUND_BINDING) {
                ITypeBinding typeBinding;
                if (containerBinding.getKind() == 5 && ((StructureItemBinding)containerBinding).getChildren().size() > 0 && ((StructureItem)container).hasLevel()) {
                    problemRequestor.acceptProblem(errorNode, 4037, new String[]{"typeAheadFunction"});
                }
                if ((typeBinding = containerBinding.getType()) != null && typeBinding != IBinding.NOT_FOUND_BINDING) {
                    if (typeBinding.getKind() == 2) {
                        typeBinding = typeBinding.getBaseType();
                    }
                    if (typeBinding.getKind() != 3) {
                        problemRequestor.acceptProblem(errorNode, 3273, new String[]{"typeAheadFunction", typeBinding.getCaseSensitiveName()});
                    }
                }
            }
        }
    }
}

