/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.IValidValuesElement;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ValidValuesAnnotationValidator
implements IAnnotationValidationRule {
    protected IAnnotationTypeBinding annotationType;
    protected String canonicalAnnotationName;

    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"validValues"));
        Object value = annotationBinding.getValue();
        Primitive prim = null;
        String typename = "";
        if (targetTypeBinding.getKind() == 3) {
            prim = ((PrimitiveTypeBinding)targetTypeBinding).getPrimitive();
            if (Primitive.isNumericType(prim) || Primitive.isIntegerType(prim)) {
                typename = "numeric";
            } else if (Primitive.isStringType(prim)) {
                typename = Primitive.STRING.getName();
            } else {
                return;
            }
        }
        if (value instanceof IValidValuesElement[] && prim != null) {
            IValidValuesElement[] array = (IValidValuesElement[])value;
            this.validateValues(array, prim, typename, targetTypeBinding, problemRequestor, errorNode);
        }
    }

    private void validateValues(IValidValuesElement[] array, Primitive prim, String typename, ITypeBinding targetTypeBinding, IProblemRequestor problemRequestor, Node errorNode) {
        int i = 0;
        while (i < array.length) {
            IValidValuesElement element = array[i];
            if (element.isRange()) {
                this.validateValues(element.getRangeElements(), prim, typename, targetTypeBinding, problemRequestor, errorNode);
            } else if (element.isFloat() && !Primitive.isFloatType(prim) && !Primitive.isIntegerType(prim) && prim != Primitive.MONEY && prim != Primitive.DECIMAL && prim != Primitive.NUM && prim != Primitive.NUMC && prim != Primitive.PACF && prim != Primitive.BIN || !element.isFloat() && !element.isInt() && Primitive.isFloatType(prim) || element.isInt() && !Primitive.isNumericType(prim) || !element.isInt() && Primitive.isNumericType(prim) && !Primitive.isFloatType(prim) && prim != Primitive.MONEY && prim != Primitive.DECIMAL && prim != Primitive.NUM && prim != Primitive.NUMC && prim != Primitive.PACF && prim != Primitive.BIN || element.isString() && !Primitive.isStringType(prim) || !element.isString() && Primitive.isStringType(prim)) {
                problemRequestor.acceptProblem(errorNode, 7672, new String[]{targetTypeBinding.getName(), typename});
                break;
            }
            ++i;
        }
    }
}

