/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.name;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLCharInfo;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameToken;

public class EGLNameLexer {
    protected PushbackReader reader;
    protected int offset;
    protected int line;
    protected int column;
    protected boolean sawCR;
    protected IProblemRequestor problemRequestor;
    protected ArrayList comments;
    public EGLNameToken lookAhead1;
    public EGLNameToken lookAhead2;
    public EGLNameToken lookAhead3;
    private ICompilerOptions compilerOptions;

    public EGLNameLexer(Reader reader, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this(reader, 0, false, problemRequestor, compilerOptions);
    }

    public EGLNameLexer(Reader reader, int currentOffset, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this(reader, currentOffset, false, problemRequestor, compilerOptions);
    }

    public EGLNameLexer(Reader reader, int currentOffset, boolean filename, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
        this.init(reader);
        this.offset = currentOffset - 1;
        this.line = 1;
        this.column = 0;
        this.lookAhead1 = null;
        this.lookAhead2 = null;
        this.lookAhead3 = null;
    }

    public void init(Reader reader) {
        this.reader = new PushbackReader(reader, 2);
        this.line = 1;
        this.column = 0;
        this.offset = -1;
        this.lookAhead1 = null;
        this.lookAhead2 = null;
        this.lookAhead3 = null;
        this.sawCR = false;
        if (this.comments == null) {
            this.comments = new ArrayList();
        } else {
            this.comments.clear();
        }
    }

    public List getComments() {
        return this.comments;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public EGLNameToken getNextToken(boolean filename) throws IOException {
        EGLNameToken token = null;
        if (this.lookAhead1 == null) {
            token = this.nextToken(filename);
            if (token != null) {
                this.lookAhead1 = this.nextToken(filename);
                if (this.lookAhead1 != null) {
                    this.lookAhead2 = this.nextToken(filename);
                }
                if (this.lookAhead2 != null) {
                    this.lookAhead3 = this.nextToken(filename);
                }
            }
        } else if (this.lookAhead2 == null) {
            token = this.lookAhead1;
            this.lookAhead1 = this.lookAhead2;
            if (this.lookAhead1 != null) {
                this.lookAhead2 = this.nextToken(filename);
            }
            if (this.lookAhead2 != null) {
                this.lookAhead3 = this.nextToken(filename);
            }
        } else {
            token = this.lookAhead1;
            this.lookAhead1 = this.lookAhead2;
            this.lookAhead2 = this.lookAhead3;
            if (this.lookAhead2 != null) {
                this.lookAhead3 = this.nextToken(filename);
            }
        }
        return token;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EGLNameToken nextToken(boolean filename) throws IOException {
        int c = this.scanNonBlank();
        if (c == -1) {
            return null;
        }
        block6: while (c == 47) {
            switch (this.scanAheadOneChar()) {
                case 47: {
                    break;
                }
                case 42: {
                    break;
                }
                default: {
                    break block6;
                }
            }
            if ((c = this.scanNonBlank()) != -1) continue;
            return null;
        }
        if (c == 39) {
            return this.readSQLString(c, this.offset, this.line, this.column);
        }
        if (c == 34) {
            return this.readEGLString(c, this.offset, this.line, this.column);
        }
        if (filename ? EGLCharInfo.isFileIdentifier1(c, this.compilerOptions) : EGLCharInfo.isIdentifier1(c, this.compilerOptions)) {
            return this.readIdentifier(c, this.offset, this.line, this.column);
        }
        if (EGLCharInfo.isDigit(c)) {
            return this.readNumber(c, this.offset, this.line, this.column);
        }
        if (c == 46 && EGLCharInfo.isDigit(this.scanAheadOneChar())) {
            return this.readFraction(c, this.offset, this.line, this.column);
        }
        if (!EGLCharInfo.isSymbol1(c)) return new EGLNameToken(11, String.valueOf((char)c), this.offset, this.line, this.column);
        return this.readSymbol(c, this.offset, this.line, this.column);
    }

    protected EGLNameToken readFraction(int c, int startOffset, int startLine, int startColumn) throws IOException {
        int kind;
        int maxSize = 0;
        StringBuffer s = new StringBuffer().append((char)c);
        while (EGLCharInfo.isDigit(c)) {
            s.append((char)this.scanChar());
            c = this.scanAheadOneChar();
        }
        if (c == 101 || c == 69) {
            kind = 9;
            maxSize = 36;
            s.append((char)this.scanChar());
            c = this.scanAheadOneChar();
            if (c == 43 || c == 45) {
                s.append((char)this.scanChar());
                c = this.scanAheadOneChar();
            }
            while (EGLCharInfo.isDigit(c)) {
                s.append((char)this.scanChar());
                c = this.scanAheadOneChar();
            }
        } else {
            kind = 7;
            maxSize = 33;
        }
        if (s.length() > maxSize) {
            this.problemRequestor.acceptProblem(startOffset, startOffset + s.length(), 2, 5203);
        }
        return new EGLNameToken(kind, s.toString(), startOffset, startLine, startColumn);
    }

    protected EGLNameToken readIdentifier(int c, int startOffset, int startLine, int startColumn) throws IOException {
        StringBuffer s = new StringBuffer().append((char)c);
        while (EGLCharInfo.isIdentifier(this.scanAheadOneChar(), this.compilerOptions)) {
            s.append((char)this.scanChar());
        }
        String ident = s.toString();
        return new EGLNameToken(6, ident, startOffset, startLine, startColumn);
    }

    protected EGLNameToken readSQLString(int c, int startOffset, int startLine, int startColumn) throws IOException {
        StringBuffer s = new StringBuffer().append((char)c);
        while (true) {
            int nextChar = this.scanAheadOneChar();
            switch (nextChar) {
                case 39: {
                    s.append((char)this.scanChar());
                    return new EGLNameToken(10, s.toString(), startOffset, startLine, startColumn);
                }
                case -1: 
                case 10: 
                case 13: {
                    this.problemRequestor.acceptProblem(startOffset, startOffset + s.length(), 2, 5202);
                    return new EGLNameToken(10, s.toString(), startOffset, startLine, startColumn);
                }
            }
            s.append((char)this.scanChar());
        }
    }

    protected EGLNameToken readEGLString(int c, int startOffset, int startLine, int startColumn) throws IOException {
        StringBuffer s = new StringBuffer().append((char)c);
        while (true) {
            int nextChar = this.scanAheadOneChar();
            switch (nextChar) {
                case 34: {
                    s.append((char)this.scanChar());
                    return new EGLNameToken(10, s.toString(), startOffset, startLine, startColumn);
                }
                case -1: 
                case 10: 
                case 13: {
                    this.problemRequestor.acceptProblem(startOffset, startOffset + s.length(), 2, 5202);
                    return new EGLNameToken(10, s.toString(), startOffset, startLine, startColumn);
                }
            }
            s.append((char)this.scanChar());
        }
    }

    protected EGLNameToken readNumber(int c, int startOffset, int startLine, int startColumn) throws IOException {
        int kind;
        int maxSize = 0;
        StringBuffer s = new StringBuffer().append((char)c);
        c = this.scanAheadOneChar();
        while (EGLCharInfo.isDigit(c)) {
            s.append((char)this.scanChar());
            c = this.scanAheadOneChar();
        }
        if (c != 46 && c != 101 && c != 69) {
            kind = 8;
            maxSize = 18;
        } else {
            if (c == 46) {
                s.append((char)this.scanChar());
                c = this.scanAheadOneChar();
                while (EGLCharInfo.isDigit(c)) {
                    s.append((char)this.scanChar());
                    c = this.scanAheadOneChar();
                }
            }
            if (c == 101 || c == 69) {
                kind = 9;
                maxSize = 36;
                s.append((char)this.scanChar());
                c = this.scanAheadOneChar();
                if (c == 43 || c == 45) {
                    s.append((char)this.scanChar());
                    c = this.scanAheadOneChar();
                }
                while (EGLCharInfo.isDigit(c)) {
                    s.append((char)this.scanChar());
                    c = this.scanAheadOneChar();
                }
            } else {
                kind = 7;
                maxSize = 33;
            }
        }
        if (s.length() > maxSize) {
            this.problemRequestor.acceptProblem(startOffset, startOffset + s.length(), 2, 5203);
        }
        return new EGLNameToken(kind, s.toString(), startOffset, startLine, startColumn);
    }

    protected EGLNameToken readSymbol(int c, int startOffset, int startLine, int startColumn) throws IOException {
        switch (c) {
            case 91: {
                return new EGLNameToken(1, "[", startOffset, startLine, startColumn);
            }
            case 93: {
                return new EGLNameToken(2, "]", startOffset, startLine, startColumn);
            }
            case 44: {
                return new EGLNameToken(4, ",", startOffset, startLine, startColumn);
            }
            case 46: {
                return new EGLNameToken(3, ".", startOffset, startLine, startColumn);
            }
            case 58: {
                return new EGLNameToken(5, ":", startOffset, startLine, startColumn);
            }
        }
        StringBuffer s = new StringBuffer().append((char)c);
        return new EGLNameToken(11, s.toString(), startOffset, startLine, startColumn);
    }

    protected EGLNameToken readLineComment(int c, int startLine, int startCol, int startOffset) throws IOException {
        StringBuffer s = new StringBuffer().append((char)c);
        s.append((char)this.scanChar());
        c = this.scanChar();
        while (c != -1 && c != 13 && c != 10) {
            s.append((char)c);
            c = this.scanChar();
        }
        this.comments.add(new EGLNameToken(Integer.MAX_VALUE, s.toString(), startLine, startCol, startOffset));
        return (EGLNameToken)this.comments.get(this.comments.size() - 1);
    }

    protected EGLNameToken readBlockComment(int c, int startLine, int startCol, int startOffset) throws IOException {
        StringBuffer s = new StringBuffer().append((char)c);
        s.append((char)this.scanChar());
        c = this.scanChar();
        while (c != -1) {
            s.append((char)c);
            if (c == 42 && this.scanAheadOneChar() == 47) {
                s.append((char)this.scanChar());
                break;
            }
            c = this.scanChar();
        }
        if (c == -1) {
            this.problemRequestor.acceptProblem(startOffset, s.length(), 2, 2051);
        }
        this.comments.add(new EGLNameToken(Integer.MAX_VALUE, s.toString(), startLine, startCol, startOffset));
        return (EGLNameToken)this.comments.get(this.comments.size() - 1);
    }

    protected int scanAheadOneChar() throws IOException {
        int c = this.reader.read();
        if (c == -1) {
            return -1;
        }
        this.reader.unread(c);
        return c;
    }

    protected int scanAheadTwoChars() throws IOException {
        int c1 = this.reader.read();
        if (c1 == -1) {
            return -1;
        }
        int c2 = this.reader.read();
        if (c2 == -1) {
            this.reader.unread(c1);
            return -1;
        }
        this.reader.unread(c2);
        this.reader.unread(c1);
        return c2;
    }

    protected int scanChar() throws IOException {
        int c = this.reader.read();
        switch (c) {
            case -1: {
                return -1;
            }
            case 10: {
                if (!this.sawCR) {
                    ++this.line;
                    this.column = 0;
                }
                ++this.offset;
                this.sawCR = false;
                break;
            }
            case 13: {
                ++this.line;
                this.column = 0;
                ++this.offset;
                this.sawCR = true;
                break;
            }
            case 9: {
                ++this.column;
                ++this.offset;
                this.sawCR = false;
                break;
            }
            default: {
                ++this.column;
                ++this.offset;
                this.sawCR = false;
            }
        }
        return c;
    }

    protected int scanNonBlank() throws IOException {
        int c = this.scanChar();
        while (c <= 32 && c != -1) {
            c = this.scanChar();
        }
        return c;
    }
}

