/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.ConverseStatement;
import org.eclipse.edt.compiler.core.ast.DisplayStatement;
import org.eclipse.edt.compiler.core.ast.PrintStatement;
import org.eclipse.edt.compiler.core.ast.ShowStatement;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.TransferStatement;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.validation.part.IStatementValidInContainerInfo;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;

public class StatementValidInContainerInfoFactory {
    public static final StatementValidInContainerInfoFactory INSTANCE = new StatementValidInContainerInfoFactory();
    private final Class[] INVALID_STATEMENTS_IN_SERVICE = new Class[]{TransferStatement.class};
    private final Class[] INVALID_STATEMENTS_IN_VGWEBTRANSACTION = new Class[]{PrintStatement.class};
    private final Class[] INVALID_STATEMENTS_IN_LIBRARY = new Class[]{DisplayStatement.class, TransferStatement.class};
    private final Class[] INVALID_STATEMENTS_IN_JSFHANDLER = new Class[]{ConverseStatement.class, DisplayStatement.class, PrintStatement.class, ShowStatement.class, TransferStatement.class};

    private StatementValidInContainerInfoFactory() {
    }

    public IStatementValidInContainerInfo create(IPartBinding partBinding) {
        switch (partBinding.getKind()) {
            case 14: {
                return new StatementValidInContainerInfo(this.INVALID_STATEMENTS_IN_SERVICE, 6559);
            }
            case 13: {
                if (!AbstractBinder.annotationIs(partBinding.getSubType(), IOStatementValidatorConstants.EGLUIWEBTRANSACTION, "VGWebTransaction")) break;
                return new StatementValidInContainerInfo(this.INVALID_STATEMENTS_IN_VGWEBTRANSACTION, 6550);
            }
            case 11: {
                return new StatementValidInContainerInfo(this.INVALID_STATEMENTS_IN_LIBRARY, 6552);
            }
            case 10: {
                if (!AbstractBinder.annotationIs(partBinding.getSubType(), IOStatementValidatorConstants.EGLUIJSF, "JSFHandler")) break;
                return new StatementValidInContainerInfo(this.INVALID_STATEMENTS_IN_JSFHANDLER, 6553);
            }
        }
        return DefaultStatementValidInContainerInfo.INSTANCE;
    }

    private static class DefaultStatementValidInContainerInfo
    implements IStatementValidInContainerInfo {
        public static DefaultStatementValidInContainerInfo INSTANCE = new DefaultStatementValidInContainerInfo();

        private DefaultStatementValidInContainerInfo() {
        }

        @Override
        public int getProblemKind() {
            return 0;
        }

        @Override
        public boolean statementIsValidInContainer(Statement statement) {
            return true;
        }
    }

    private static class StatementValidInContainerInfo
    implements IStatementValidInContainerInfo {
        private Class[] invalidStatements;
        private int problemKind;

        public StatementValidInContainerInfo(Class[] invalidStatements, int problemKind) {
            this.invalidStatements = invalidStatements;
            this.problemKind = problemKind;
        }

        @Override
        public int getProblemKind() {
            return this.problemKind;
        }

        @Override
        public boolean statementIsValidInContainer(Statement statement) {
            int i = 0;
            while (i < this.invalidStatements.length) {
                if (this.invalidStatements[i].isInstance(statement)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

