/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class ExecuteStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;

    public ExecuteStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(ExecuteStatement executeStatement) {
        StatementValidator.validateIOTargetsContainer(executeStatement.getIOObjects(), this.problemRequestor);
        this.checkForDuplicateOptions(executeStatement);
        this.checkUsingList(executeStatement);
        this.checkIOObjects(executeStatement);
        return false;
    }

    protected void checkUsingList(ExecuteStatement executeStatement) {
        executeStatement.accept(new AbstractASTVisitor(){
            boolean visitedUsing = false;

            @Override
            public boolean visit(UsingClause usingClause) {
                if (this.visitedUsing) {
                    return false;
                }
                StatementValidator.validateNodesInUsingClause(usingClause.getExpressions(), ExecuteStatementValidator.this.problemRequestor);
                this.visitedUsing = true;
                return false;
            }
        });
    }

    protected void checkIOObjects(ExecuteStatement executeStatement) {
        executeStatement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(ForExpressionClause forExpressionClause) {
                ITypeBinding typeBinding = forExpressionClause.getExpression().resolveTypeBinding();
                if (StatementValidator.isValidBinding(typeBinding)) {
                    typeBinding.getAnnotation(EGLIOSQL, "SQLRecord");
                }
                return false;
            }
        });
    }

    protected void checkForDuplicateOptions(ExecuteStatement execStmt) {
        execStmt.accept(new AbstractASTVisitor(){
            boolean using = false;
            boolean forexpr = false;

            @Override
            public boolean visit(ForExpressionClause forExpressionClause) {
                if (this.forexpr) {
                    ExecuteStatementValidator.this.problemRequestor.acceptProblem((Node)forExpressionClause, 6510, new String[]{"execute".toUpperCase(), "for".toUpperCase()});
                }
                this.forexpr = true;
                return false;
            }

            @Override
            public boolean visit(UsingClause usingClause) {
                if (this.using) {
                    ExecuteStatementValidator.this.problemRequestor.acceptProblem((Node)usingClause, 6511, new String[]{"execute".toUpperCase(), "using".toUpperCase()});
                }
                this.using = true;
                return false;
            }
        });
    }
}

