/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.Map;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ExitStatementBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.ProgramBinding;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ExitStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.IfStatement;
import org.eclipse.edt.compiler.core.ast.LabelStatement;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OpenUIStatement;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.WhileStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class ExitStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private IPartBinding enclosingPart;
    private Map labeledLoops;

    public ExitStatementValidator(IProblemRequestor problemRequestor, Map labeledLoops, IPartBinding enclosingPart, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.enclosingPart = enclosingPart;
        this.compilerOptions = compilerOptions;
        this.labeledLoops = labeledLoops;
    }

    @Override
    public boolean visit(ExitStatement exitStatement) {
        if (exitStatement.isExitProgram()) {
            this.validateExitProgram(exitStatement);
        } else if (exitStatement.isExitStack()) {
            this.validateExitStack(exitStatement);
        } else {
            this.validateExitLoop(exitStatement);
        }
        if (this.enclosingPart != null) {
            ProgramBinding pgm;
            if (exitStatement.isExitProgram() || exitStatement.isExitStack()) {
                if (13 != this.enclosingPart.getKind()) {
                    this.problemRequestor.acceptProblem((Node)exitStatement, 6726, new String[]{exitStatement.isExitProgram() ? "program".toUpperCase() : "stack".toUpperCase()});
                }
            } else if (exitStatement.isExitRunUnit() && 14 == this.enclosingPart.getKind()) {
                this.problemRequestor.acceptProblem((Node)exitStatement, 6727, new String[]{"rununit".toUpperCase()});
            }
            if (this.hasUnloadOnExit(exitStatement) && 13 == this.enclosingPart.getKind() && !(pgm = (ProgramBinding)this.enclosingPart).isCallable()) {
                this.problemRequestor.acceptProblem((Node)exitStatement, 6755, new String[0]);
            }
        }
        return false;
    }

    private boolean hasUnloadOnExit(ExitStatement exitStatement) {
        ExitStatementBinding stmtBinding = exitStatement.getStatementBinding();
        if (Binding.isValidBinding(stmtBinding)) {
            return stmtBinding.getAnnotation(EGLCORE, "unloadOnExit") != null;
        }
        return false;
    }

    private void validateExitLoop(final ExitStatement exitStatement) {
        Node current = exitStatement.getParent();
        String label = exitStatement.getLabel();
        ParentASTVisitor visitor = new ParentASTVisitor(this.isExitNULL(exitStatement), label){

            @Override
            public boolean visit(NestedFunction anestedFunction) {
                this.bcontinue = false;
                if (this.isnull) {
                    this.valid = true;
                }
                return false;
            }

            @Override
            public boolean visit(TopLevelFunction tlFunction) {
                this.bcontinue = false;
                if (this.isnull) {
                    this.valid = true;
                }
                return false;
            }

            @Override
            public boolean visit(WhileStatement whileStatement) {
                if (exitStatement.isExitWhile() || this.isnull || this.hasMatchingLabel(whileStatement, this.labelText)) {
                    this.valid = true;
                }
                return false;
            }

            @Override
            public boolean visit(OpenUIStatement openuiStatement) {
                if (exitStatement.isExitOpenUI() || this.isnull) {
                    this.valid = true;
                }
                return false;
            }

            @Override
            public boolean visit(ForEachStatement forEachStatement) {
                if (exitStatement.isExitForEach() || this.isnull || this.hasMatchingLabel(forEachStatement, this.labelText)) {
                    this.valid = true;
                }
                return false;
            }

            @Override
            public boolean visit(ForStatement forStatement) {
                if (exitStatement.isExitFor() || this.isnull || this.hasMatchingLabel(forStatement, this.labelText)) {
                    this.valid = true;
                }
                return false;
            }

            @Override
            public boolean visit(CaseStatement caseStatement) {
                if (exitStatement.isExitCase() || this.isnull || this.hasMatchingLabel(caseStatement, this.labelText)) {
                    this.valid = true;
                }
                return false;
            }

            @Override
            public boolean visit(IfStatement caseStatement) {
                if (exitStatement.isExitIf() || this.isnull || this.hasMatchingLabel(caseStatement, this.labelText)) {
                    this.valid = true;
                }
                return false;
            }
        };
        while (current != null && visitor.canContinue() && !visitor.isValid()) {
            current.accept(visitor);
            current = current.getParent();
        }
        if (!visitor.isValid()) {
            if (label != null) {
                this.problemRequestor.acceptProblem((Node)exitStatement, 5056, new String[]{label});
            } else {
                String errorIns0 = "exit";
                String errorIns1 = "";
                String[] errorInserts = null;
                errorIns1 = exitStatement.isExitCase() ? "case" : (exitStatement.isExitFor() ? "for" : (exitStatement.isExitForEach() ? "forEach" : (exitStatement.isExitIf() ? "if" : (exitStatement.isExitOpenUI() ? "openUI" : (exitStatement.isExitStack() ? "stack" : "while")))));
                errorInserts = new String[]{errorIns0, errorIns1};
                this.problemRequestor.acceptProblem((Node)exitStatement, 5055, errorInserts);
            }
        }
    }

    protected void validateExitStack(ExitStatement exitStatement) {
        String label = exitStatement.getLabel();
        if (label != null) {
            EGLNameValidator.validate(label, 33, this.problemRequestor, exitStatement, this.compilerOptions);
        }
    }

    protected void validateExitProgram(ExitStatement exitStatement) {
        Expression expr = exitStatement.getReturnCode();
        if (expr == null) {
            return;
        }
        ITypeBinding binding = expr.resolveTypeBinding();
        if (StatementValidator.isValidBinding(binding) && !StatementValidator.isIntegerCompatible(binding)) {
            this.problemRequestor.acceptProblem((Node)expr, 6628, new String[]{expr.getCanonicalString()});
        }
    }

    protected boolean isExitNULL(ExitStatement exitStatement) {
        return exitStatement.isExitProgram() || !exitStatement.isExitCase() && !exitStatement.isExitFor() && !exitStatement.isExitForEach() && !exitStatement.isExitIf() && !exitStatement.isExitStack() && !exitStatement.isExitOpenUI() && !exitStatement.isExitWhile() && exitStatement.getLabel() == null;
    }

    private class ParentASTVisitor
    extends DefaultASTVisitor {
        boolean valid = false;
        boolean bcontinue = true;
        boolean isnull = false;
        NestedFunction nestedFunction = null;
        protected String labelText;

        public ParentASTVisitor(boolean isnull, String labelText) {
            this.isnull = isnull;
            this.labelText = labelText;
        }

        public NestedFunction getNestedFunction() {
            return this.nestedFunction;
        }

        public boolean isValid() {
            return this.valid;
        }

        public boolean canContinue() {
            return this.bcontinue;
        }

        public boolean isnull() {
            return this.isnull;
        }

        protected boolean hasMatchingLabel(Statement loopStatement, String labelText) {
            LabelStatement label = (LabelStatement)ExitStatementValidator.this.labeledLoops.get(loopStatement);
            if (label != null) {
                return label.getLabel().equalsIgnoreCase(labelText);
            }
            return false;
        }
    }
}

