/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.ForUpdateClause;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.SingleRowClause;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.UsingPCBClause;
import org.eclipse.edt.compiler.core.ast.WithIDClause;
import org.eclipse.edt.compiler.core.ast.WithInlineDLIClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.DLIStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.SQLStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class GetByKeyStatementValidator
extends IOStatementValidator {
    GetByKeyStatement keyStatement;

    public GetByKeyStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(problemRequestor, compilerOptions);
    }

    @Override
    public boolean visit(final GetByKeyStatement agetByKeyStatement) {
        this.keyStatement = agetByKeyStatement;
        StatementValidator.validateIOTargetsContainer(agetByKeyStatement.getIOObjects(), this.problemRequestor);
        this.validateMultipleTargets(agetByKeyStatement);
        agetByKeyStatement.accept(new AbstractASTVisitor(){
            Node bFORUPDATE = null;
            Node bSINGLEROW = null;
            Node bINTO = null;
            Node bUSING = null;
            Node bUSINGKEYS = null;
            Node bPREPAREID = null;
            WithInlineSQLClause bINLINESQL = null;
            WithInlineDLIClause bINLINEDLI = null;
            UsingPCBClause pcbClause = null;
            ArrayList list = new ArrayList();

            @Override
            public boolean visit(ForUpdateClause forUpdateClause) {
                if (this.bFORUPDATE != null) {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)forUpdateClause, 6510, new String[]{"get".toUpperCase(), "forUpdate".toUpperCase()});
                } else {
                    this.bFORUPDATE = forUpdateClause;
                    this.list.add(this.bFORUPDATE);
                }
                if (forUpdateClause.hasID()) {
                    EGLNameValidator.validate(forUpdateClause.getID(), 19, GetByKeyStatementValidator.this.problemRequestor, forUpdateClause, GetByKeyStatementValidator.this.compilerOptions);
                }
                return false;
            }

            @Override
            public boolean visit(UsingPCBClause usingPCBClause) {
                this.pcbClause = usingPCBClause;
                return false;
            }

            @Override
            public boolean visit(SingleRowClause singleRowClause) {
                if (this.bSINGLEROW != null) {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)singleRowClause, 6510, new String[]{"get".toUpperCase(), "singleRow".toUpperCase()});
                } else {
                    this.bSINGLEROW = singleRowClause;
                    this.list.add(this.bSINGLEROW);
                }
                return false;
            }

            @Override
            public boolean visit(IntoClause intoClause) {
                if (this.bINTO != null) {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)intoClause, 6511, new String[]{"get".toUpperCase(), "into".toUpperCase()});
                } else {
                    this.bINTO = intoClause;
                    this.list.add(this.bINTO);
                    intoClause.accept(new AbstractASTExpressionVisitor(){

                        @Override
                        public boolean visitExpression(Expression expression) {
                            StatementValidator.validateItemInIntoClause(expression, (this).GetByKeyStatementValidator.this.problemRequestor);
                            return false;
                        }
                    });
                }
                return false;
            }

            @Override
            public boolean visit(UsingClause usingClause) {
                if (this.bUSING != null) {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)usingClause, 6511, new String[]{"get".toUpperCase(), "using".toUpperCase()});
                } else {
                    this.bUSING = usingClause;
                    this.list.add(this.bUSING);
                    StatementValidator.validateNodesInUsingClause(usingClause.getExpressions(), GetByKeyStatementValidator.this.problemRequestor);
                }
                return false;
            }

            @Override
            public boolean visit(UsingKeysClause usingKeysClause) {
                if (this.bUSINGKEYS != null) {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)usingKeysClause, 6511, new String[]{"get".toUpperCase(), "usingKeys".toUpperCase()});
                } else {
                    this.bUSINGKEYS = usingKeysClause;
                    this.list.add(this.bUSINGKEYS);
                    final List sqlRecordObjectDataBindings = StatementValidator.getSQLRecordIOObjects(agetByKeyStatement);
                    usingKeysClause.accept(new AbstractASTExpressionVisitor(){
                        IDataBinding qualifierDBinding;

                        @Override
                        public boolean visitExpression(Expression expression) {
                            StatementValidator.validateNodeAsDataItemReferences(expression, (this).GetByKeyStatementValidator.this.problemRequestor);
                            if (sqlRecordObjectDataBindings.contains(this.qualifierDBinding)) {
                                (this).GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)expression, 6542, new String[]{expression.getCanonicalString()});
                            }
                            return false;
                        }

                        @Override
                        public boolean visitName(Name name) {
                            name.accept(new DefaultASTVisitor(){

                                @Override
                                public boolean visit(SimpleName simpleName) {
                                    qualifierDBinding = (IDataBinding)simpleName.getAttribute(Name.IMPLICIT_QUALIFIER_DATA_BINDING);
                                    return false;
                                }

                                @Override
                                public boolean visit(QualifiedName qualifiedName) {
                                    qualifierDBinding = qualifiedName.getQualifier().resolveDataBinding();
                                    return false;
                                }
                            });
                            return this.visitExpression(name);
                        }

                        @Override
                        public boolean visit(FieldAccess fieldAccess) {
                            this.qualifierDBinding = fieldAccess.getPrimary().resolveDataBinding();
                            return this.visitExpression(fieldAccess);
                        }
                    });
                }
                return false;
            }

            @Override
            public boolean visit(WithIDClause withIDClause) {
                if (this.bPREPAREID != null) {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)withIDClause, 6513, new String[]{"get".toUpperCase()});
                } else {
                    this.bPREPAREID = withIDClause;
                    this.list.add(this.bPREPAREID);
                }
                EGLNameValidator.validate(withIDClause.getID(), 19, GetByKeyStatementValidator.this.problemRequestor, withIDClause, GetByKeyStatementValidator.this.compilerOptions);
                return false;
            }

            @Override
            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                if (this.bINLINESQL != null) {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6512, new String[]{"get".toUpperCase()});
                } else if (StatementValidator.isClauseEmpty(withInlineSQLClause.getSqlStmt().getValue())) {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6500, new String[]{"get".toUpperCase()});
                } else {
                    this.bINLINESQL = withInlineSQLClause;
                    this.list.add(this.bINLINESQL);
                    SQLStatementValidator.checkGetAndOpenClauses(withInlineSQLClause, agetByKeyStatement.getSqlInfo().getParser(), GetByKeyStatementValidator.this.problemRequestor, "get", this.isGetArray());
                }
                return false;
            }

            private boolean isGetArray() {
                Expression expr;
                ITypeBinding tb;
                if (GetByKeyStatementValidator.this.keyStatement == null) {
                    return false;
                }
                List list = GetByKeyStatementValidator.this.keyStatement.getTargets();
                return list.size() > 0 && Binding.isValidBinding(tb = (expr = (Expression)list.get(0)).resolveTypeBinding()) && tb.getKind() == 2;
            }

            @Override
            public boolean visit(WithInlineDLIClause withInlineDLIClause) {
                if (this.bINLINEDLI != null) {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineDLIClause, 6546, new String[]{"get".toUpperCase()});
                } else {
                    this.bINLINEDLI = withInlineDLIClause;
                    this.list.add(this.bINLINESQL);
                }
                return false;
            }

            @Override
            public void endVisit(GetByKeyStatement getByKeyStatement) {
                if (this.bFORUPDATE != null && this.bSINGLEROW != null) {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem(this.list.indexOf(this.bFORUPDATE) < this.list.indexOf(this.bSINGLEROW) ? this.bSINGLEROW : this.bFORUPDATE, 6508, new String[]{"get".toUpperCase()});
                }
                if (this.bFORUPDATE != null && this.bINLINESQL != null) {
                    SQLStatementValidator.checkForUpdateClause(this.bINLINESQL, agetByKeyStatement.getSqlInfo().getParser().getSqlClauseKeywordsUsed(), GetByKeyStatementValidator.this.problemRequestor, "get");
                }
                if (this.bPREPAREID != null && this.bSINGLEROW != null) {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem(this.list.indexOf(this.bPREPAREID) < this.list.indexOf(this.bSINGLEROW) ? this.bSINGLEROW : this.bPREPAREID, 6539, new String[]{"get".toUpperCase()});
                }
                if (this.bPREPAREID != null && this.bINLINESQL != null) {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem(this.list.indexOf(this.bPREPAREID) < this.list.indexOf(this.bINLINESQL) ? this.bSINGLEROW : this.bPREPAREID, 6509, new String[]{"get".toUpperCase()});
                }
                if (getByKeyStatement.getDliInfo() != null) {
                    DLIStatementValidator validator = new DLIStatementValidator(getByKeyStatement, GetByKeyStatementValidator.this.problemRequestor, 2);
                    validator.validateGetByKeyDLI(this.pcbClause, this.bFORUPDATE != null);
                }
                if (getByKeyStatement.getTargets().size() == 0) {
                    if (this.bFORUPDATE != null) {
                        GetByKeyStatementValidator.this.problemRequestor.acceptProblem(this.bFORUPDATE, 6515, new String[]{"get".toUpperCase()});
                    }
                    if (this.bUSINGKEYS != null) {
                        GetByKeyStatementValidator.this.problemRequestor.acceptProblem(this.bUSINGKEYS, 6530, new String[]{"get".toUpperCase()});
                    }
                    if (this.bINTO == null || this.bPREPAREID == null && this.bINLINESQL == null) {
                        GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)getByKeyStatement, 6516, new String[]{"get".toUpperCase()});
                    }
                } else {
                    int i = 0;
                    while (i < getByKeyStatement.getTargets().size()) {
                        Expression expr = (Expression)getByKeyStatement.getTargets().get(i);
                        final IDataBinding dataBinding = expr.resolveDataBinding();
                        ITypeBinding typeBinding = expr.resolveTypeBinding();
                        if (StatementValidator.isValidBinding(typeBinding)) {
                            if (typeBinding.getKind() == 2) {
                                ITypeBinding baseBinding;
                                if (this.bFORUPDATE != null) {
                                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem(expr, 7872);
                                }
                                if (StatementValidator.isValidBinding(baseBinding = typeBinding.getBaseType()) && (baseBinding.getKind() == 7 || baseBinding.getKind() == 6) && baseBinding.getAnnotation(EGLIOSQL, "SQLRecord") != null && this.bINTO != null && StatementValidator.isValidBinding(dataBinding)) {
                                    this.bINTO.accept(new AbstractASTExpressionVisitor(){

                                        @Override
                                        public boolean visit(SimpleName simpleName) {
                                            if (simpleName.getAttribute(Name.IMPLICIT_QUALIFIER_DATA_BINDING) != dataBinding) {
                                                this.addError(simpleName);
                                            }
                                            return false;
                                        }

                                        @Override
                                        public boolean visit(QualifiedName qualifiedName) {
                                            Name name = qualifiedName;
                                            IDataBinding db = null;
                                            while (name != null) {
                                                db = name.resolveDataBinding();
                                                if (!StatementValidator.isValidBinding(db)) {
                                                    return false;
                                                }
                                                if (db == dataBinding) break;
                                                db = null;
                                                if (!((Name)name).isQualifiedName()) break;
                                                name = name.getQualifier();
                                            }
                                            if (db == null) {
                                                this.addError(qualifiedName);
                                            }
                                            return false;
                                        }

                                        @Override
                                        public boolean visit(FieldAccess fieldAccess) {
                                            return true;
                                        }

                                        @Override
                                        public boolean visit(ArrayAccess arrayAccess) {
                                            if (arrayAccess.getArray().resolveDataBinding() != dataBinding) {
                                                this.addError(arrayAccess);
                                            }
                                            return false;
                                        }

                                        protected void addError(Expression node) {
                                            (this).GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)node, 7745, new String[]{node.getCanonicalString()});
                                        }

                                        @Override
                                        public boolean visitExpression(Expression expression) {
                                            return true;
                                        }
                                    });
                                }
                            } else if (typeBinding.getKind() == 6 || typeBinding.getKind() == 7) {
                                typeBinding.getAnnotation(EGLIOSQL, "SQLRecord");
                            }
                        }
                        ++i;
                    }
                }
            }
        });
        this.keyStatement = null;
        return false;
    }

    private void validateMultipleTargets(GetByKeyStatement keyStatement) {
        int count = 0;
        boolean isdli = false;
        List targetList = keyStatement.getTargets();
        for (Expression expr : targetList) {
            ITypeBinding typeBinding = expr.resolveTypeBinding();
            if (StatementValidator.isValidBinding(typeBinding)) {
                if (++count > 1) {
                    if (!isdli || typeBinding.getAnnotation(EGLIODLI, "dliSegment") == null) {
                        this.problemRequestor.acceptProblem((Node)expr, 7869, new String[]{"get"});
                    }
                } else {
                    isdli = typeBinding.getAnnotation(EGLIODLI, "dliSegment") != null;
                }
            }
            this.validateTargetType(expr);
        }
    }

    protected void validateTargetType(Expression expression) {
        boolean isValid = false;
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        IDataBinding dataBinding = expression.resolveDataBinding();
        if (StatementValidator.isValidBinding(typeBinding) && StatementValidator.isValidBinding(dataBinding)) {
            if (typeBinding.getKind() == 2) {
                ITypeBinding arrayBinding = typeBinding.getBaseType();
                if (!StatementValidator.isValidBinding(arrayBinding)) {
                    return;
                }
                if (arrayBinding.getAnnotation(EGLIOSQL, "SQLRecord") != null || arrayBinding.getAnnotation(EGLIOFILE, "CSVRecord") != null || arrayBinding.getAnnotation(EGLIODLI, "DLISegment") != null) {
                    isValid = true;
                }
            } else if (!(typeBinding.getKind() != 6 && typeBinding.getKind() != 7 || typeBinding.getAnnotation(EGLIOSQL, "SQLRecord") == null && typeBinding.getAnnotation(EGLIOFILE, "IndexedRecord") == null && typeBinding.getAnnotation(EGLIODLI, "DLISegment") == null && typeBinding.getAnnotation(EGLIOFILE, "RelativeRecord") == null)) {
                isValid = true;
            }
        }
    }
}

