/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.Iterator;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FieldAccessValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.VariableBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;

public class LValueValidator {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private IDataBinding dBinding;
    private Expression lValue;
    private ILValueValidationRules validationRules;

    public LValueValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IDataBinding dBinding, Expression lValue) {
        this(problemRequestor, compilerOptions, dBinding, lValue, new DefaultLValueValidationRules());
    }

    public LValueValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IDataBinding dBinding, Expression lValue, ILValueValidationRules validationRules) {
        this.problemRequestor = problemRequestor;
        this.dBinding = dBinding;
        this.lValue = lValue;
        this.validationRules = validationRules;
        this.compilerOptions = compilerOptions;
    }

    private boolean invokeFieldAccessValidators() {
        boolean result = true;
        if (!Binding.isValidBinding(this.dBinding)) {
            return result;
        }
        for (IAnnotationBinding ann : this.dBinding.getAnnotations()) {
            IAnnotationTypeBinding annType;
            IAnnotationTypeBinding validationProxy;
            if (!Binding.isValidBinding(ann) || !Binding.isValidBinding(ann.getType()) || !(ann.getType() instanceof IAnnotationTypeBinding) || (validationProxy = (annType = (IAnnotationTypeBinding)ann.getType()).getValidationProxy()) == null) continue;
            Iterator iter = validationProxy.getFieldAccessAnnotations().iterator();
            while (iter.hasNext()) {
                boolean bl = result = ((FieldAccessValidationAnnotationTypeBinding)iter.next()).validateLValue(this.lValue, this.dBinding, this.problemRequestor, this.compilerOptions) && result;
            }
        }
        return result;
    }

    public boolean validate() {
        ITypeBinding exprType;
        ITypeBinding dBindingType;
        IAnnotationBinding aBinding;
        boolean result = true;
        if (this.validationRules.shouldRunAccessRules()) {
            result = this.invokeFieldAccessValidators();
        }
        if (!this.validationRules.canAssignToPCB() && (aBinding = this.dBinding.getAnnotation(new String[]{"egl", "io", "dli"}, "PCB")) != null) {
            this.problemRequestor.acceptProblem((Node)this.lValue, 7949, new String[]{this.lValue.getCanonicalString()});
        }
        if (this.dBinding.getKind() == 0 && !this.validationRules.canAssignToFunctionParmConst() && ((FunctionParameterBinding)this.dBinding).isConst()) {
            boolean settingValueOfConstantArrayElement = false;
            dBindingType = this.dBinding.getType();
            exprType = this.lValue.resolveTypeBinding();
            if (dBindingType != null && exprType != null) {
                boolean bl = settingValueOfConstantArrayElement = 2 == dBindingType.getKind() && exprType != dBindingType;
            }
            if (!settingValueOfConstantArrayElement) {
                this.problemRequestor.acceptProblem((Node)this.lValue, 6646, new String[]{this.dBinding.getCaseSensitiveName()});
                result = false;
            }
        }
        if (this.dBinding.getKind() == 3 || this.dBinding.getKind() == 2) {
            if (!this.validationRules.canAssignToConstantVariables() && ((VariableBinding)this.dBinding).isConstant()) {
                boolean settingValueOfConstantArrayElement = false;
                dBindingType = this.dBinding.getType();
                exprType = this.lValue.resolveTypeBinding();
                if (dBindingType != null && exprType != null) {
                    boolean bl = settingValueOfConstantArrayElement = 2 == dBindingType.getKind() && exprType != dBindingType;
                }
                if (!settingValueOfConstantArrayElement) {
                    this.problemRequestor.acceptProblem((Node)this.lValue, 6646, new String[]{this.dBinding.getCaseSensitiveName()});
                    result = false;
                }
            }
            if (!this.validationRules.canAssignToReadOnlyVariables() && ((VariableBinding)this.dBinding).isReadOnly()) {
                this.problemRequestor.acceptProblem((Node)this.lValue, 7740, new String[]{this.dBinding.getCaseSensitiveName()});
                result = false;
            }
        }
        if (!(this.dBinding.getKind() != 20 && this.dBinding.getKind() != 21 || this.validationRules.canAssignToFunctionReferences())) {
            this.problemRequestor.acceptProblem((Node)this.lValue, 7954, new String[]{this.dBinding.getCaseSensitiveName()});
            result = false;
        }
        return result;
    }

    public static class DefaultLValueValidationRules
    implements ILValueValidationRules {
        @Override
        public boolean canAssignToPCB() {
            return false;
        }

        @Override
        public boolean canAssignToConstantVariables() {
            return false;
        }

        @Override
        public boolean canAssignToReadOnlyVariables() {
            return false;
        }

        @Override
        public boolean canAssignToFunctionReferences() {
            return false;
        }

        @Override
        public boolean canAssignToFunctionParmConst() {
            return false;
        }

        @Override
        public boolean shouldRunAccessRules() {
            return true;
        }
    }

    public static interface ILValueValidationRules {
        public boolean canAssignToConstantVariables();

        public boolean canAssignToReadOnlyVariables();

        public boolean canAssignToFunctionReferences();

        public boolean canAssignToPCB();

        public boolean canAssignToFunctionParmConst();

        public boolean shouldRunAccessRules();
    }
}

