/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.OpenUIStatementBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.VariableBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnEventBlock;
import org.eclipse.edt.compiler.core.ast.OpenUIStatement;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class OpenUIStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IProblemRequestor problemRequestor;
    private ITypeBinding targetType;
    private OpenUIStatement openUIStatement;
    private OpenUIStatementBinding openUIStatementBinding;
    private boolean isNewExpression;
    private boolean isLiteralExpression;
    private OpenTargetValidator openTargetValidator = new OpenTargetValidator();
    private BindClauseValidator bindClauseValidator = new BindClauseValidator();
    private EventBlockValidator eventBlockValidator = new EventBlockValidator();
    private ICompilerOptions compilerOptions;

    public OpenUIStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(OpenUIStatement openUIStatement) {
        this.targetType = null;
        this.openUIStatement = openUIStatement;
        this.openUIStatementBinding = openUIStatement.getStatementBinding();
        this.openTargetValidator.validateOpenTargets();
        this.eventBlockValidator.validateEventBlocks();
        this.bindClauseValidator.validateBindClause();
        this.validateExpressionAttributes();
        return false;
    }

    private void validateExpressionAttributes() {
        if (this.openUIStatement.hasOpenAttributes()) {
            this.openUIStatement.getOpenAttributes().accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(SettingsBlock settingsBlock) {
                    return true;
                }

                @Override
                public boolean visit(Assignment assignment) {
                    Expression valueExpr;
                    ITypeBinding valueType;
                    IAnnotationTypeBinding aTypeBinding;
                    IAnnotationBinding aBinding = assignment.resolveBinding();
                    if (aBinding != null && IBinding.NOT_FOUND_BINDING != aBinding && (aTypeBinding = (IAnnotationTypeBinding)aBinding.getType()).takesExpressionInOpenUIStatement() && (valueType = (valueExpr = (Expression)aBinding.getValue()).resolveTypeBinding()) != null && !TypeCompatibilityUtil.isMoveCompatible(aTypeBinding.getSingleValueType(), valueType, valueExpr, OpenUIStatementValidator.this.compilerOptions)) {
                        OpenUIStatementValidator.this.problemRequestor.acceptProblem((Node)assignment.getRightHandSide(), 6653, new String[]{StatementValidator.getShortTypeString(aTypeBinding.getSingleValueType()), StatementValidator.getShortTypeString(valueType), String.valueOf(aTypeBinding.getCaseSensitiveName()) + " = " + valueExpr.getCanonicalString()});
                    }
                    return false;
                }
            });
        }
    }

    private boolean extendsConsoleWidget(ITypeBinding tBinding) {
        if (28 == tBinding.getKind()) {
            Iterator iter = ((ExternalTypeBinding)tBinding).getExtendedTypes().iterator();
            while (iter.hasNext()) {
                if (!AbstractBinder.typeIs((ITypeBinding)iter.next(), EGLUICONSOLE, "CONSOLEWIDGET")) continue;
                return true;
            }
        }
        return false;
    }

    private class BindClauseValidator {
        private BindClauseValidator() {
        }

        private void validateBindClause() {
            this.validateBindClauseApplicable();
            this.validateBindTargetCount();
            this.validateBindClauseTargets();
        }

        private void validateBindClauseApplicable() {
            if (OpenUIStatementValidator.this.openUIStatement.getBindClauseVariables().size() == 0) {
                return;
            }
            if (StatementValidator.isValidBinding(OpenUIStatementValidator.this.targetType)) {
                if (OpenUIStatementValidator.this.targetType.isReference()) {
                    ITypeBinding elementType = OpenUIStatementValidator.this.targetType.getBaseType();
                    if (AbstractBinder.typeIs(elementType, EGLUICONSOLE, "PROMPT")) {
                        return;
                    }
                    if (AbstractBinder.typeIs(elementType, EGLUICONSOLE, "CONSOLEFIELD")) {
                        return;
                    }
                }
                if (OpenUIStatementValidator.this.targetType.isDynamicallyAccessible()) {
                    return;
                }
                if (OpenUIStatementValidator.this.extendsConsoleWidget(OpenUIStatementValidator.this.targetType.getBaseType())) {
                    return;
                }
                if ((OpenUIStatementValidator.this.targetType.getKind() == 7 || OpenUIStatementValidator.this.targetType.getKind() == 6) && OpenUIStatementValidator.this.targetType.getAnnotation(EGLUICONSOLE, "ConsoleForm") != null) {
                    return;
                }
                int size = OpenUIStatementValidator.this.openUIStatement.getBindClauseVariables().size();
                OpenUIStatementValidator.this.problemRequestor.acceptProblem(((Expression)OpenUIStatementValidator.this.openUIStatement.getBindClauseVariables().get(0)).getOffset(), ((Expression)OpenUIStatementValidator.this.openUIStatement.getBindClauseVariables().get(size - 1)).getOffset() + ((Expression)OpenUIStatementValidator.this.openUIStatement.getBindClauseVariables().get(size - 1)).getLength(), 2, 7702);
            }
        }

        private void validateBindTargetCount() {
            IAnnotationBinding aBinding;
            int bindTargetCount = OpenUIStatementValidator.this.openUIStatement.getBindClauseVariables().size();
            int openTargetCount = OpenUIStatementValidator.this.openUIStatement.getOpenableElements().size();
            List bindClauseVariables = OpenUIStatementValidator.this.openUIStatement.getBindClauseVariables();
            if (openTargetCount > 1 && openTargetCount < bindTargetCount) {
                OpenUIStatementValidator.this.problemRequestor.acceptProblem(((Expression)bindClauseVariables.get(0)).getOffset(), ((Expression)bindClauseVariables.get(bindTargetCount - 1)).getOffset() + ((Expression)bindClauseVariables.get(bindTargetCount - 1)).getLength(), 2, 7704);
            }
            if ((aBinding = OpenUIStatementValidator.this.openUIStatementBinding.getAnnotation(EGLUICONSOLE, "IsConstruct")) != null && Boolean.YES == aBinding.getValue() && bindTargetCount != 1) {
                if (OpenUIStatementValidator.this.openUIStatement.hasBindClause()) {
                    int startOffset = ((Expression)bindClauseVariables.get(0)).getOffset();
                    int endOffset = ((Expression)bindClauseVariables.get(bindClauseVariables.size() - 1)).getOffset() + ((Expression)bindClauseVariables.get(bindClauseVariables.size() - 1)).getLength();
                    OpenUIStatementValidator.this.problemRequestor.acceptProblem(startOffset, endOffset, ((Expression)bindClauseVariables.get(0)).getOffset() + 2, 7703);
                } else {
                    OpenUIStatementValidator.this.problemRequestor.acceptProblem(OpenUIStatementValidator.this.openUIStatement.getOpenAttributes().getSetting(InternUtil.intern((String)"IsConstruct")), 7703);
                }
            }
        }

        private void validateBindClauseTargets() {
            for (Expression target : OpenUIStatementValidator.this.openUIStatement.getBindClauseVariables()) {
                IAnnotationBinding aBinding;
                ITypeBinding targetTypeBinding = target.resolveTypeBinding();
                IDataBinding targetDataBinding = target.resolveDataBinding();
                OpenUIStatementValidator.this.isLiteralExpression = false;
                if (StatementValidator.isValidBinding(targetDataBinding)) {
                    aBinding = OpenUIStatementValidator.this.openUIStatementBinding.getAnnotation(EGLUICONSOLE, "IsConstruct");
                    if (aBinding != null && Boolean.YES == aBinding.getValue()) {
                        if (this.isWritableDataBinding(targetDataBinding) && this.isStringTypeBinding(targetDataBinding.getType())) continue;
                        OpenUIStatementValidator.this.problemRequestor.acceptProblem(target.getOffset(), target.getOffset() + target.getLength(), 2, 7705);
                        continue;
                    }
                    aBinding = OpenUIStatementValidator.this.openUIStatementBinding.getAnnotation(EGLUICONSOLE, "DisplayOnly");
                    if (aBinding != null && Boolean.NO != aBinding.getValue() || this.isWritableDataBinding(targetDataBinding)) continue;
                    OpenUIStatementValidator.this.problemRequestor.acceptProblem(target.getOffset(), target.getOffset() + target.getLength(), 2, 7706);
                    continue;
                }
                if (!StatementValidator.isValidBinding(targetTypeBinding)) continue;
                aBinding = OpenUIStatementValidator.this.openUIStatementBinding.getAnnotation(EGLUICONSOLE, "IsConstruct");
                if (aBinding != null && Boolean.YES == aBinding.getValue()) {
                    OpenUIStatementValidator.this.problemRequestor.acceptProblem(target.getOffset(), target.getOffset() + target.getLength(), 2, 7705);
                    continue;
                }
                aBinding = OpenUIStatementValidator.this.openUIStatementBinding.getAnnotation(EGLUICONSOLE, "DisplayOnly");
                if (aBinding != null && Boolean.NO != aBinding.getValue()) continue;
                target.accept(new AbstractASTExpressionVisitor(){

                    @Override
                    public boolean visitLiteral(LiteralExpression literal) {
                        OpenUIStatementValidator.this.isLiteralExpression = true;
                        return false;
                    }
                });
                if (OpenUIStatementValidator.this.isLiteralExpression) continue;
                OpenUIStatementValidator.this.problemRequestor.acceptProblem(target.getOffset(), target.getOffset() + target.getLength(), 2, 7706);
            }
        }

        private boolean isStringTypeBinding(ITypeBinding typeBinding) {
            boolean isString = false;
            if (typeBinding.getKind() == 3) {
                Primitive primitiveType = ((PrimitiveTypeBinding)typeBinding).getPrimitive();
                switch (primitiveType.getType()) {
                    case 4: {
                        isString = true;
                        break;
                    }
                    case 5: {
                        isString = true;
                        break;
                    }
                    case 9: {
                        isString = true;
                        break;
                    }
                    case 11: {
                        isString = true;
                        break;
                    }
                    case 20: {
                        isString = true;
                        break;
                    }
                    case 19: {
                        isString = true;
                    }
                }
            }
            return isString;
        }

        private boolean isWritableDataBinding(IDataBinding dataBinding) {
            if (dataBinding instanceof VariableBinding) {
                return !((VariableBinding)dataBinding).isConstant();
            }
            return true;
        }
    }

    private class EventBlockValidator {
        private EventBlockValidator() {
        }

        private void validateEventBlocks() {
            OpenUIStatementValidator.this.openUIStatement.accept(new AbstractASTVisitor(){

                @Override
                public boolean visit(OnEventBlock onEventBlock) {
                    EventBlockValidator.this.validateEventBlock(onEventBlock);
                    return false;
                }
            });
        }

        private void validateEventBlock(OnEventBlock eventBlock) {
            IDataBinding dBinding = eventBlock.getEventTypeExpr().resolveDataBinding();
            if (Binding.isValidBinding(dBinding)) {
                boolean isValid = false;
                switch (dBinding.getKind()) {
                    case 15: {
                        if (InternUtil.intern((String)"ConsoleEventKind") != dBinding.getDeclaringPart().getName()) break;
                        isValid = true;
                        if (InternUtil.intern((String)"AFTER_DELETE") == dBinding.getName() || InternUtil.intern((String)"AFTER_OPENUI") == dBinding.getName() || InternUtil.intern((String)"AFTER_INSERT") == dBinding.getName() || InternUtil.intern((String)"AFTER_ROW") == dBinding.getName() || InternUtil.intern((String)"BEFORE_DELETE") == dBinding.getName() || InternUtil.intern((String)"BEFORE_OPENUI") == dBinding.getName() || InternUtil.intern((String)"BEFORE_INSERT") == dBinding.getName() || InternUtil.intern((String)"BEFORE_ROW") == dBinding.getName()) {
                            this.validateNoStringEventBlock(eventBlock);
                            break;
                        }
                        if (InternUtil.intern((String)"AFTER_FIELD") == dBinding.getName() || InternUtil.intern((String)"BEFORE_FIELD") == dBinding.getName()) {
                            this.validateFieldListEventBlock(eventBlock);
                            break;
                        }
                        if (InternUtil.intern((String)"ON_KEY") == dBinding.getName()) {
                            this.validateKeyListEventBlock(eventBlock);
                            break;
                        }
                        if (InternUtil.intern((String)"MENU_ACTION") != dBinding.getName()) break;
                        this.validateMenuActionListEventBlock(eventBlock);
                        break;
                    }
                    case 3: {
                        boolean bl = isValid = PrimitiveTypeBinding.getInstance(Primitive.INT) == dBinding.getType() && OpenUIStatementValidator.this.extendsConsoleWidget(dBinding.getDeclaringPart());
                    }
                }
                if (!isValid) {
                    OpenUIStatementValidator.this.problemRequestor.acceptProblem(eventBlock.getOffset(), eventBlock.getOffset() + eventBlock.getLength(), 2, 7707, new String[]{eventBlock.getEventTypeExpr().getCanonicalString()});
                }
            }
        }

        private void validateNoStringEventBlock(OnEventBlock eventBlock) {
            if (eventBlock.getStringList().size() > 0) {
                int size = eventBlock.getStringList().size();
                OpenUIStatementValidator.this.problemRequestor.acceptProblem(((Expression)eventBlock.getStringList().get(0)).getOffset(), ((Expression)eventBlock.getStringList().get(size - 1)).getOffset() + ((Expression)eventBlock.getStringList().get(size - 1)).getLength(), 2, 7708);
            }
        }

        private void validateHasStringEventBlock(OnEventBlock eventBlock) {
            if (eventBlock.getStringList().size() == 0) {
                OpenUIStatementValidator.this.problemRequestor.acceptProblem(eventBlock.getOffset(), eventBlock.getOffset() + eventBlock.getLength(), 2, 7709);
            }
        }

        private void validateFieldListEventBlock(OnEventBlock eventBlock) {
            this.validateHasStringEventBlock(eventBlock);
        }

        private void validateKeyListEventBlock(OnEventBlock eventBlock) {
            this.validateHasStringEventBlock(eventBlock);
        }

        private void validateMenuActionListEventBlock(OnEventBlock eventBlock) {
            this.validateHasStringEventBlock(eventBlock);
        }
    }

    private class OpenTargetValidator {
        private OpenTargetValidator() {
        }

        private void validateOpenTargets() {
            if (OpenUIStatementValidator.this.openUIStatement.getOpenableElements().size() == 1) {
                this.validateSingleOpenTarget();
            } else {
                this.validateMultipleOpenTargets();
            }
        }

        private void validateSingleOpenTarget() {
            Expression target = (Expression)OpenUIStatementValidator.this.openUIStatement.getOpenableElements().get(0);
            OpenUIStatementValidator.this.targetType = target.resolveTypeBinding();
            OpenUIStatementValidator.this.isNewExpression = false;
            target.accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(NewExpression newExpression) {
                    OpenUIStatementValidator.this.isNewExpression = true;
                    return false;
                }
            });
            if (StatementValidator.isValidBinding(OpenUIStatementValidator.this.targetType)) {
                ITypeBinding baseType;
                ITypeBinding elementType;
                if (OpenUIStatementValidator.this.targetType.isReference()) {
                    ITypeBinding elementType2 = OpenUIStatementValidator.this.targetType.getBaseType();
                    if (AbstractBinder.typeIs(elementType2, EGLUICONSOLE, "PROMPT") || AbstractBinder.typeIs(elementType2, EGLUICONSOLE, "WINDOW") || AbstractBinder.typeIs(elementType2, EGLUICONSOLE, "MENU") || AbstractBinder.typeIs(elementType2, EGLUICONSOLE, "CONSOLEFIELD") && !OpenUIStatementValidator.this.isNewExpression || elementType2.isDynamicallyAccessible()) {
                        return;
                    }
                    if (OpenUIStatementValidator.this.targetType.getAnnotation(EGLUICONSOLE, "ConsoleForm") != null) {
                        return;
                    }
                    if (OpenUIStatementValidator.this.extendsConsoleWidget(OpenUIStatementValidator.this.targetType.getBaseType())) {
                        return;
                    }
                } else if (OpenUIStatementValidator.this.targetType.getKind() == 2 ? (elementType = OpenUIStatementValidator.this.targetType.getBaseType()).isReference() && AbstractBinder.typeIs(baseType = elementType.getBaseType(), EGLUICONSOLE, "CONSOLEFIELD") : OpenUIStatementValidator.this.targetType.isDynamicallyAccessible()) {
                    return;
                }
                OpenUIStatementValidator.this.problemRequestor.acceptProblem(target.getOffset(), target.getOffset() + target.getLength(), 2, 7700, new String[]{target.getCanonicalString()});
            }
        }

        private void validateMultipleOpenTargets() {
            for (Expression target : OpenUIStatementValidator.this.openUIStatement.getOpenableElements()) {
                ITypeBinding baseType;
                ITypeBinding elementType;
                ITypeBinding targetType = target.resolveTypeBinding();
                OpenUIStatementValidator.this.isNewExpression = false;
                target.accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(NewExpression newExpression) {
                        OpenUIStatementValidator.this.isNewExpression = true;
                        return false;
                    }
                });
                if (StatementValidator.isValidBinding(targetType) && (targetType.isReference() && AbstractBinder.typeIs(targetType.getBaseType(), EGLUICONSOLE, "CONSOLEFIELD") && !OpenUIStatementValidator.this.isNewExpression || targetType.getKind() == 2 && (elementType = targetType.getBaseType()).isReference() && AbstractBinder.typeIs(baseType = elementType.getBaseType(), EGLUICONSOLE, "CONSOLEFIELD") || targetType.isDynamicallyAccessible() || OpenUIStatementValidator.this.extendsConsoleWidget(targetType.getBaseType()))) continue;
                OpenUIStatementValidator.this.problemRequestor.acceptProblem(target.getOffset(), target.getOffset() + target.getLength(), 2, 7701, new String[]{target.getCanonicalString()});
            }
        }
    }
}

