/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PrintStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class PrintStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IProblemRequestor problemRequestor;
    private IPartBinding enclosingPart;

    public PrintStatementValidator(IProblemRequestor problemRequestor, IPartBinding enclosingPart) {
        this.problemRequestor = problemRequestor;
        this.enclosingPart = enclosingPart;
    }

    @Override
    public boolean visit(PrintStatement printStatement) {
        StatementValidator.validateIOTargetsContainer(printStatement.getIOObjects(), this.problemRequestor);
        Expression expr = printStatement.getTarget();
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        if (StatementValidator.isValidBinding(typeBinding) && typeBinding.getAnnotation(EGLUITEXT, "PrintForm") == null) {
            this.problemRequestor.acceptProblem((Node)expr, 6623, new String[]{expr.getCanonicalString()});
        }
        return false;
    }
}

