/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.dli.stmtFactory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.ForUpdateClause;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.IDliIOStatement;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.DLIDataContainerFactory;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IDLIDataContainer;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IDLISegmentRecord;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IHierarchy;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IHierarchyEntry;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IPCB;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IPCBStructure;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IPSBRecord;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IRelationship;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class DLIDefaultStatementFactory {
    IPSBRecord psb;
    IDLISegmentRecord[] segments;
    ITypeBinding[] segmentTypeBindings;
    IPCBStructure pcb;
    IProblemRequestor problemRequestor;
    private static final String[] EGLIODLI = new String[]{"egl", "io", "dli"};

    private void initialize(IPSBRecord psb, IDLISegmentRecord[] segments, IPCBStructure pcb, IDataBinding pcbBinding) {
        this.psb = psb;
        this.segments = segments == null ? new IDLISegmentRecord[0] : segments;
        this.pcb = pcb == null && pcbBinding == null ? this.getDefaultPCBRecord() : pcb;
        if (this.pcb == null) {
            if (pcbBinding == null) {
                if (segments.length == 0) {
                    this.problemRequestor.acceptProblem(0, 0, 2, 7940);
                } else {
                    this.problemRequestor.acceptProblem(0, 0, 2, 7941);
                }
            } else if (pcbBinding != IBinding.NOT_FOUND_BINDING) {
                this.problemRequestor.acceptProblem(0, 0, 2, 7942, new String[]{pcbBinding.getName()});
            }
        }
    }

    public DLIDefaultStatementFactory(IDataBinding psbBinding, IDataBinding[] segmentDataBindings, ITypeBinding[] segmentTypeBindings, IDataBinding pcbBinding, IDataBinding[] pcbParms, IProblemRequestor problemRequestor) {
        this.segmentTypeBindings = segmentTypeBindings;
        this.problemRequestor = problemRequestor;
        this.startUp(psbBinding, segmentDataBindings, pcbBinding, pcbParms);
    }

    public void startUp(IDataBinding psbBinding, IDataBinding[] segmentDataBindings, IDataBinding pcbBinding, IDataBinding[] pcbParms) {
        IDLIDataContainer dataContainer = new DLIDataContainerFactory().createDLIDataContainer(psbBinding, segmentDataBindings);
        IPSBRecord psb = null;
        psb = dataContainer.getPSB();
        this.segments = dataContainer.getSegments();
        IPCBStructure pcb = this.getPCB(psb, pcbBinding, pcbParms);
        this.initialize(psb, this.segments, pcb, pcbBinding);
    }

    private IPCBStructure getPCB(IPSBRecord psb, IDataBinding pcbBinding, IDataBinding[] pcbParms) {
        if (psb == null || pcbBinding == null || pcbBinding == IBinding.NOT_FOUND_BINDING) {
            return null;
        }
        if (pcbBinding.getKind() == 1) {
            if (pcbParms != null) {
                int i = 0;
                while (i < pcbParms.length) {
                    if (pcbBinding == pcbParms[i]) {
                        IPCBStructure[] pcbs = psb.getRealPCBs();
                        if (pcbs.length > i) {
                            return pcbs[i];
                        }
                        return null;
                    }
                    ++i;
                }
            }
            return null;
        }
        String pcbString = pcbBinding.getName();
        return psb.getPCBStructureNamed(pcbString);
    }

    public IPCBStructure getPCB(String name) {
        if (name == null || name.length() == 0) {
            return this.getDefaultPCBRecord();
        }
        if (this.psb != null) {
            return this.psb.getPCBStructureNamed(name);
        }
        return null;
    }

    public String getDLICallForDelete() {
        if (this.getPCB() == null || this.psb == null) {
            return null;
        }
        if (this.segmentTypeBindings.length != 1 || this.segmentTypeBindings[0].getAnnotation(EGLIODLI, "DLISegment") == null) {
            this.problemRequestor.acceptProblem(0, 0, 2, 7943);
            return null;
        }
        return "DLET " + this.getSegments()[0].getSegmentName();
    }

    public String getDLICallForReplace() {
        if (this.getPCB() == null || this.psb == null) {
            return null;
        }
        if (this.segmentTypeBindings.length != 1 || this.segmentTypeBindings[0].getAnnotation(EGLIODLI, "DLISegment") == null) {
            this.problemRequestor.acceptProblem(0, 0, 2, 7943);
            return null;
        }
        return "REPL " + this.getSegments()[0].getSegmentName();
    }

    public String getDLICallForGetByPosition(boolean isForUpdate, boolean isGetInParent) {
        if (this.getPCB() == null || this.psb == null) {
            return null;
        }
        if (this.getSegments().length == 0) {
            return null;
        }
        if (this.segmentTypeBindings.length > 1) {
            int i = 0;
            while (i < this.segmentTypeBindings.length) {
                if (this.segmentTypeBindings[i].getAnnotation(EGLIODLI, "DLISegment") == null) {
                    this.problemRequestor.acceptProblem(0, 0, 2, 7944);
                    return null;
                }
                ++i;
            }
        }
        IDLISegmentRecord[] segs = this.getSegments();
        ArrayList<SSA> list = new ArrayList<SSA>();
        int i = 0;
        while (i < segs.length) {
            IDLISegmentRecord segRec = segs[i];
            if (segRec != null) {
                String segName = segRec.getSegmentName();
                String commandCodes = null;
                if (i < segs.length - 1) {
                    commandCodes = "D";
                }
                list.add(new SSA(segName, commandCodes, null));
            }
            ++i;
        }
        String hold = "";
        if (isForUpdate) {
            hold = "H";
        }
        String parent = "";
        if (isGetInParent) {
            parent = "P";
        }
        String functionCall = "G" + hold + "N" + parent;
        StringBuffer buffer = new StringBuffer();
        buffer.append(functionCall);
        Iterator i2 = list.iterator();
        int j = 0;
        while (i2.hasNext()) {
            SSA ssa = (SSA)i2.next();
            if (j == 0) {
                buffer.append(" ");
            } else {
                buffer.append("\r\n   ");
                if (isForUpdate) {
                    buffer.append(" ");
                }
                if (isGetInParent) {
                    buffer.append(" ");
                }
            }
            buffer.append(ssa.toString());
            ++j;
        }
        return buffer.toString();
    }

    public String getDLICallForGetByKey(boolean isForUpdate) {
        if (this.getPCB() == null || this.psb == null) {
            return null;
        }
        if (this.getSegments().length == 0) {
            return null;
        }
        if (this.segmentTypeBindings.length == 1 && this.segmentTypeBindings[0].getKind() == 2) {
            return this.getDLICallForGetByKeyUsingArray();
        }
        int i = 0;
        while (i < this.segmentTypeBindings.length) {
            if (this.segmentTypeBindings[i].getAnnotation(EGLIODLI, "DLISegment") == null) {
                this.problemRequestor.acceptProblem(0, 0, 2, 7944);
                return null;
            }
            ++i;
        }
        return this.getDLICallForGetByKeyUsingSegments(isForUpdate);
    }

    private String getDLICallForGetByKeyUsingArray() {
        IRelationship[] relations = this.getRelationships(this.getSegments()[this.getSegments().length - 1]);
        if (relations.length == 0) {
            return null;
        }
        SSA[] ssas = this.getSSAs(relations);
        if (ssas == null || ssas.length == 0) {
            return null;
        }
        String functionCall = "GU";
        StringBuffer buffer = new StringBuffer();
        buffer.append(functionCall);
        int i = 0;
        while (i < ssas.length) {
            if (i == 0) {
                buffer.append(" ");
            } else {
                buffer.append("\r\n   ");
            }
            buffer.append(ssas[i].toString());
            ++i;
        }
        buffer.append("\r\n");
        buffer.append(this.getDLICallForGetByPosition(false, false));
        return buffer.toString();
    }

    private String getDLICallForGetByKeyUsingSegments(boolean isForUpdate) {
        IRelationship[] relations = this.getRelationships(this.getSegments()[this.getSegments().length - 1]);
        if (relations.length == 0) {
            return null;
        }
        SSA[] ssas = this.getSSAs(relations);
        if (ssas == null || ssas.length == 0) {
            return null;
        }
        String hold = "";
        if (isForUpdate) {
            hold = "H";
        }
        String functionCall = "G" + hold + "U";
        StringBuffer buffer = new StringBuffer();
        buffer.append(functionCall);
        int i = 0;
        while (i < ssas.length) {
            if (i == 0) {
                buffer.append(" ");
            } else {
                buffer.append("\r\n   ");
                if (isForUpdate) {
                    buffer.append(" ");
                }
            }
            buffer.append(ssas[i].toString());
            ++i;
        }
        return buffer.toString();
    }

    public String getDLICallForAdd() {
        IRelationship[] relations;
        if (this.getPCB() == null || this.psb == null) {
            return null;
        }
        if (this.getSegments().length == 0) {
            return null;
        }
        if (this.segmentTypeBindings.length > 1) {
            int i = 0;
            while (i < this.segmentTypeBindings.length) {
                if (this.segmentTypeBindings[i].getAnnotation(EGLIODLI, "DLISegment") == null) {
                    this.problemRequestor.acceptProblem(0, 0, 2, 7944);
                    return null;
                }
                ++i;
            }
        }
        if ((relations = this.getRelationships(this.getSegments()[this.getSegments().length - 1])).length == 0) {
            return null;
        }
        SSA[] ssas = this.getSSAs(relations);
        if (ssas == null || ssas.length == 0) {
            return null;
        }
        boolean foundD = false;
        int i = 0;
        while (i < ssas.length) {
            if (ssas[i].getCommandCodes() != null && ssas[i].getCommandCodes().indexOf("D") != -1) {
                foundD = true;
            }
            if (foundD) {
                ssas[i].setCondition(null);
            }
            ++i;
        }
        SSA lastSSA = ssas[ssas.length - 1];
        lastSSA.setCondition(null);
        String functionCall = "ISRT";
        StringBuffer buffer = new StringBuffer();
        buffer.append(functionCall);
        int i2 = 0;
        while (i2 < ssas.length) {
            if (i2 == 0) {
                buffer.append(" ");
            } else {
                buffer.append("\r\n     ");
            }
            buffer.append(ssas[i2].toString());
            ++i2;
        }
        return buffer.toString();
    }

    private SSA[] getSSAs(IRelationship[] relations) {
        ArrayList<SSA> list = new ArrayList<SSA>();
        int i = 0;
        while (i < relations.length) {
            SSA ssa = this.getSSA(relations[i], i + 1 == relations.length);
            if (ssa != null) {
                list.add(ssa);
            }
            ++i;
        }
        return list.toArray(new SSA[list.size()]);
    }

    private SSA getSSA(IRelationship relation, boolean last) {
        if (relation == null || relation.getSegmentRecord() == null) {
            return null;
        }
        IDLISegmentRecord segment = this.getSegment(relation.getSegmentRecord());
        String left = null;
        String right = null;
        if (relation.getParentRecord() == null && this.getPCB().getPCB().getSecondaryIndex() != null) {
            left = this.getPCB().getPCB().getSecondaryIndex();
        } else if (segment.getKeyItemFieldName() != null) {
            left = segment.getKeyItemFieldName();
        }
        if (relation.getParentRecord() == null && this.getPCB().getPCB().getSecondaryIndexItemName() != null) {
            right = this.getPCB().getPCB().getSecondaryIndexItemName();
        } else if (segment.getKeyItemName() != null) {
            right = String.valueOf(segment.getHostVarQualifier()) + "." + segment.getKeyItemName();
        }
        String segmentName = relation.getSegmentRecord().getSegmentName();
        String commandCode = null;
        if (segment != relation.getSegmentRecord() && !last) {
            commandCode = "D";
        }
        String condition = null;
        if (left != null && right != null) {
            condition = String.valueOf(left) + " = :" + right;
        }
        return new SSA(segmentName, commandCode, condition);
    }

    private IDLISegmentRecord getSegment(IDLISegmentRecord seg) {
        int i = 0;
        while (i < this.getSegments().length) {
            IDLISegmentRecord test = this.getSegments()[i];
            if (seg.typeMatches(test.getType())) {
                return test;
            }
            ++i;
        }
        return seg;
    }

    public IPCBStructure getDefaultPCBRecord() {
        if (this.psb == null) {
            return null;
        }
        IPCBStructure[] pcbs = this.psb.getPCBs();
        int i = 0;
        while (i < pcbs.length) {
            if (this.isDefaultPCB(pcbs[i])) {
                return pcbs[i];
            }
            ++i;
        }
        return null;
    }

    private boolean isDefaultPCB(IPCBStructure pcb) {
        if (this.getSegments() == null || this.getSegments().length < 1) {
            return false;
        }
        IDLISegmentRecord segment = this.getSegments()[this.getSegments().length - 1];
        if (segment == null) {
            return false;
        }
        IHierarchy hierarchy = this.getHierarchy(segment, pcb);
        if (hierarchy == null) {
            return false;
        }
        int level = -1;
        int i = 0;
        while (i < this.getSegments().length) {
            segment = this.getSegments()[i];
            if (segment == null) {
                return false;
            }
            IHierarchyEntry entry = hierarchy.getEntry(segment);
            if (entry == null) {
                return false;
            }
            if (entry.getLevel() <= level) {
                return false;
            }
            level = entry.getLevel();
            ++i;
        }
        return true;
    }

    private boolean pcbContainsSegment(IPCBStructure pcb, IDLISegmentRecord segment) {
        return this.getRelationship(pcb, segment) != null;
    }

    private IRelationship getRelationship(IPCBStructure pcb, IDLISegmentRecord segment) {
        if (segment == null || pcb == null || pcb.getPCB() == null || pcb.getPCB().getHierarchy() == null) {
            return null;
        }
        IRelationship[] hierarchy = pcb.getPCB().getHierarchy();
        int i = 0;
        while (i < hierarchy.length) {
            if (hierarchy[i].getSegmentRecord() != null && segment.typeMatches(hierarchy[i].getSegmentRecord().getType())) {
                return hierarchy[i];
            }
            ++i;
        }
        return null;
    }

    private IRelationship getRelationship(IDLISegmentRecord segment) {
        return this.getRelationship(this.getPCB(), segment);
    }

    private IRelationship[] getRelationships(IDLISegmentRecord segment) {
        IRelationship[] result = this.getRelationships(segment, this.getPCB());
        if (result.length == 0) {
            String pcbName = "";
            if (this.getPCB() != null) {
                pcbName = this.getPCB().getName();
            }
            this.problemRequestor.acceptProblem(0, 0, 2, 7945, new String[]{pcbName, segment.getSegmentName()});
        }
        return result;
    }

    private IRelationship[] getRelationships(IDLISegmentRecord segment, IPCBStructure pcbStructure) {
        ArrayList<IRelationship> list = new ArrayList<IRelationship>();
        IDLISegmentRecord currentSegment = segment;
        while (currentSegment != null) {
            IRelationship r = this.getRelationship(pcbStructure, currentSegment);
            if (r == null || list.contains(r)) {
                currentSegment = null;
                continue;
            }
            list.add(0, r);
            currentSegment = r.getParentRecord();
        }
        return list.toArray(new IRelationship[list.size()]);
    }

    public IPCBStructure getPCB() {
        return this.pcb;
    }

    public IDLISegmentRecord[] getSegments() {
        if (this.segments == null) {
            this.segments = new IDLISegmentRecord[0];
        }
        return this.segments;
    }

    public IDLISegmentRecord getSegment(String segmentName) {
        if (segmentName == null) {
            return null;
        }
        String internedSegmentName = InternUtil.intern((String)segmentName);
        IDLISegmentRecord[] segments = this.getSegments();
        int i = 0;
        while (i < segments.length) {
            IDLISegmentRecord segment = segments[i];
            if (internedSegmentName == InternUtil.intern((String)segment.getSegmentName())) {
                return segment;
            }
            ++i;
        }
        return null;
    }

    public IPSBRecord getPsb() {
        return this.psb;
    }

    public IHierarchy getHierarchy(IDLISegmentRecord segment) {
        return this.getHierarchy(segment, this.getPCB());
    }

    public IHierarchy getHierarchy(IDLISegmentRecord segment, IPCBStructure pcbStructure) {
        if (segment == null || pcbStructure == null) {
            return null;
        }
        IRelationship[] relations = this.getRelationships(segment, pcbStructure);
        if (relations != null) {
            return new Hierarchy(relations);
        }
        return null;
    }

    public IHierarchy getHierarchy() {
        return this.getHierarchy(this.getPCB());
    }

    public IHierarchy getHierarchy(IPCBStructure pcbStructure) {
        if (pcbStructure == null || pcbStructure.getPCB() == null) {
            return null;
        }
        return new Hierarchy(pcbStructure.getPCB());
    }

    public String getDLICallForStatement(IDliIOStatement statement) {
        final String[] dliCall = new String[1];
        statement.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(AddStatement statement) {
                dliCall[0] = DLIDefaultStatementFactory.this.getDLICallForAdd();
                return false;
            }

            @Override
            public boolean visit(DeleteStatement statement) {
                dliCall[0] = DLIDefaultStatementFactory.this.getDLICallForDelete();
                return false;
            }

            @Override
            public boolean visit(GetByKeyStatement statement) {
                final boolean[] forUpdate = new boolean[1];
                statement.accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(GetByKeyStatement getByKeyStatement) {
                        return true;
                    }

                    @Override
                    public boolean visit(ForUpdateClause forUpdateClause) {
                        forUpdate[0] = true;
                        return false;
                    }
                });
                dliCall[0] = DLIDefaultStatementFactory.this.getDLICallForGetByKey(forUpdate[0]);
                return false;
            }

            @Override
            public boolean visit(GetByPositionStatement statement) {
                final boolean[] forUpdate = new boolean[1];
                statement.accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(GetByPositionStatement getByPositionStatement) {
                        return true;
                    }

                    @Override
                    public boolean visit(ForUpdateClause forUpdateClause) {
                        forUpdate[0] = true;
                        return false;
                    }
                });
                dliCall[0] = DLIDefaultStatementFactory.this.getDLICallForGetByPosition(forUpdate[0], statement.isGetInParent());
                return false;
            }

            @Override
            public boolean visit(ReplaceStatement statement) {
                dliCall[0] = DLIDefaultStatementFactory.this.getDLICallForReplace();
                return false;
            }
        });
        return dliCall[0];
    }

    public IProblemRequestor getProblemRequestor() {
        return this.problemRequestor;
    }

    private class Hierarchy
    implements IHierarchy {
        IHierarchyEntry[] entries;

        public Hierarchy(IRelationship[] relations) {
            ArrayList<HierarchyEntry> list = new ArrayList<HierarchyEntry>();
            if (relations != null) {
                HierarchyEntry previous = null;
                int i = 0;
                while (i < relations.length) {
                    HierarchyEntry entry = new HierarchyEntry(relations[i], previous, i);
                    list.add(entry);
                    if (previous != null) {
                        previous.addChild(entry);
                    }
                    previous = entry;
                    ++i;
                }
            }
            this.entries = list.toArray(new IHierarchyEntry[list.size()]);
        }

        public Hierarchy(IPCB pcb) {
            IRelationship[] relations;
            HierarchyEntry root;
            ArrayList<HierarchyEntry> list = new ArrayList<HierarchyEntry>();
            if (pcb != null && pcb.getHierarchy() != null && (root = this.getHierarchyEntryForRoot(relations = pcb.getHierarchy())) != null) {
                list.add(root);
                ArrayList<HierarchyEntry> entriesNeedingChildren = new ArrayList<HierarchyEntry>();
                entriesNeedingChildren.add(root);
                this.buildHierarchy(list, entriesNeedingChildren, relations);
            }
            this.entries = list.toArray(new IHierarchyEntry[list.size()]);
        }

        private HierarchyEntry getHierarchyEntryForRoot(IRelationship[] relations) {
            HierarchyEntry root = null;
            int i = 0;
            while (i < relations.length) {
                if (relations[i].getSegmentRecord() != null && relations[i].getParentRecord() == null) {
                    if (root == null) {
                        root = new HierarchyEntry(relations[i], null, 0);
                    } else {
                        return null;
                    }
                }
                ++i;
            }
            return root;
        }

        private void buildHierarchy(List list, List entriesNeedingChildren, IRelationship[] relations) {
            if (entriesNeedingChildren.size() == 0) {
                return;
            }
            ArrayList newList = new ArrayList();
            for (HierarchyEntry entry : entriesNeedingChildren) {
                List children;
                boolean error = this.addChildren(entry, list, children = this.findChildren(entry, relations));
                if (error) {
                    list.clear();
                    return;
                }
                newList.addAll(children);
            }
            this.buildHierarchy(list, newList, relations);
        }

        private boolean addChildren(HierarchyEntry entry, List list, List children) {
            for (HierarchyEntry child : children) {
                if (this.containsEntry(list, child)) {
                    return true;
                }
                entry.addChild(child);
            }
            list.addAll(children);
            return false;
        }

        private boolean containsEntry(List list, HierarchyEntry entry) {
            if (entry.getRelationship().getSegmentRecord() == null) {
                return false;
            }
            for (HierarchyEntry next : list) {
                if (next.getRelationship().getSegmentRecord() == null || !next.getRelationship().getSegmentRecord().typeMatches(entry.getRelationship().getSegmentRecord().getType())) continue;
                return true;
            }
            return false;
        }

        private List findChildren(HierarchyEntry entry, IRelationship[] relations) {
            ArrayList<HierarchyEntry> list = new ArrayList<HierarchyEntry>();
            if (entry.getRelationship().getSegmentRecord() == null) {
                return list;
            }
            int i = 0;
            while (i < relations.length) {
                if (relations[i].getParentRecord() != null && entry.getRelationship().getSegmentRecord().typeMatches(relations[i].getParentRecord().getType())) {
                    list.add(new HierarchyEntry(relations[i], entry, entry.getLevel() + 1));
                }
                ++i;
            }
            return list;
        }

        @Override
        public IHierarchyEntry[] getEntries() {
            return this.entries;
        }

        @Override
        public IHierarchyEntry getEntry(IDLISegmentRecord segment) {
            if (segment == null) {
                return null;
            }
            if (this.entries != null) {
                int i = 0;
                while (i < this.entries.length) {
                    if (this.entries[i].getSegmentRecord() != null && this.entries[i].getSegmentRecord().typeMatches(segment.getType())) {
                        return this.entries[i];
                    }
                    ++i;
                }
            }
            return null;
        }

        @Override
        public IHierarchyEntry getEntry(String segmentName) {
            if (this.entries != null && segmentName != null) {
                String internedSegmentName = InternUtil.intern((String)segmentName);
                int i = 0;
                while (i < this.entries.length) {
                    if (segmentName != null && this.entries[i].getSegmentName() != null && internedSegmentName == InternUtil.intern((String)this.entries[i].getSegmentName())) {
                        return this.entries[i];
                    }
                    ++i;
                }
            }
            return null;
        }
    }

    private class HierarchyEntry
    implements IHierarchyEntry {
        IRelationship relationship;
        IHierarchyEntry parent;
        List children = new ArrayList();
        int level;

        public HierarchyEntry(IRelationship relationship, IHierarchyEntry parent, int level) {
            this.relationship = relationship;
            this.parent = parent;
            this.level = level;
        }

        @Override
        public List getChildren() {
            return this.children;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public IHierarchyEntry getParent() {
            return this.parent;
        }

        @Override
        public IRelationship getRelationship() {
            return this.relationship;
        }

        public void addChild(IHierarchyEntry child) {
            this.children.add(child);
        }

        @Override
        public String getSegmentName() {
            if (this.getRelationship() != null && this.getRelationship().getSegmentRecord() != null) {
                return this.getRelationship().getSegmentRecord().getSegmentName();
            }
            return null;
        }

        @Override
        public IDLISegmentRecord getSegmentRecord() {
            if (this.getRelationship() != null) {
                return this.getRelationship().getSegmentRecord();
            }
            return null;
        }
    }

    private class SSA {
        String segmentName;
        String commandCodes;
        String condition;

        public SSA(String segmentName, String commandCodes, String condition) {
            this.segmentName = segmentName;
            this.commandCodes = commandCodes;
            this.condition = condition;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            if (this.segmentName != null) {
                buffer.append(this.segmentName);
            }
            if (this.commandCodes != null) {
                buffer.append("*" + this.commandCodes);
            }
            if (this.condition != null) {
                buffer.append(" (");
                buffer.append(this.condition);
                buffer.append(")");
            }
            return buffer.toString();
        }

        public String getCommandCodes() {
            return this.commandCodes;
        }

        public void setCommandCodes(String commandCodes) {
            this.commandCodes = commandCodes;
        }

        public String getCondition() {
            return this.condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public String getSegmentName() {
            return this.segmentName;
        }

        public void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }
    }
}

