/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.io.IIOBufferReader;
import org.eclipse.edt.compiler.internal.io.IIOBufferWriter;

public class IOBuffer {
    private static final int MAX_NUMBER_OF_ENTRIES = 10000;
    private HashMap modifiedEntries = new HashMap();
    private HashSet removedEntries = new HashSet();
    private IIOBufferReader reader;
    private IIOBufferWriter writer;

    public IOBuffer(IIOBufferReader reader, IIOBufferWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    public int size() {
        return this.modifiedEntries.size() + this.removedEntries.size();
    }

    public void remove(String key) {
        this.removedEntries.add(key);
        if (this.modifiedEntries.containsKey(key)) {
            this.modifiedEntries.remove(key);
        }
        if (this.size() > 10000) {
            this.writeCache();
        }
    }

    public void put(String key, Object value) {
        IOBufferEntry entry = new IOBufferEntry(value);
        this.modifiedEntries.put(key, entry);
        if (this.removedEntries.contains(key)) {
            this.removedEntries.remove(key);
        }
        if (this.size() > 10000) {
            this.writeCache();
        }
    }

    public Object get(String key) {
        Object result = null;
        if (this.removedEntries.contains(key)) {
            return null;
        }
        IOBufferEntry entry = (IOBufferEntry)this.modifiedEntries.get(key);
        if (entry != null) {
            return entry.getEntry();
        }
        try {
            result = this.reader.readEntry(key);
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
        return result;
    }

    public void writeCache() {
        block10: {
            if (this.hasChanges()) {
                try {
                    List entries = this.reader.getEntries();
                    if (this.allEntriesRemoved(entries)) {
                        this.writer.allEntriesRemoved();
                        break block10;
                    }
                    try {
                        this.writer.beginWriting();
                        for (String removedKey : this.removedEntries) {
                            if (!entries.contains(removedKey)) continue;
                            entries.remove(removedKey);
                        }
                        for (String entryName : entries) {
                            if (this.modifiedEntries.containsKey(entryName)) continue;
                            this.writer.writeEntry(entryName, this.reader.readEntry(entryName));
                        }
                        Set cacheEntryKeySet = this.modifiedEntries.keySet();
                        for (String entryName : cacheEntryKeySet) {
                            this.writer.writeEntry(entryName, ((IOBufferEntry)this.modifiedEntries.get(entryName)).getEntry());
                        }
                    }
                    finally {
                        this.writer.finishWriting();
                        this.modifiedEntries.clear();
                        this.removedEntries.clear();
                    }
                }
                catch (IOException e) {
                    throw new BuildException(e);
                }
            }
        }
    }

    private boolean hasChanges() {
        return this.modifiedEntries.size() > 0 || this.removedEntries.size() > 0;
    }

    private boolean allEntriesRemoved(List entries) {
        return this.removedEntries.size() > 0 && this.removedEntries.size() == entries.size();
    }

    private class IOBufferEntry {
        private Object entry;

        public IOBufferEntry(Object entry) {
            this.entry = entry;
        }

        public Object getEntry() {
            return this.entry;
        }
    }
}

