/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sql;

import org.eclipse.edt.compiler.internal.sql.Token;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLPrimeToken;

public class StringToken
extends Token {
    public StringToken() {
    }

    public StringToken(String string) {
        super(StringToken.trim(string));
        if (this.string.length() == 0) {
            this.string = " ";
        }
        this.setStartOffset(0);
        this.setEndOffset(string.length() - 1);
    }

    public StringToken(EGLPrimeToken token) {
        this.string = token.getText();
        this.setStartOffset(token.getOffset());
        this.setEndOffset(token.getOffset() + token.getText().length() - 1);
    }

    public void append(StringToken token) {
        StringBuffer buff = new StringBuffer(this.string);
        if (this.getEndOffset() + 1 != token.getStartOffset()) {
            buff.append(" ");
        }
        buff.append(token.string);
        this.string = buff.toString();
        this.setEndOffset(token.getStartOffset() + token.string.length() - 1);
    }

    @Override
    public boolean isNonQuotedStringToken() {
        return true;
    }

    @Override
    public boolean isStringToken() {
        return true;
    }

    public static String trim(String string) {
        int len = string.length();
        int st = 0;
        char[] val = string.toCharArray();
        while (st < len && val[st] <= ' ') {
            ++st;
        }
        while (st < len && val[len - 1] <= ' ') {
            --len;
        }
        String pre = "";
        String post = "";
        if (st > 0) {
            pre = " ";
        }
        if (len < string.length()) {
            post = " ";
        }
        StringBuffer buff = new StringBuffer();
        buff.append(pre);
        buff.append(string.substring(st, len));
        buff.append(post);
        return buff.toString();
    }

    @Override
    public String getSQLString() {
        return this.string;
    }
}

