/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sql.statements;

import java.util.Iterator;
import java.util.List;

public class EGLSQLClauseFactory {
    public static String addItemNamesToClause(String clause, String[] structureItemNames, String ioObjectName) {
        if (structureItemNames == null) {
            return null;
        }
        int numItemNames = structureItemNames.length;
        int lineLength = 0;
        int i = 0;
        while (i < numItemNames) {
            String temp = String.valueOf(ioObjectName) + "." + structureItemNames[i];
            if (i + 1 < numItemNames) {
                temp = String.valueOf(temp) + ", ";
            }
            if ((lineLength += temp.length()) > 56 && i > 0) {
                clause = String.valueOf(clause) + "\r\n" + "\t";
                lineLength = temp.length();
            }
            clause = String.valueOf(clause) + temp;
            ++i;
        }
        return clause;
    }

    public static String addHostVariableNamesToClause(String clause, String[] structureItemNames, String ioObjectName) {
        if (structureItemNames == null) {
            return null;
        }
        int numItemNames = structureItemNames.length;
        int lineLength = 0;
        int i = 0;
        while (i < numItemNames) {
            String temp = "?";
            if (i + 1 < numItemNames) {
                temp = String.valueOf(temp) + ", ";
            }
            if ((lineLength += temp.length()) > 56 && i > 0) {
                clause = String.valueOf(clause) + "\r\n" + "\t";
                lineLength = temp.length();
            }
            clause = String.valueOf(clause) + temp;
            ++i;
        }
        return clause;
    }

    public static String addNamesToClause(String clause, String[] names) {
        if (names == null) {
            return null;
        }
        int numNames = names.length;
        int lineLength = 0;
        int i = 0;
        while (i < numNames) {
            String temp = names[i];
            temp = EGLSQLClauseFactory.removeEscapeCharactersFromName(temp);
            if (i + 1 < numNames) {
                temp = String.valueOf(temp) + ", ";
            }
            if ((lineLength += temp.length()) > 56 && i > 0) {
                clause = String.valueOf(clause) + "\r\n" + "\t";
                lineLength = temp.length();
            }
            clause = String.valueOf(clause) + temp;
            ++i;
        }
        return clause;
    }

    public static String addNamesToClause(String clause, String[] names, String[] labels) {
        if (names == null) {
            return null;
        }
        int numNames = names.length;
        int lineLength = 0;
        int i = 0;
        while (i < numNames) {
            String temp = names[i];
            temp = EGLSQLClauseFactory.removeEscapeCharactersFromName(temp);
            String label = labels[i];
            if (label != null && numNames > 1) {
                label = EGLSQLClauseFactory.removeEscapeCharactersFromName(label);
                temp = String.valueOf(temp) + " " + label;
            }
            if (i + 1 < numNames) {
                temp = String.valueOf(temp) + ", ";
            }
            if ((lineLength += temp.length()) > 56 && i > 0) {
                clause = String.valueOf(clause) + "\r\n" + "\t";
                lineLength = temp.length();
            }
            clause = String.valueOf(clause) + temp;
            ++i;
        }
        return clause;
    }

    public static String createDefaultColumnsClause(String[] columnNames) {
        if (columnNames == null) {
            return null;
        }
        String columnsClause = "\t(";
        columnsClause = EGLSQLClauseFactory.addNamesToClause(columnsClause, columnNames);
        return String.valueOf(columnsClause) + ")" + "\r\n";
    }

    public static String createDefaultDeleteFromClause(String[] tableNames, String[] labels) {
        if (tableNames == null) {
            return null;
        }
        String deleteFromClause = "delete from ";
        deleteFromClause = EGLSQLClauseFactory.addNamesToClause(deleteFromClause, tableNames, labels);
        return String.valueOf(deleteFromClause) + "\r\n";
    }

    public static String createDefaultForUpdateOfClause(String[] columnNames) {
        if (columnNames == null) {
            return null;
        }
        String forUpdateOfClause = "for update of\r\n\t";
        forUpdateOfClause = EGLSQLClauseFactory.addNamesToClause(forUpdateOfClause, columnNames);
        return String.valueOf(forUpdateOfClause) + "\r\n";
    }

    public static String createDefaultFromClause(String[] tableNames, String[] tableLabels) {
        if (tableNames == null) {
            return null;
        }
        String fromClause = "from ";
        int numTables = tableNames.length;
        int lineLength = fromClause.length();
        int i = 0;
        while (i < numTables) {
            String tableSpec = tableNames[i];
            tableSpec = EGLSQLClauseFactory.removeEscapeCharactersFromName(tableSpec);
            String tableLabel = tableLabels[i];
            if ((tableLabel = EGLSQLClauseFactory.removeEscapeCharactersFromName(tableLabel)) != null && numTables > 1) {
                tableSpec = String.valueOf(tableSpec) + " " + tableLabel;
            }
            if (i + 1 < numTables) {
                tableSpec = String.valueOf(tableSpec) + ", ";
            }
            if ((lineLength += tableSpec.length()) > 56) {
                fromClause = String.valueOf(fromClause) + "\r\n" + "\t";
                lineLength = 0;
            }
            fromClause = String.valueOf(fromClause) + tableSpec;
            ++i;
        }
        return String.valueOf(fromClause) + "\r\n";
    }

    public static String createDefaultInsertIntoClause(String[] tableNames) {
        if (tableNames == null) {
            return null;
        }
        String insertIntoClause = "insert into ";
        insertIntoClause = EGLSQLClauseFactory.addNamesToClause(insertIntoClause, tableNames);
        return String.valueOf(insertIntoClause) + "\r\n";
    }

    public static String createDefaultIntoClause(String[] structureItemNames, String ioObjectName, boolean buildIntoForEditor) {
        if (structureItemNames == null) {
            return null;
        }
        if (!buildIntoForEditor) {
            String intoClause = "into\r\n\t";
            intoClause = EGLSQLClauseFactory.addHostVariableNamesToClause(intoClause, structureItemNames, ioObjectName);
            return String.valueOf(intoClause) + "\r\n";
        }
        String intoClause = "into ";
        intoClause = EGLSQLClauseFactory.addItemNamesToClause(intoClause, structureItemNames, ioObjectName);
        return intoClause;
    }

    public static String createDefaultOrderByClause(String[][] keyItemAndColumnNames) {
        if (keyItemAndColumnNames == null || keyItemAndColumnNames.length == 0) {
            return null;
        }
        String orderByClause = "order by\r\n\t";
        int lineLength = 0;
        int i = 0;
        while (i < keyItemAndColumnNames.length) {
            String temp = keyItemAndColumnNames[i][1];
            temp = EGLSQLClauseFactory.removeEscapeCharactersFromName(temp);
            if (i + 1 < keyItemAndColumnNames.length) {
                temp = String.valueOf(temp) + ", ";
            }
            if ((lineLength += temp.length()) > 56 && i > 0) {
                orderByClause = String.valueOf(orderByClause) + "\r\n" + "\t";
                lineLength = temp.length();
            }
            orderByClause = String.valueOf(orderByClause) + temp;
            ++i;
        }
        orderByClause = String.valueOf(orderByClause) + " " + "asc";
        return String.valueOf(orderByClause) + "\r\n";
    }

    public static String createDefaultSelectClause(String[] columnNames) {
        if (columnNames == null) {
            return null;
        }
        String selectClause = "select\r\n\t";
        selectClause = EGLSQLClauseFactory.addNamesToClause(selectClause, columnNames);
        return String.valueOf(selectClause) + "\r\n";
    }

    public static String createDefaultSetClause(String[] columnNames, String[] structureItemNames, String ioObjectName) {
        if (columnNames == null || structureItemNames == null) {
            return null;
        }
        String setClause = "set\r\n";
        int numColumnNames = columnNames.length;
        int i = 0;
        while (i < numColumnNames) {
            String columnName = EGLSQLClauseFactory.removeEscapeCharactersFromName(columnNames[i]);
            setClause = String.valueOf(setClause) + "\t" + columnName + " = " + "?";
            if (i + 1 < numColumnNames) {
                setClause = String.valueOf(setClause) + "," + "\r\n";
            }
            ++i;
        }
        return String.valueOf(setClause) + "\r\n";
    }

    public static String createDefaultUpdateClause(String[] tableNames, String[] labels) {
        if (tableNames == null) {
            return null;
        }
        String updateClause = "update ";
        updateClause = EGLSQLClauseFactory.addNamesToClause(updateClause, tableNames, labels);
        return String.valueOf(updateClause) + "\r\n";
    }

    public static String createDefaultValuesClause(String[] structureItemNames, String ioObjectName) {
        if (structureItemNames == null) {
            return null;
        }
        String valuesClause = "values\r\n\t(";
        valuesClause = EGLSQLClauseFactory.addHostVariableNamesToClause(valuesClause, structureItemNames, ioObjectName);
        return String.valueOf(valuesClause) + ")" + "\r\n";
    }

    public static String createEglUsingClauseForGet(String[][] keyItemAndColumnNames, String ioObjectName) {
        if (keyItemAndColumnNames == null) {
            return null;
        }
        String usingClause = "using ";
        int i = 0;
        while (i < keyItemAndColumnNames.length) {
            if (i > 0) {
                usingClause = String.valueOf(usingClause) + ",";
            }
            usingClause = String.valueOf(usingClause) + ioObjectName + "." + keyItemAndColumnNames[i][0];
            ++i;
        }
        return String.valueOf(usingClause) + " " + "\r\n";
    }

    public static String createDefaultWhereClause(String defaultSelectConditions, String[][] keyItemAndColumnNames, String ioType, String ioObjectName, boolean isDynamicArrayRecord, boolean useRecordKeys) {
        String whereClause = "where\r\n\t";
        String whereString = null;
        whereString = ioType.equalsIgnoreCase("get") || ioType.equalsIgnoreCase("get forUpdate") || ioType.equalsIgnoreCase("replace") || ioType.equalsIgnoreCase("delete") ? EGLSQLClauseFactory.createDefaultWhereForGetByKey(defaultSelectConditions, keyItemAndColumnNames, ioObjectName, isDynamicArrayRecord, useRecordKeys) : EGLSQLClauseFactory.createDefaultWhereForOpen(defaultSelectConditions, keyItemAndColumnNames, ioObjectName, useRecordKeys);
        if (whereString == null || whereString.trim().length() == 0) {
            return null;
        }
        whereClause = String.valueOf(whereClause) + whereString;
        return String.valueOf(whereClause) + "\r\n";
    }

    private static String createDefaultWhereForGetByKey(String defaultSelectConditions, String[][] keyItemAndColumnNames, String ioObjectName, boolean isDynamicArrayRecord, boolean useRecordKeys) {
        String whereClause = null;
        if (defaultSelectConditions != null || keyItemAndColumnNames.length > 0) {
            whereClause = new String();
        }
        boolean recordKeysInvalid = false;
        if (keyItemAndColumnNames.length > 0 && isDynamicArrayRecord && useRecordKeys) {
            recordKeysInvalid = true;
        }
        if (defaultSelectConditions != null) {
            whereClause = keyItemAndColumnNames.length == 0 || recordKeysInvalid ? String.valueOf(whereClause) + defaultSelectConditions : String.valueOf(whereClause) + "(" + defaultSelectConditions + ")";
        }
        if (isDynamicArrayRecord && !useRecordKeys) {
            whereClause = EGLSQLClauseFactory.addKeyClausesToGetResultSet(whereClause, defaultSelectConditions, keyItemAndColumnNames);
        } else if (!recordKeysInvalid && defaultSelectConditions == null) {
            whereClause = EGLSQLClauseFactory.addKeyClausesToGetSingleRow(whereClause, defaultSelectConditions, keyItemAndColumnNames, ioObjectName, useRecordKeys);
        }
        return whereClause;
    }

    private static String addKeyClausesToGetResultSet(String whereClause, String defaultSelectConditions, String[][] keyItemAndColumnNames) {
        int i = 0;
        while (i < keyItemAndColumnNames.length) {
            if (i == 0) {
                if (defaultSelectConditions != null) {
                    whereClause = String.valueOf(whereClause) + "\r\n" + "\t" + "\t" + "and" + " ";
                }
                if (keyItemAndColumnNames.length > 1) {
                    whereClause = String.valueOf(whereClause) + "(";
                }
            } else {
                whereClause = String.valueOf(whereClause) + "\r\n" + "\t" + "\t";
                if (defaultSelectConditions != null) {
                    whereClause = String.valueOf(whereClause) + "\t";
                }
                whereClause = String.valueOf(whereClause) + "or" + " ";
            }
            int len = keyItemAndColumnNames.length - i;
            if (keyItemAndColumnNames.length > 1) {
                whereClause = String.valueOf(whereClause) + "(";
            }
            int j = 0;
            while (j < len) {
                if (j != 0) {
                    whereClause = String.valueOf(whereClause) + " " + "and" + " ";
                }
                String columnName = EGLSQLClauseFactory.removeEscapeCharactersFromName(keyItemAndColumnNames[j][1]);
                whereClause = String.valueOf(whereClause) + columnName;
                whereClause = i == 0 && j == keyItemAndColumnNames.length - 1 ? String.valueOf(whereClause) + " >= " : (j == len - 1 ? String.valueOf(whereClause) + " > " : String.valueOf(whereClause) + " = ");
                whereClause = String.valueOf(whereClause) + ":" + keyItemAndColumnNames[j][0];
                ++j;
            }
            if (keyItemAndColumnNames.length > 1) {
                whereClause = String.valueOf(whereClause) + ")";
            }
            ++i;
        }
        if (keyItemAndColumnNames.length > 1) {
            whereClause = String.valueOf(whereClause) + ")";
        }
        return whereClause;
    }

    private static String addKeyClausesToGetSingleRow(String whereClause, String defaultSelectConditions, String[][] keyItemAndColumnNames, String ioObjectName, boolean useRecordKeys) {
        int i = 0;
        while (i < keyItemAndColumnNames.length) {
            if (i == 0 && defaultSelectConditions != null || i > 0) {
                whereClause = String.valueOf(whereClause) + "\r\n" + "\t" + "\t" + "and" + " ";
            }
            String columnName = EGLSQLClauseFactory.removeEscapeCharactersFromName(keyItemAndColumnNames[i][1]);
            whereClause = String.valueOf(whereClause) + columnName + " = ";
            whereClause = useRecordKeys ? String.valueOf(whereClause) + "?" : String.valueOf(whereClause) + ":" + keyItemAndColumnNames[i][0];
            ++i;
        }
        return whereClause;
    }

    private static String createDefaultWhereForOpen(String defaultSelectConditions, String[][] keyItemAndColumnNames, String ioObjectName, boolean useRecordKeys) {
        String whereClause = null;
        whereClause = new String();
        if (defaultSelectConditions != null) {
            whereClause = keyItemAndColumnNames.length == 1 || !useRecordKeys && keyItemAndColumnNames.length > 1 ? String.valueOf(whereClause) + "(" + defaultSelectConditions + ")" : String.valueOf(whereClause) + defaultSelectConditions;
        }
        whereClause = useRecordKeys ? EGLSQLClauseFactory.addKeyClausesToGetResultSetBasedOnVAGenRules(whereClause, defaultSelectConditions, keyItemAndColumnNames, ioObjectName, useRecordKeys) : EGLSQLClauseFactory.addKeyClausesToGetResultSet(whereClause, defaultSelectConditions, keyItemAndColumnNames);
        return whereClause;
    }

    private static String addKeyClausesToGetResultSetBasedOnVAGenRules(String whereClause, String defaultSelectConditions, String[][] keyItemAndColumnNames, String ioObjectName, boolean useRecordKeys) {
        if (keyItemAndColumnNames.length == 1) {
            if (defaultSelectConditions != null) {
                whereClause = String.valueOf(whereClause) + "\r\n" + "\t" + "\t" + "and" + " ";
            }
            String columnName = EGLSQLClauseFactory.removeEscapeCharactersFromName(keyItemAndColumnNames[0][1]);
            whereClause = String.valueOf(whereClause) + columnName + " = " + " " + "?";
        }
        return whereClause;
    }

    public static String createIntoClauseFromItemNameList(List items) {
        if (items == null) {
            return null;
        }
        String intoClause = "into\r\n\t";
        int lineLength = 0;
        int i = 0;
        while (i < items.size()) {
            String itemName = (String)items.get(i);
            String line = ":" + itemName;
            if (i + 1 < items.size()) {
                line = String.valueOf(line) + ", ";
            }
            if ((lineLength += line.length()) > 56 && i > 0) {
                intoClause = String.valueOf(intoClause) + "\r\n" + "\t";
                lineLength = line.length();
            }
            intoClause = String.valueOf(intoClause) + line;
            ++i;
        }
        return String.valueOf(intoClause) + "\r\n";
    }

    public static String createIntoClauseFromItemNameList(List items, String recordVariableName) {
        if (items == null) {
            return null;
        }
        String intoClause = "into ";
        Iterator itemItr = items.iterator();
        while (itemItr.hasNext()) {
            String name = (String)itemItr.next();
            intoClause = String.valueOf(intoClause) + ":" + recordVariableName + "." + name;
            if (!itemItr.hasNext()) continue;
            intoClause = String.valueOf(intoClause) + ", ";
        }
        return String.valueOf(intoClause) + "\r\n";
    }

    public static String createIntoClauseFromItemNameListForEditor(List items, String recordVariableName) {
        if (items == null) {
            return null;
        }
        String intoClause = "into ";
        int lineLength = 0;
        int i = 0;
        while (i < items.size()) {
            String name = (String)items.get(i);
            String line = String.valueOf(recordVariableName) + "." + name;
            if (i + 1 < items.size()) {
                line = String.valueOf(line) + ", ";
            }
            if ((lineLength += line.length()) > 56 && i > 0) {
                intoClause = String.valueOf(intoClause) + "\r\n" + "\t";
                lineLength = line.length();
            }
            intoClause = String.valueOf(intoClause) + line;
            ++i;
        }
        return intoClause;
    }

    private static String removeEscapeCharactersFromName(String name) {
        if (name == null || name.length() == 0 || name.charAt(0) != '\"') {
            return name;
        }
        StringBuffer newName = new StringBuffer(name.length());
        int i = 0;
        while (i < name.length()) {
            char currentChar = name.charAt(i);
            if (currentChar != '\\' || name.charAt(i + 1) != '\"' || i + 2 >= name.length()) {
                newName.append(currentChar);
            }
            ++i;
        }
        return newName.toString();
    }
}

