/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.EGL2IRArgumentProcessor;
import org.eclipse.edt.compiler.EGL2IREnvironment;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.compiler.Processor;
import org.eclipse.edt.compiler.Util;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.NullBuildNotifier;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultCompilerOptions;
import org.eclipse.edt.compiler.internal.sdk.IPartRequestor;
import org.eclipse.edt.compiler.internal.sdk.compile.ASTManager;
import org.eclipse.edt.compiler.internal.sdk.compile.ISDKProblemRequestorFactory;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathEntry;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathInfo;
import org.eclipse.edt.compiler.internal.util.NameUtil;
import org.eclipse.edt.compiler.sdk.compile.BuildPathException;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.serialization.FileSystemObjectStore;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class EGLC {
    public static final String EGLBIN = ".eglbin";
    public static final String EGLXML = ".eglxml";
    public static EGL2IREnvironment eglcEnv;
    public static ISystemEnvironment systemEnvironment;

    public static void compile(EGL2IRArgumentProcessor.EGL2IRArguments processedArgs, ICompiler compiler, ISDKProblemRequestorFactory problemRequestorFactory, IPartRequestor partRequestor) {
        block8: {
            try {
                File[] files = processedArgs.getPartFiles();
                if (files.length > 0) {
                    if (eglcEnv == null) {
                        eglcEnv = new EGL2IREnvironment();
                    }
                    EGLC.initializeOutputPath(processedArgs);
                    EGLC.initializeSystemRoot(processedArgs, compiler);
                    EGLC.initializeEGLPath(processedArgs);
                    ISystemEnvironment sysEnv = compiler.getSystemEnvironment(null);
                    eglcEnv.setCompiler(compiler);
                    Processor processor = new Processor(NullBuildNotifier.getInstance(), DefaultCompilerOptions.getInstance(), problemRequestorFactory, sysEnv, compiler);
                    processor.setEnvironment(eglcEnv);
                    SourcePathInfo.getInstance().setSourceLocations(EGLC.resolveSourcePathLocations(processedArgs.getSourcePathEntries(), processedArgs.getIROutputPath()));
                    SourcePathEntry.getInstance().setDeclaringEnvironment(eglcEnv);
                    SourcePathEntry.getInstance().setProcessor(processor);
                    int j = 0;
                    while (j < files.length) {
                        File file = files[j];
                        org.eclipse.edt.compiler.core.ast.File fileAST = ASTManager.getInstance().getFileAST(file);
                        String[] packageName = EGLC.createPackageName(fileAST);
                        processor.addPart(packageName, Util.getCaseSensitiveFilePartName(file));
                        SourcePathInfo.getInstance().addPart(packageName, Util.getFilePartName(file), 16, file, Util.getCaseSensitiveFilePartName(file));
                        for (Part part : fileAST.getParts()) {
                            processor.addPart(packageName, part.getName().getCaseSensitiveIdentifier());
                            EGLC.addMessageTable(processor, part, file, processedArgs.getNlsCode(), processedArgs.getMsgTablePrefix());
                            SourcePathInfo.getInstance().addPart(packageName, part.getName().getIdentifier(), Util.getPartType(part), file, part.getName().getCaseSensitiveIdentifier());
                            if (!part.isGeneratable() || partRequestor == null) continue;
                            partRequestor.acceptPart(packageName, part.getName().getCaseSensitiveIdentifier());
                        }
                        ++j;
                    }
                    processor.process();
                    break block8;
                }
                throw new RuntimeException("cannot find target file");
            }
            catch (BuildException e) {
                throw e;
            }
            catch (BuildPathException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void addMessageTable(Processor processor, Part part, File file, String nlsCode, String msgTablePrefix) {
        String msgTableName = EGLC.getMsgTableName(part, nlsCode, msgTablePrefix);
        if (msgTableName == null) {
            return;
        }
        msgTableName = InternUtil.intern((String)msgTableName);
        String[][] possibleMsgTablePkgs = EGLC.getPossibleMsgTablePkgs(part, msgTableName);
        int i = 0;
        while (i < possibleMsgTablePkgs.length) {
            String[] pkg = InternUtil.intern((String[])possibleMsgTablePkgs[i]);
            File tblFile = SourcePathInfo.getInstance().getDeclaringFile(pkg, msgTableName);
            if (tblFile != null) {
                processor.addPart(pkg, msgTableName);
            }
            ++i;
        }
    }

    private static String[][] getPossibleMsgTablePkgs(Part part, String msgTableName) {
        String[] parsed = NameUtil.toStringArray(msgTableName);
        if (parsed.length == 1) {
            return EGLC.getPossibleMsgTablePkgsFromImports(part, msgTableName);
        }
        String[] pkg = new String[parsed.length - 1];
        System.arraycopy(parsed, 0, pkg, 0, parsed.length - 1);
        return new String[][]{pkg};
    }

    private static String[][] getPossibleMsgTablePkgsFromImports(Part part, String msgTableName) {
        Node node = part.getParent();
        if (node instanceof org.eclipse.edt.compiler.core.ast.File) {
            final ArrayList onDemand = new ArrayList();
            final ArrayList singleType = new ArrayList();
            node.accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(org.eclipse.edt.compiler.core.ast.File file) {
                    return true;
                }

                @Override
                public boolean visit(ImportDeclaration importDeclaration) {
                    if (importDeclaration.isOnDemand()) {
                        onDemand.add(NameUtil.toStringArray(importDeclaration.getName().getCanonicalName()));
                    } else {
                        singleType.add(NameUtil.toStringArray(importDeclaration.getName().getCanonicalName()));
                    }
                    return false;
                }

                @Override
                public boolean visit(PackageDeclaration packageDeclaration) {
                    onDemand.add(NameUtil.toStringArray(packageDeclaration.getName().getCanonicalName()));
                    return false;
                }
            });
            ArrayList<Object> pkgs = new ArrayList<Object>();
            for (String[] imp : singleType) {
                if (imp.length <= 0 || !msgTableName.equalsIgnoreCase(imp[imp.length - 1])) continue;
                String[] newArr = new String[imp.length - 1];
                if (newArr.length > 0) {
                    System.arraycopy(imp, 0, newArr, 0, newArr.length);
                }
                pkgs.add(newArr);
            }
            pkgs.addAll(onDemand);
            return (String[][])pkgs.toArray((T[])new String[pkgs.size()][]);
        }
        return new String[0][];
    }

    private static String getMsgTableName(Part part, String nlsCode, String msgTablePrefix) {
        final String[] prefix = new String[1];
        final String msgTblPrefixProp = InternUtil.intern((String)"msgTablePrefix");
        part.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(Program program) {
                return true;
            }

            @Override
            public boolean visit(Library library) {
                return true;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            @Override
            public boolean visit(Assignment assignment) {
                String id;
                if (assignment.getLeftHandSide() instanceof Name && InternUtil.intern((String)(id = ((Name)assignment.getLeftHandSide()).getIdentifier())) == msgTblPrefixProp && assignment.getRightHandSide() instanceof StringLiteral) {
                    prefix[0] = ((StringLiteral)assignment.getRightHandSide()).getValue();
                }
                return false;
            }
        });
        if (prefix[0] != null) {
            return String.valueOf(prefix[0]) + nlsCode;
        }
        if (msgTablePrefix != null && msgTablePrefix.trim().length() > 0 && EGLC.isVGUIRecord(part)) {
            return String.valueOf(msgTablePrefix) + nlsCode;
        }
        return null;
    }

    private static boolean isVGUIRecord(Part part) {
        final boolean[] isRecord = new boolean[1];
        final String vgUIRecProp = InternUtil.intern((String)"VGUIRecord");
        part.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(Record record) {
                String id;
                if (record.hasSubType() && InternUtil.intern((String)(id = record.getSubType().getIdentifier())) == vgUIRecProp) {
                    isRecord[0] = true;
                }
                return !isRecord[0];
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                setValuesExpression.getExpression().accept(this);
                return false;
            }

            @Override
            public boolean visit(AnnotationExpression annotationExpression) {
                if (InternUtil.intern((String)annotationExpression.getName().getIdentifier()) == vgUIRecProp) {
                    isRecord[0] = true;
                }
                return false;
            }
        });
        return isRecord[0];
    }

    private static void deleteIRs(File path) {
        File[] files = path.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                EGLC.deleteIRs(files[i]);
            } else if (files[i].getName().indexOf(".ir") > 0) {
                files[i].delete();
            }
            ++i;
        }
    }

    private static void initializeEGLPath(EGL2IRArgumentProcessor.EGL2IRArguments processedArgs) {
        File[] paths;
        File[] fileArray = paths = processedArgs.getSourcePathEntries();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File path = fileArray[n2];
            if (path.exists()) {
                String outType = processedArgs.xmlOut ? "XML" : "BINARY";
                String fileext = processedArgs.xmlOut ? EGLXML : EGLBIN;
                FileSystemObjectStore store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType, fileext);
                eglcEnv.registerObjectStore("egl", (ObjectStore)store);
                eglcEnv.addRoot(path);
            }
            ++n2;
        }
    }

    private static void initializeOutputPath(EGL2IRArgumentProcessor.EGL2IRArguments processedArgs) {
        File path;
        block4: {
            block2: {
                block3: {
                    path = processedArgs.getIROutputPath();
                    if (path == null) break block2;
                    if (path.exists()) break block3;
                    path.mkdirs();
                    break block4;
                }
                if (!processedArgs.isClean()) break block4;
                EGLC.deleteIRs(path);
                break block4;
            }
            if (processedArgs.isClean()) {
                File[] sourcelocs = processedArgs.getSourcePathEntries();
                int i = 0;
                while (i < sourcelocs.length) {
                    EGLC.deleteIRs(sourcelocs[i]);
                    ++i;
                }
            }
        }
        String outType = processedArgs.getXMLOut() ? "XML" : "BINARY";
        String fileext = processedArgs.xmlOut ? EGLXML : EGLBIN;
        FileSystemObjectStore store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType);
        eglcEnv.registerObjectStore("mof", (ObjectStore)store);
        eglcEnv.setDefaultSerializeStore("mof", (ObjectStore)store);
        store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType, fileext);
        eglcEnv.registerObjectStore("egl", (ObjectStore)store);
        eglcEnv.setDefaultSerializeStore("egl", (ObjectStore)store);
        eglcEnv.addRoot(path);
    }

    private static void initializeSystemRoot(EGL2IRArgumentProcessor.EGL2IRArguments processedArgs, ICompiler compiler) {
        String outType = processedArgs.getXMLOut() ? "XML" : "BINARY";
        File path = processedArgs.getSystemRoot();
        if (path != null && path.exists()) {
            FileSystemObjectStore store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType);
            eglcEnv.registerObjectStore("mof", (ObjectStore)store);
            String fileext = processedArgs.xmlOut ? EGLXML : EGLBIN;
            store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType, fileext);
            eglcEnv.registerObjectStore("egl", (ObjectStore)store);
            eglcEnv.addRoot(path);
        } else if (compiler != null) {
            ISystemEnvironment env = compiler.getSystemEnvironment(null);
            Map<String, List<ObjectStore>> systemMap = env.getStores();
            for (Map.Entry<String, List<ObjectStore>> entry : systemMap.entrySet()) {
                String scheme = entry.getKey();
                List<ObjectStore> stores = entry.getValue();
                for (ObjectStore store : stores) {
                    eglcEnv.registerObjectStore(scheme, store);
                }
            }
        }
    }

    private static String[] createPackageName(org.eclipse.edt.compiler.core.ast.File fileAST) {
        if (fileAST.hasPackageDeclaration()) {
            return fileAST.getPackageDeclaration().getName().getNameComponents();
        }
        return InternUtil.intern((String[])new String[0]);
    }

    private static File resolveSourcePathLocation(File sourcePathEntryLocation) {
        try {
            return sourcePathEntryLocation.getCanonicalFile();
        }
        catch (IOException e) {
            System.out.println("Could not find source path location: " + sourcePathEntryLocation);
            throw new RuntimeException(e);
        }
    }

    private static File[] resolveSourcePathLocations(File[] sourcePathEntryLocations, File outpath) throws Exception {
        File[] canonicalLocations = new File[sourcePathEntryLocations.length];
        int i = 0;
        while (i < sourcePathEntryLocations.length) {
            canonicalLocations[i] = EGLC.resolveSourcePathLocation(sourcePathEntryLocations[i]);
            ++i;
        }
        return canonicalLocations;
    }
}

