/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.PlatformUnmarshaller;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.platform.xml.SAXDocumentBuilder;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMUnmarshaller
implements PlatformUnmarshaller {
    private XMLParser parser;
    private XMLUnmarshaller xmlUnmarshaller;
    private boolean isResultAlwaysXMLRoot;

    public DOMUnmarshaller(XMLUnmarshaller xmlUnmarshaller, Map<String, Boolean> parserFeatures) {
        this.parser = null == parserFeatures ? XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser() : XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser(parserFeatures);
        this.parser.setNamespaceAware(true);
        this.parser.setValidationMode(0);
        this.xmlUnmarshaller = xmlUnmarshaller;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.parser.getEntityResolver();
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.parser.setEntityResolver(entityResolver);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.parser.getErrorHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parser.setErrorHandler(errorHandler);
    }

    @Override
    public int getValidationMode() {
        return this.parser.getValidationMode();
    }

    @Override
    public void setValidationMode(int validationMode) {
        this.parser.setValidationMode(validationMode);
    }

    @Override
    public void setWhitespacePreserving(boolean isWhitespacePreserving) {
        this.parser.setWhitespacePreserving(isWhitespacePreserving);
    }

    @Override
    public void setSchemas(Object[] schemas) {
        try {
            this.parser.setXMLSchemas(schemas);
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.errorSettingSchemas(e, schemas);
        }
    }

    @Override
    public void setSchema(Schema schema) {
        this.parser.setXMLSchema(schema);
    }

    @Override
    public Schema getSchema() {
        Schema schema = null;
        try {
            schema = this.parser.getXMLSchema();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return schema;
    }

    @Override
    public Object unmarshal(File file) {
        Object object;
        try {
            Document document = null;
            document = this.parser.parse(file);
            object = this.xmlToObject(new DOMRecord(document));
            Object var5_5 = null;
        }
        catch (XMLPlatformException e) {
            try {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    @Override
    public Object unmarshal(File file, Class clazz) {
        Object object;
        try {
            Document document = null;
            document = this.parser.parse(file);
            object = this.xmlToObject(new DOMRecord(document), clazz);
            Object var6_6 = null;
        }
        catch (XMLPlatformException e) {
            try {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    @Override
    public Object unmarshal(InputStream inputStream) {
        Object object;
        try {
            Document document = null;
            document = this.parser.parse(inputStream);
            object = this.xmlToObject(new DOMRecord(document));
            Object var5_5 = null;
        }
        catch (XMLPlatformException e) {
            try {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    @Override
    public Object unmarshal(InputStream inputStream, Class clazz) {
        Object object;
        try {
            Document document = null;
            document = this.parser.parse(inputStream);
            object = this.xmlToObject(new DOMRecord(document), clazz);
            Object var6_6 = null;
        }
        catch (XMLPlatformException e) {
            try {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    @Override
    public Object unmarshal(InputSource inputSource) {
        Object object;
        try {
            Document document = null;
            document = this.parser.parse(inputSource);
            object = this.xmlToObject(new DOMRecord(document));
            Object var5_5 = null;
        }
        catch (XMLPlatformException e) {
            try {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    @Override
    public Object unmarshal(InputSource inputSource, Class clazz) {
        Object object;
        try {
            Document document = null;
            document = this.parser.parse(inputSource);
            object = this.xmlToObject(new DOMRecord(document), clazz);
            Object var6_6 = null;
        }
        catch (XMLPlatformException e) {
            try {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    @Override
    public Object unmarshal(Node node) {
        Element element = null;
        switch (node.getNodeType()) {
            case 9: {
                element = ((Document)node).getDocumentElement();
                break;
            }
            case 1: {
                element = (Element)node;
                break;
            }
            default: {
                throw XMLMarshalException.unmarshalException();
            }
        }
        return this.xmlToObject(new DOMRecord(element));
    }

    @Override
    public Object unmarshal(Node node, Class clazz) {
        Element element = null;
        switch (node.getNodeType()) {
            case 9: {
                element = ((Document)node).getDocumentElement();
                break;
            }
            case 1: {
                element = (Element)node;
                break;
            }
            default: {
                throw XMLMarshalException.unmarshalException();
            }
        }
        return this.xmlToObject(new DOMRecord(element), clazz);
    }

    @Override
    public Object unmarshal(Reader reader) {
        Object object;
        try {
            Document document = null;
            document = this.parser.parse(reader);
            object = this.xmlToObject(new DOMRecord(document));
            Object var5_5 = null;
        }
        catch (XMLPlatformException e) {
            try {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    @Override
    public Object unmarshal(Reader reader, Class clazz) {
        Object object;
        try {
            Document document = null;
            document = this.parser.parse(reader);
            object = this.xmlToObject(new DOMRecord(document), clazz);
            Object var6_6 = null;
        }
        catch (XMLPlatformException e) {
            try {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    @Override
    public Object unmarshal(Source source) {
        Object object;
        try {
            Document document = null;
            document = this.parser.parse(source);
            object = this.xmlToObject(new DOMRecord(document));
            Object var5_5 = null;
        }
        catch (XMLPlatformException e) {
            try {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    @Override
    public Object unmarshal(Source source, Class clazz) {
        Object object;
        try {
            Document document = null;
            document = this.parser.parse(source);
            object = this.xmlToObject(new DOMRecord(document), clazz);
            Object var6_6 = null;
        }
        catch (XMLPlatformException e) {
            try {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    @Override
    public Object unmarshal(URL url) {
        Object object;
        try {
            Document document = null;
            document = this.parser.parse(url);
            object = this.xmlToObject(new DOMRecord(document));
            Object var5_5 = null;
        }
        catch (XMLPlatformException e) {
            try {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    @Override
    public Object unmarshal(URL url, Class clazz) {
        Object object;
        try {
            Document document = null;
            document = this.parser.parse(url);
            object = this.xmlToObject(new DOMRecord(document), clazz);
            Object var6_6 = null;
        }
        catch (XMLPlatformException e) {
            try {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object unmarshal(XMLReader xmlReader, InputSource inputSource) {
        try {
            try {
                SAXDocumentBuilder saxDocumentBuilder = new SAXDocumentBuilder();
                xmlReader.setContentHandler(saxDocumentBuilder);
                xmlReader.parse(inputSource);
                Object object = this.xmlToObject(new DOMRecord(saxDocumentBuilder.getDocument()));
                Object var6_7 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                return object;
            }
            catch (IOException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (SAXException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object unmarshal(XMLReader xmlReader, InputSource inputSource, Class clazz) {
        try {
            try {
                SAXDocumentBuilder saxDocumentBuilder = new SAXDocumentBuilder();
                xmlReader.setContentHandler(saxDocumentBuilder);
                xmlReader.parse(inputSource);
                Object object = this.xmlToObject(new DOMRecord(saxDocumentBuilder.getDocument()), clazz);
                Object var7_8 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                return object;
            }
            catch (IOException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (SAXException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
            throw throwable;
        }
    }

    protected XMLDescriptor getDescriptor(DOMRecord xmlRecord) throws XMLMarshalException {
        QName rootQName;
        XMLDescriptor xmlDescriptor = null;
        XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
        String type = ((Element)xmlRecord.getDOM()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (null != type) {
            XPathFragment typeFragment = new XPathFragment(type);
            String namespaceURI = xmlRecord.resolveNamespacePrefix(typeFragment.getPrefix());
            typeFragment.setNamespaceURI(namespaceURI);
            xmlDescriptor = xmlContext.getDescriptorByGlobalType(typeFragment);
        }
        if (null == xmlDescriptor && null == (xmlDescriptor = xmlContext.getDescriptor(rootQName = new QName(xmlRecord.getNamespaceURI(), xmlRecord.getLocalName())))) {
            throw XMLMarshalException.noDescriptorWithMatchingRootElement(rootQName.toString());
        }
        return xmlDescriptor;
    }

    public Object xmlToObject(DOMRecord xmlRecord) throws XMLMarshalException {
        XMLDescriptor xmlDescriptor = this.getDescriptor(xmlRecord);
        return this.xmlToObject(xmlRecord, xmlDescriptor.getJavaClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object xmlToObject(DOMRecord xmlRow, Class referenceClass) throws XMLMarshalException {
        XMLContext xmlContext;
        String xmlVersion;
        String xmlEncoding;
        block11: {
            try {
                String nodeVal;
                xmlEncoding = "UTF-8";
                xmlVersion = "1.0";
                try {
                    Method getEncoding = PrivilegedAccessHelper.getMethod(xmlRow.getDocument().getClass(), "getXmlEncoding", new Class[0], true);
                    Method getVersion = PrivilegedAccessHelper.getMethod(xmlRow.getDocument().getClass(), "getXmlVersion", new Class[0], true);
                    xmlEncoding = (String)PrivilegedAccessHelper.invokeMethod(getEncoding, xmlRow.getDocument(), new Object[0]);
                    xmlVersion = (String)PrivilegedAccessHelper.invokeMethod(getVersion, xmlRow.getDocument(), new Object[0]);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                xmlContext = this.xmlUnmarshaller.getXMLContext();
                if (XMLConversionManager.getDefaultJavaTypes().get(referenceClass) == null && !ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(referenceClass) && !ClassConstants.DURATION.isAssignableFrom(referenceClass)) break block11;
                try {
                    Text rootTxt = (Text)xmlRow.getDOM().getFirstChild();
                    nodeVal = rootTxt.getNodeValue();
                }
                catch (Exception ex) {
                    nodeVal = null;
                }
                Object obj = ((XMLConversionManager)xmlContext.getSession(0).getDatasourcePlatform().getConversionManager()).convertObject(nodeVal, referenceClass);
                XMLRoot xmlRoot = new XMLRoot();
                xmlRoot.setObject(obj);
                String lName = xmlRow.getDOM().getLocalName();
                if (lName == null) {
                    lName = xmlRow.getDOM().getNodeName();
                }
                xmlRoot.setLocalName(lName);
                xmlRoot.setNamespaceURI(xmlRow.getDOM().getNamespaceURI());
                xmlRoot.setEncoding(xmlEncoding);
                xmlRoot.setVersion(xmlVersion);
                XMLRoot xMLRoot = xmlRoot;
                Object var14_17 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                return xMLRoot;
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
        AbstractSession readSession = xmlContext.getReadSession(referenceClass);
        XMLDescriptor descriptor = (XMLDescriptor)readSession.getDescriptor(referenceClass);
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(referenceClass.getName());
        }
        Object object = null;
        if (null == xmlRow.getDOM().getAttributes().getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "nil")) {
            xmlRow.setUnmarshaller(this.xmlUnmarshaller);
            xmlRow.setDocPresPolicy(xmlContext.getDocumentPreservationPolicy(readSession));
            XMLObjectBuilder objectBuilder = (XMLObjectBuilder)descriptor.getObjectBuilder();
            ReadObjectQuery query = new ReadObjectQuery();
            query.setReferenceClass(referenceClass);
            query.setSession(readSession);
            object = objectBuilder.buildObject(query, xmlRow, null);
            this.xmlUnmarshaller.resolveReferences(readSession);
        }
        String elementNamespaceUri = xmlRow.getDOM().getNamespaceURI();
        String elementLocalName = xmlRow.getDOM().getLocalName();
        if (elementLocalName == null) {
            elementLocalName = xmlRow.getDOM().getNodeName();
        }
        String elementPrefix = xmlRow.getDOM().getPrefix();
        Object object2 = descriptor.wrapObjectInXMLRoot(object, elementNamespaceUri, elementLocalName, elementPrefix, xmlEncoding, xmlVersion, this.isResultAlwaysXMLRoot);
        Object var14_18 = null;
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object2;
    }

    @Override
    public boolean isResultAlwaysXMLRoot() {
        return this.isResultAlwaysXMLRoot;
    }

    @Override
    public void setResultAlwaysXMLRoot(boolean alwaysReturnRoot) {
        this.isResultAlwaysXMLRoot = alwaysReturnRoot;
    }
}

