/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.testserver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.edt.compiler.tools.IRUtils;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.testserver.AbstractTestServerContribution;
import org.eclipse.edt.ide.testserver.TestServerConfiguration;
import org.eclipse.edt.ide.testserver.TestServerMessages;
import org.eclipse.edt.ide.testserver.TestServerPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class ClasspathUtil {
    public static final char[] SUFFIX_egldd = ".egldd".toCharArray();
    public static final char[] SUFFIX_EGLDD = ".EGLDD".toCharArray();
    private static List<String> testServerBaseEntries;

    private ClasspathUtil() {
    }

    public static void buildClasspath(TestServerConfiguration config, List<String> classpath) throws CoreException {
        int n;
        IProject project = config.getProject();
        try {
            IRuntimeClasspathEntry jreEntry = JavaRuntime.computeJREEntry((IJavaProject)JavaCore.create((IProject)project));
            if (jreEntry != null) {
                classpath.add(jreEntry.getMemento());
            }
        }
        catch (CoreException ce) {
            TestServerPlugin.getDefault().log((Exception)((Object)ce));
        }
        if (testServerBaseEntries == null) {
            String entry;
            Bundle[] bundles;
            testServerBaseEntries = new ArrayList<String>(20);
            Bundle[] bundleArray = bundles = TestServerPlugin.getDefault().getBundle().getBundleContext().getBundles();
            int n2 = bundles.length;
            n = 0;
            while (n < n2) {
                Bundle bundle = bundleArray[n];
                if (bundle.getSymbolicName().startsWith("org.eclipse.jetty.") && (entry = ClasspathUtil.getClasspathEntry(bundle)) != null) {
                    testServerBaseEntries.add(entry);
                }
                ++n;
            }
            entry = ClasspathUtil.getClasspathEntry("javax.servlet");
            if (entry != null) {
                testServerBaseEntries.add(entry);
            }
            if ((entry = ClasspathUtil.getClasspathEntry("org.eclipse.edt.ide.testserver")) != null) {
                testServerBaseEntries.add(entry);
            }
        }
        classpath.addAll(testServerBaseEntries);
        classpath.add(ClasspathUtil.getWorkspaceProjectClasspathEntry(project.getName()));
        AbstractTestServerContribution[] abstractTestServerContributionArray = TestServerPlugin.getContributions();
        n = abstractTestServerContributionArray.length;
        int n3 = 0;
        while (n3 < n) {
            AbstractTestServerContribution contrib = abstractTestServerContributionArray[n3];
            String[] extraClasspath = contrib.getClasspathAdditions(config);
            if (extraClasspath != null && extraClasspath.length > 0) {
                String[] stringArray = extraClasspath;
                int n4 = extraClasspath.length;
                int n5 = 0;
                while (n5 < n4) {
                    String next = stringArray[n5];
                    if (!classpath.contains(next)) {
                        if (ClasspathUtil.classpathEntryIsValid(next, project)) {
                            classpath.add(next);
                        } else {
                            TestServerPlugin.getDefault().logWarning(NLS.bind((String)TestServerMessages.InvalidClasspathEntry, (Object)next));
                        }
                    }
                    ++n5;
                }
            }
            ++n3;
        }
    }

    public static void addEGLPathToJavaPathIfNecessary(IJavaProject javaProject, IProject currProject, Set<IProject> seen, List<String> classpath) {
        block9: {
            if (seen.contains(currProject)) {
                return;
            }
            seen.add(currProject);
            try {
                if (!currProject.hasNature("org.eclipse.edt.ide.core.eglnature")) break block9;
                IEGLProject eglProject = EGLCore.create((IProject)currProject);
                IEGLPathEntry[] iEGLPathEntryArray = eglProject.getResolvedEGLPath(true);
                int n = iEGLPathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEGLPathEntry pathEntry = iEGLPathEntryArray[n2];
                    if (pathEntry.getEntryKind() == 2) {
                        IPath path = pathEntry.getPath();
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                        try {
                            if (resource != null && resource.getType() == 4 && !seen.contains(resource) && ((IProject)resource).hasNature("org.eclipse.jdt.core.javanature") && !javaProject.isOnClasspath(resource)) {
                                classpath.add(ClasspathUtil.getWorkspaceProjectClasspathEntry(resource.getName()));
                                ClasspathUtil.addEGLPathToJavaPathIfNecessary(javaProject, (IProject)resource, seen, classpath);
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n2;
                }
            }
            catch (EGLModelException eGLModelException) {
            }
            catch (CoreException coreException) {}
        }
    }

    public static String getClasspathEntry(String pluginName) {
        Bundle bundle = Platform.getBundle((String)pluginName);
        if (bundle != null) {
            return ClasspathUtil.getClasspathEntry(bundle);
        }
        TestServerPlugin.getDefault().log(NLS.bind((String)TestServerMessages.CouldNotGetPluginPath, (Object)pluginName), null);
        return null;
    }

    public static String getClasspathEntry(Bundle bundle) {
        try {
            File file = FileLocator.getBundleFile((Bundle)bundle);
            String path = file.getAbsolutePath();
            if (file.isDirectory()) {
                if (!path.endsWith(File.separator)) {
                    path = String.valueOf(path) + File.separator;
                }
                path = String.valueOf(path) + "bin";
            }
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><runtimeClasspathEntry externalArchive=\"" + path + "\" path=\"3\" type=\"2\"/>";
        }
        catch (IOException e) {
            TestServerPlugin.getDefault().log(NLS.bind((String)TestServerMessages.CouldNotGetPluginPath, (Object)bundle.getSymbolicName()), e);
            return null;
        }
    }

    public static String getWorkspaceProjectClasspathEntry(String projectName) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><runtimeClasspathEntry id=\"org.eclipse.jdt.launching.classpathentry.defaultClasspath\"><memento exportedEntriesOnly=\"false\" project=\"" + projectName + "\"/></runtimeClasspathEntry>";
    }

    public static boolean canAffectClasspath(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        return ".classpath".equals(fileName) || ".eglPath".equals(fileName) || IRUtils.matchesFileName((String)fileName, (char[])SUFFIX_egldd, (char[])SUFFIX_EGLDD);
    }

    public static boolean classpathEntryIsValid(String entry, IProject serverProject) {
        try {
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
            ILaunchConfigurationWorkingCopy copy = type.newInstance(null, "ezeTemp");
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, serverProject.getName());
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            ArrayList<String> classpath = new ArrayList<String>(1);
            classpath.add(entry);
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
            JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)copy), (ILaunchConfiguration)copy);
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static String[] resolveClasspath(ILaunchConfiguration config) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)config), (ILaunchConfiguration)config);
        String[] paths = new String[entries.length];
        int i = 0;
        while (i < entries.length) {
            paths[i] = entries[i].getLocation();
            ++i;
        }
        return paths;
    }
}

