/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.lookup;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.ide.core.internal.lookup.ProjectIREnvironment;
import org.eclipse.edt.ide.rui.internal.lookup.PreviewObjectStore;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.impl.Bootstrap;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class PreviewIREnvironment
extends ProjectIREnvironment {
    private boolean projectEnvironmentInitialized;
    private PreviewObjectStore contextStore;

    public PreviewIREnvironment(IEnvironment environment, File contextDirectory) {
        this.initContext(contextDirectory);
        this.initProjectEnvironment(environment);
    }

    public void reset() {
        super.reset();
        this.projectEnvironmentInitialized = false;
        this.contextStore = null;
    }

    public void initContext(File contextDirectory) {
        this.contextStore = new PreviewObjectStore(contextDirectory, (IEnvironment)this, "XML", ".eglxml");
        this.contextStore.supportedScheme = "egl";
        this.registerObjectStore(this.contextStore.getKeyScheme(), (ObjectStore)this.contextStore);
        this.setDefaultSerializeStore(this.contextStore.getKeyScheme(), (ObjectStore)this.contextStore);
    }

    public void initProjectEnvironment(IEnvironment environment) {
        if (this.projectEnvironmentInitialized) {
            return;
        }
        this.projectEnvironmentInitialized = true;
        Bootstrap.initialize((IEnvironment)this);
        Map storeMap = environment.getObjectStores();
        for (Map.Entry entry : storeMap.entrySet()) {
            String scheme = (String)entry.getKey();
            List stores = (List)entry.getValue();
            for (ObjectStore store : stores) {
                this.registerObjectStore(scheme, store);
            }
        }
    }

    protected boolean storeInObjectStoreCache(String key, EObject object) {
        String scheme = this.getKeySchemeFromKey(key);
        if (this.contextStore.getKeyScheme().equals(scheme) && this.contextStore.containsKey(key)) {
            String storeKey = this.getDelegateForKey(key).normalizeKey(key);
            this.updateProxyReferences(storeKey, object);
            this.contextStore.addToCache(storeKey, object);
            this.objectCache.remove(storeKey);
            return true;
        }
        return false;
    }
}

