/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal;

import java.util.EventListener;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.IProfileListener1;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.jpt.jpa.db.ConnectionProfileListener;
import org.eclipse.jpt.jpa.db.DatabaseIdentifierAdapter;
import org.eclipse.jpt.jpa.db.internal.DTPConnectionProfileWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DTPConnectionProfileFactory
implements ConnectionProfileFactory {
    private ProfileManager dtpProfileManager;
    private LocalProfileListener profileListener;
    private static final DTPConnectionProfileFactory INSTANCE = new DTPConnectionProfileFactory();

    public static DTPConnectionProfileFactory instance() {
        return INSTANCE;
    }

    private DTPConnectionProfileFactory() {
    }

    public synchronized void start() {
        this.dtpProfileManager = ProfileManager.getInstance();
        this.profileListener = new LocalProfileListener();
        this.dtpProfileManager.addProfileListener((IProfileListener)this.profileListener);
    }

    public synchronized void stop() {
        this.dtpProfileManager.removeProfileListener((IProfileListener)this.profileListener);
        this.profileListener = null;
        this.dtpProfileManager = null;
    }

    @Override
    public synchronized ConnectionProfile buildConnectionProfile(String name, DatabaseIdentifierAdapter adapter) {
        IConnectionProfile[] iConnectionProfileArray = this.dtpProfileManager.getProfiles();
        int n = iConnectionProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile dtpProfile = iConnectionProfileArray[n2];
            if (dtpProfile.getName().equals(name)) {
                return this.buildConnectionProfile(dtpProfile, adapter);
            }
            ++n2;
        }
        return null;
    }

    private ConnectionProfile buildConnectionProfile(IConnectionProfile dtpProfile, DatabaseIdentifierAdapter adapter) {
        return new DTPConnectionProfileWrapper(dtpProfile, adapter);
    }

    @Override
    public ConnectionProfile buildConnectionProfile(String name) {
        return this.buildConnectionProfile(name, DatabaseIdentifierAdapter.Default.instance());
    }

    @Override
    public Iterable<String> getConnectionProfileNames() {
        return new TransformationIterable<IConnectionProfile, String>(this.getDTPConnectionProfiles()){

            protected String transform(IConnectionProfile dtpProfile) {
                return dtpProfile.getName();
            }
        };
    }

    private synchronized Iterable<IConnectionProfile> getDTPConnectionProfiles() {
        return new ArrayIterable((Object[])this.dtpProfileManager.getProfiles());
    }

    @Override
    public void addConnectionProfileListener(ConnectionProfileListener listener) {
        this.profileListener.addConnectionProfileListener(listener);
    }

    @Override
    public void removeConnectionProfileListener(ConnectionProfileListener listener) {
        this.profileListener.removeConnectionProfileListener(listener);
    }

    private static class LocalProfileListener
    implements IProfileListener1 {
        private final ListenerList<ConnectionProfileListener> listenerList = new ListenerList(ConnectionProfileListener.class);

        LocalProfileListener() {
        }

        void addConnectionProfileListener(ConnectionProfileListener listener) {
            this.listenerList.add((EventListener)listener);
        }

        void removeConnectionProfileListener(ConnectionProfileListener listener) {
            this.listenerList.remove((EventListener)listener);
        }

        public void profileAdded(IConnectionProfile dtpProfile) {
            String name = dtpProfile.getName();
            for (ConnectionProfileListener listener : this.listenerList.getListeners()) {
                listener.connectionProfileAdded(name);
            }
        }

        public void profileChanged(IConnectionProfile dtpProfile, String oldName, String oldDescription, Boolean oldAutoConnect) {
            String newName = dtpProfile.getName();
            if (!newName.equals(oldName)) {
                for (ConnectionProfileListener listener : this.listenerList.getListeners()) {
                    listener.connectionProfileRenamed(oldName, newName);
                }
            }
        }

        public void profileChanged(IConnectionProfile dtpProfile) {
            throw new UnsupportedOperationException();
        }

        public void profileDeleted(IConnectionProfile dtpProfile) {
            String name = dtpProfile.getName();
            for (ConnectionProfileListener listener : this.listenerList.getListeners()) {
                listener.connectionProfileRemoved(name);
            }
        }
    }
}

