/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.util.ImportUtility;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class EGLCompletionProposal
implements ICompletionProposal {
    public static final int RELEVANCE_TEMPLATE_NEW_LINE = 90;
    public static final int RELEVANCE_ARRAYDICTIONARY = 75;
    public static final int RELEVANCE_KEYWORD = 70;
    public static final int RELEVANCE_PRIMITIVE = 60;
    public static final int RELEVANCE_PREDEFINED_TYPE = 60;
    public static final int RELEVANCE_ITEM_STATE = 55;
    public static final int RELEVANCE_MEDIUM = 50;
    public static final int RELEVANCE_VARIABLE_CONTAINER = 50;
    public static final int RELEVANCE_VARIABLE_STRUCTURE_ITEM = 45;
    public static final int RELEVANCE_LIBRARY_FUNCTION = 45;
    public static final int RELEVANCE_SYSTEM_WORD = 40;
    public static final int RELEVANCE_SYSTEM_LIBRARY = 35;
    public static final int RELEVANCE_ENUMERATION = 30;
    public static final int RELEVANCE_EXCEPTION = 30;
    public static final int RELEVANCE_TEMPLATE_OTHER = 0;
    public static final String NO_IMG_KEY = "";
    public static final String STR_IMG_KEYWORD = "";
    private String importPackageName;
    private String importPartName;
    private ITextViewer viewer;
    private String displayString;
    private String replacementString;
    private String additionalProposalInfo;
    private int replacementOffset;
    private int replacementLength;
    private int cursorPosition;
    private int relevance;
    private int postSelectionLength;
    private String ImageDescStr;
    private IContextInformation contextInformation;

    public EGLCompletionProposal(ITextViewer viewer, String displayString, String replacementString, String additionalProposalInfo, int replacementOffset, int replacementLength, int cursorPosition, int relevance, int postSelectionLength, String aImgDescStr) {
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        Assert.isTrue((postSelectionLength >= 0 ? 1 : 0) != 0);
        this.viewer = viewer;
        this.displayString = displayString;
        this.replacementString = replacementString;
        this.additionalProposalInfo = additionalProposalInfo;
        this.replacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.cursorPosition = cursorPosition;
        this.relevance = relevance;
        this.postSelectionLength = postSelectionLength;
        this.ImageDescStr = aImgDescStr;
    }

    public EGLCompletionProposal(ITextViewer textViewer, String displayString, String replacementString, String additionalProposalInfo, int replacementOffset, int replacementLength, int cursorPosition, int relevance, String aImageDesc) {
        this(textViewer, displayString, replacementString, additionalProposalInfo, replacementOffset, replacementLength, cursorPosition, relevance, 0, aImageDesc);
    }

    public EGLCompletionProposal(ITextViewer textViewer, String displayString, String replacementString, String additionalProposalInfo, int replacementOffset, int replacementLength, int cursorPosition, String aImageDesc) {
        this(textViewer, displayString, replacementString, additionalProposalInfo, replacementOffset, replacementLength, cursorPosition, 50, 0, aImageDesc);
    }

    public void apply(IDocument document) {
        try {
            Point currentSelection = this.viewer.getTextWidget().getSelection();
            int currentSelectionLength = currentSelection.y - currentSelection.x;
            if (!document.get(this.replacementOffset, this.replacementLength + currentSelectionLength).equals(this.replacementString)) {
                document.replace(this.replacementOffset, this.replacementLength + currentSelectionLength, this.replacementString);
            }
            if (document instanceof IEGLDocument && this.hasImportString() && ImportUtility.addImportStatement((IEGLDocument)document, this.importPackageName, this.importPartName)) {
                int delimeterLength = document.getLineDelimiter(0).length();
                File eglFile = ((IEGLDocument)document).getNewModelEGLFile();
                List importStatements = eglFile.getImportDeclarations();
                if (importStatements.size() == 1) {
                    delimeterLength *= 2;
                }
                this.cursorPosition = this.cursorPosition + "import".length() + this.importPackageName.length() + this.importPartName.length() + delimeterLength + 3;
            }
        }
        catch (BadLocationException x) {
            EGLLogger.log((Object)this, x);
        }
    }

    public String getAdditionalProposalInfo() {
        return this.additionalProposalInfo;
    }

    public IContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.contextInformation = contextInformation;
    }

    public String getDisplayString() {
        if (this.displayString != null) {
            return this.displayString;
        }
        return this.replacementString;
    }

    public Image getImage() {
        return PluginImages.get(this.ImageDescStr);
    }

    public Point getSelection(IDocument document) {
        return new Point(this.replacementOffset + this.cursorPosition, this.postSelectionLength);
    }

    public int getRelevance() {
        return this.relevance;
    }

    public int getReplacementOffset() {
        return this.replacementOffset;
    }

    public void setImportPackageName(String string) {
        this.importPackageName = string;
    }

    public void setImportPartName(String string) {
        this.importPartName = string;
    }

    public boolean hasImportString() {
        return this.importPackageName != null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("displayString= ");
        buf.append(this.getDisplayString());
        buf.append("; replacementString= ");
        buf.append(this.replacementString);
        buf.append("; additionalInfo= ");
        buf.append(this.additionalProposalInfo);
        buf.append("; importPackageName= ");
        buf.append(this.importPackageName);
        buf.append("; importPartName= ");
        buf.append(this.importPartName);
        buf.append("; replacementString= ");
        buf.append(this.replacementString);
        buf.append("; cursorPosition= ");
        buf.append(this.cursorPosition);
        buf.append("; relevance= ");
        buf.append(this.relevance);
        return buf.toString();
    }

    public void setRelevance(int relevance) {
        this.relevance = relevance;
    }

    public String getReplacementString() {
        return this.replacementString;
    }
}

