/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.ide.core.internal.model.BinaryPart;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfoRequestor;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.Signature;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.IPartNameRequestor;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class EGLPartSearchProposalHandler
extends EGLAbstractProposalHandler {
    private String excludeName;
    private String[] subTypes;

    public EGLPartSearchProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor) {
        super(viewer, documentOffset, prefix, editor);
    }

    public List getProposals(int types) {
        return this.getProposals(types, "", new String[0]);
    }

    public List getProposals(int types, String excludeName) {
        return this.getProposals(types, excludeName, new String[0]);
    }

    public List getProposals(int types, String excludeName, String subType) {
        return this.getProposals(types, excludeName, new String[]{subType});
    }

    public List getProposals(int types, String excludeName, String[] subTypes) {
        this.excludeName = excludeName;
        this.subTypes = subTypes;
        return this.createProposals(this.searchIndex(types), false);
    }

    public List getProposals(int types, String excludeName, String[] subTypes, boolean quoted) {
        this.excludeName = excludeName;
        this.subTypes = subTypes;
        return this.createProposals(this.searchIndex(types), quoted);
    }

    protected List createProposals(List parts, boolean quoted) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        File eglFile = ((IEGLDocument)this.getViewer().getDocument()).getNewModelEGLFile();
        String currentFilePackageName = eglFile.hasPackageDeclaration() ? eglFile.getPackageDeclaration().getName().getCanonicalName() : "";
        for (PartDeclarationInfo partDeclarationInfo : parts) {
            EGLCompletionProposal proposal;
            if (partDeclarationInfo.getPartName().equalsIgnoreCase(this.excludeName) || !this.validSubtype(partDeclarationInfo)) continue;
            String partDeclarationPackageName = partDeclarationInfo.getPackageName();
            if (currentFilePackageName.length() != 0 && partDeclarationPackageName.length() == 0) continue;
            if (!currentFilePackageName.equalsIgnoreCase(partDeclarationPackageName)) {
                if (!this.isPublic(partDeclarationInfo) || (proposal = this.createPartProposal(partDeclarationInfo, this.getPartType(partDeclarationInfo), quoted)) == null) continue;
                proposals.add(proposal);
                continue;
            }
            proposal = this.createPartProposal(partDeclarationInfo, this.getPartType(partDeclarationInfo), quoted);
            if (proposal == null) continue;
            proposals.add(proposal);
        }
        return proposals;
    }

    protected boolean validSubtype(PartDeclarationInfo partDeclarationInfo) {
        block5: {
            if (this.subTypes != null && this.subTypes.length > 0) {
                try {
                    IPart part = partDeclarationInfo.resolvePart(this.createScope());
                    if (part == null || !(part instanceof SourcePart) && !(part instanceof BinaryPart)) break block5;
                    IPart sourcePart = part;
                    String subTypeSignature = sourcePart.getSubTypeSignature();
                    if (subTypeSignature != null) {
                        String subtypeName = Signature.toString((String)subTypeSignature);
                        if (subtypeName == null || !this.validSubtype(subtypeName)) {
                            return false;
                        }
                        break block5;
                    }
                    return false;
                }
                catch (EGLModelException e) {
                    EGLLogger.log((Object)this, e);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validSubtype(String subtypeName) {
        int i = 0;
        while (i < this.subTypes.length) {
            if (this.subTypes[i].equalsIgnoreCase(subtypeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getPartType(PartDeclarationInfo part) {
        String partTypeName;
        switch (part.getPartType()) {
            case '\u0001': {
                partTypeName = "program";
                break;
            }
            case '@': {
                partTypeName = "formGroup";
                break;
            }
            case ' ': {
                partTypeName = "form";
                break;
            }
            case '\u0010': {
                partTypeName = "dataItem";
                break;
            }
            case '\b': {
                partTypeName = "record";
                break;
            }
            case '\u0004': {
                partTypeName = "dataTable";
                break;
            }
            case '\u0080': {
                partTypeName = "function";
                break;
            }
            case '\u0100': {
                partTypeName = "library";
                break;
            }
            case '\u0200': {
                partTypeName = "handler";
                break;
            }
            case '\u0400': {
                partTypeName = "service";
                break;
            }
            case '\u0800': {
                partTypeName = "interface";
                break;
            }
            case '\u1000': {
                partTypeName = "delegate";
                break;
            }
            case '\u2000': {
                partTypeName = "externalType";
                break;
            }
            default: {
                partTypeName = "";
            }
        }
        return partTypeName;
    }

    private List searchIndex(int types) {
        ArrayList parts = new ArrayList();
        try {
            new SearchEngine().searchAllPartNames(ResourcesPlugin.getWorkspace(), null, this.getPrefix().toCharArray(), 1, false, types, this.createScope(), (IPartNameRequestor)new PartInfoRequestor(parts), 3, null);
        }
        catch (EGLModelException e) {
            EGLLogger.log((Object)this, e);
        }
        return parts;
    }

    protected IEGLSearchScope createScope() {
        return this.createProjectSearchScope();
    }

    protected int getCursorPosition(PartDeclarationInfo part) {
        return part.getPartName().length();
    }

    protected boolean isPublic(PartDeclarationInfo partInfo) {
        try {
            IPart type = partInfo.resolvePart(this.createScope());
            if (type != null) {
                return type.isPublic();
            }
        }
        catch (EGLModelException e) {
            EGLLogger.log((Object)this, e);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return false;
    }
}

