/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.project.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.project.wizard.pages.ProjectWizardMainPage;
import org.eclipse.edt.ide.ui.internal.project.wizards.BasicProjectTemplateWizard;
import org.eclipse.edt.ide.ui.internal.project.wizards.ProjectWizardUtils;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.project.templates.IProjectTemplate;
import org.eclipse.edt.ide.ui.project.templates.ProjectTemplateWizardNode;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.edt.ide.ui.wizards.ProjectFinishUtility;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewEGLProjectWizard
extends Wizard
implements IWorkbenchWizard,
INewWizard {
    private ProjectWizardMainPage mainPage;
    private ProjectConfiguration model;
    private IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private IConfigurationElement configElement;

    public NewEGLProjectWizard() {
        this.model = new ProjectConfiguration();
        this.model.setDefaultAttributes();
        IPreferenceStore store = EDTUIPlugin.getDefault().getPreferenceStore();
        this.model.setBasePackageName(store.getString("newProjectWizard_BasePackage"));
        this.setDefaultPageImageDescriptor(PluginImages.DESC_WIZBAN_NEWEGLPROJECT);
        this.setDialogSettings(EDTUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.EGLNewProjectWizard_0);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        try {
            ISchedulingRule rule = this.getCurrentSchedulingRule();
            this.model.setProjectName(this.mainPage.getModel().getProjectName());
            IProjectTemplate template = this.model.getSelectedProjectTemplate();
            IWizardNode node = this.mainPage.getSelectedNode();
            ProjectTemplateWizardNode twn = null;
            if (node != null && node instanceof ProjectTemplateWizardNode && (twn = (ProjectTemplateWizardNode)node).getTemplate().hasWizard() && !twn.getWizard().performFinish()) {
                return false;
            }
            final List<WorkspaceModifyOperation> ops = ProjectFinishUtility.getCreateProjectFinishOperations(template.getProjectTemplateClass(), this.model, 0, rule);
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    for (Object obj : ops) {
                        if (!(obj instanceof WorkspaceModifyOperation)) continue;
                        IRunnableWithProgress runnable = (IRunnableWithProgress)obj;
                        try {
                            runnable.run(monitor);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (monitor.isCanceled()) break;
                    }
                }
            });
            List<WorkspaceModifyOperation> opsImport = ProjectFinishUtility.getImportProjectOperations(template.getProjectTemplateClass(), this.model, 0, rule);
            for (WorkspaceModifyOperation obj : opsImport) {
                if (!(obj instanceof WorkspaceModifyOperation)) continue;
                WorkspaceModifyOperation op = obj;
                this.getContainer().run(false, true, (IRunnableWithProgress)op);
            }
            if (twn != null && twn.getTemplate().hasWizard() && twn.getWizard() instanceof BasicProjectTemplateWizard && !((BasicProjectTemplateWizard)twn.getWizard()).proecssGenerationDirectorySetting()) {
                return false;
            }
            try {
                IPreferenceStore store = EDTUIPlugin.getDefault().getPreferenceStore();
                if (template.getProjectTemplateClass().needPreserveBasePackage()) {
                    store.putValue("newProjectWizard_BasePackage", this.model.getBasePackageName());
                }
                store.putValue("newProjectWizard_SelectedTemplate", template.getId());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof CoreException) {
                    ErrorDialog.openError((Shell)this.getContainer().getShell(), null, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
                } else {
                    e.printStackTrace();
                    EDTUIPlugin.log(e);
                }
                return false;
            }
        }
        finally {
            this.postPerformFinish();
        }
        return true;
    }

    protected ISchedulingRule getCurrentSchedulingRule() {
        ISchedulingRule rule = null;
        Job job = Job.getJobManager().currentJob();
        if (job != null) {
            rule = job.getRule();
        }
        if (rule == null) {
            rule = this.getSchedulingRule();
        }
        return rule;
    }

    protected ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(NewWizardMessages.EGLNewProjectWizard_0);
    }

    public void addPages() {
        this.mainPage = new ProjectWizardMainPage(NewWizardMessages.EGLNewProjectWizard_1, this.model);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    public ProjectConfiguration getModel() {
        return this.model;
    }

    protected void postPerformFinish() {
        DummyConfigurationElement dummy = new DummyConfigurationElement();
        ProjectWizardUtils.updatePerspective(dummy);
        BasicNewResourceWizard.selectAndReveal((IResource)this.workspaceRoot.getProject(this.model.getProjectName()), (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    public class DummyConfigurationElement
    implements IConfigurationElement {
        private static final String FINAL_PERSPECTIVE = "finalPerspective";

        public Object createExecutableExtension(String propertyName) throws CoreException {
            return null;
        }

        public String getAttribute(String name) throws InvalidRegistryObjectException {
            if (name.equals(FINAL_PERSPECTIVE)) {
                return "org.eclipse.edt.ide.ui.EGLPerspective";
            }
            return null;
        }

        public String getAttribute(String attrName, String locale) throws InvalidRegistryObjectException {
            return this.getAttribute(attrName);
        }

        public String getAttributeAsIs(String name) throws InvalidRegistryObjectException {
            return null;
        }

        public String[] getAttributeNames() throws InvalidRegistryObjectException {
            return null;
        }

        public IConfigurationElement[] getChildren() throws InvalidRegistryObjectException {
            return null;
        }

        public IConfigurationElement[] getChildren(String name) throws InvalidRegistryObjectException {
            return null;
        }

        public IContributor getContributor() throws InvalidRegistryObjectException {
            return null;
        }

        public IExtension getDeclaringExtension() throws InvalidRegistryObjectException {
            return null;
        }

        public String getName() throws InvalidRegistryObjectException {
            return null;
        }

        public String getNamespace() throws InvalidRegistryObjectException {
            return null;
        }

        public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
            return null;
        }

        public Object getParent() throws InvalidRegistryObjectException {
            return null;
        }

        public String getValue() throws InvalidRegistryObjectException {
            return null;
        }

        public String getValue(String locale) throws InvalidRegistryObjectException {
            return null;
        }

        public String getValueAsIs() throws InvalidRegistryObjectException {
            return null;
        }

        public boolean isValid() {
            return false;
        }
    }
}

