/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompiler;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

public class EGLFileConfiguration
extends EGLPackageConfiguration {
    public static final String TEMPLATE_NOT_FOUND = NewWizardMessages.NewEGLFileWizardPageTemplateSelectionErrorTemplatenotfound;
    public static final String TEMPLATE_DISABLED = NewWizardMessages.NewEGLFileWizardPageTemplateSelectionErrorTemplatedisabled;
    public static final String TEMPLATE_CORRUPTED = NewWizardMessages.NewEGLFileWizardPageTemplateSelectionErrorTemplatecorrupted;
    private String fileName;
    private IFile file;
    private boolean bOverwrite = false;
    public static final String PROPERTY_OVERWRITE = "EGLFileConfiguration.Overwrite";
    private static final String[] EGLCORE = new String[]{"egl", "core"};
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public EGLFileConfiguration() {
        this.setDefaultAttributes();
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setDefaultAttributes();
    }

    private void setDefaultAttributes() {
        this.fileName = "";
        this.file = null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public IFile getFile() {
        IFile fileHandle = this.getFileHandle();
        if (fileHandle.exists()) {
            this.file = fileHandle;
        }
        return this.file;
    }

    public IFile getFileHandle() {
        if (!this.fileName.equals("")) {
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
                IEGLProject eproject = EGLCore.create((IProject)project);
                Path sourcePath = new Path(this.getContainerName());
                IPackageFragmentRoot root = eproject.findPackageFragmentRoot(sourcePath.makeAbsolute());
                IPackageFragment frag = root.getPackageFragment(this.getFPackage());
                IContainer container = (IContainer)frag.getResource();
                Path path = new Path(this.getFileName());
                String fileExt = this.getFileExtension();
                if (fileExt.length() > 0) {
                    path = path.addFileExtension(fileExt);
                }
                IFile fileHandle = container.getFile((IPath)path);
                return fileHandle;
            }
            catch (EGLModelException eGLModelException) {
                return null;
            }
        }
        return null;
    }

    public String getFileExtension() {
        return "egl";
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public boolean isOverwrite() {
        return this.bOverwrite;
    }

    public void setOverwrite(boolean overwrite) {
        boolean oldValue = this.bOverwrite;
        this.bOverwrite = overwrite;
        this.pcs.firePropertyChange(PROPERTY_OVERWRITE, oldValue, this.isOverwrite());
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public static Part getBoundPart(IEGLFile eglFile, String partSimpleName) {
        final Part[] boundPart = new Part[1];
        try {
            IFile file = (IFile)eglFile.getCorrespondingResource();
            IEGLElement eglPkgFrag = eglFile.getParent();
            String packageName = eglPkgFrag.getElementName();
            Path pkgPath = new Path(packageName.replace('.', '/'));
            String[] pkgName = Util.pathToStringArray((IPath)pkgPath);
            IBufferFactory UIBufferFactory = EGLUI.getBufferFactory();
            WorkingCopyCompiler compiler = WorkingCopyCompiler.getInstance();
            compiler.compilePart(file.getProject(), pkgName, file, EGLCore.getSharedWorkingCopies((IBufferFactory)UIBufferFactory), partSimpleName, new IWorkingCopyCompileRequestor(){

                public void acceptResult(WorkingCopyCompilationResult result) {
                    boundPart[0] = (Part)result.getBoundPart();
                }
            });
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        return boundPart[0];
    }

    public static List getBoundParts(IEGLFile eglFile) {
        ArrayList boundPartList = new ArrayList();
        try {
            IFile cfr_ignored_0 = (IFile)eglFile.getCorrespondingResource();
            IEGLElement eglPkgFrag = eglFile.getParent();
            String packageName = eglPkgFrag.getElementName();
            new Path(packageName.replace('.', '/'));
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        return boundPartList;
    }

    public static void getXMLAnnotationValueFromBinding(IBinding nameBinding, StringBuffer nameVal, StringBuffer namespaceVal) {
        IAnnotationBinding xmlAnnotationBinding;
        if (nameBinding != null && nameBinding != IBinding.NOT_FOUND_BINDING && (xmlAnnotationBinding = nameBinding.getAnnotation(EGLCORE, "xml")) != null && xmlAnnotationBinding != IBinding.NOT_FOUND_BINDING) {
            IDataBinding namespaceValDataBinding;
            IDataBinding nameValDataBinding = xmlAnnotationBinding.findData("name");
            if (nameValDataBinding != null && nameValDataBinding != IBinding.NOT_FOUND_BINDING && nameValDataBinding.isAnnotationBinding()) {
                Object valObj = ((IAnnotationBinding)nameValDataBinding).getValue();
                nameVal.append(valObj.toString());
            }
            if ((namespaceValDataBinding = xmlAnnotationBinding.findData("namespace")) != null && namespaceValDataBinding != IBinding.NOT_FOUND_BINDING && namespaceValDataBinding.isAnnotationBinding()) {
                Object valObj1 = ((IAnnotationBinding)namespaceValDataBinding).getValue();
                namespaceVal.append(valObj1.toString());
            }
        }
    }
}

