/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.validation;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class DefaultValidationMessages {
    private static String[] DEFAULT_PARMS = new String[0];
    private static TextRange DEFAULT_TEXT_RANGE = TextRange.Empty.instance();

    public static IMessage buildMessage(int defaultSeverity, String messageId, Object targetObject) {
        return DefaultValidationMessages.buildMessage(defaultSeverity, messageId, DEFAULT_PARMS, targetObject);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, Object targetObject) {
        return DefaultValidationMessages.buildMessage(defaultSeverity, messageId, parms, targetObject, DEFAULT_TEXT_RANGE);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, Object targetObject, TextRange textRange) {
        return DefaultValidationMessages.buildMessage(defaultSeverity, messageId, DEFAULT_PARMS, targetObject, textRange);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, Object targetObject, TextRange textRange) {
        int severity = defaultSeverity;
        Message message = new Message("jaxb_validation", severity, messageId, parms, targetObject);
        message.setMarkerId("org.eclipse.jpt.jaxb.core.jaxbProblemMarker");
        if (textRange == null) {
            JptJaxbCorePlugin.log(new IllegalArgumentException("Null text range for message ID: " + messageId));
        } else {
            message.setLineNo(textRange.getLineNumber());
            message.setOffset(textRange.getOffset());
            message.setLength(textRange.getLength());
        }
        return message;
    }

    private DefaultValidationMessages() {
        throw new UnsupportedOperationException();
    }
}

