/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.impl;

import java.math.BigInteger;
import org.eclipse.edt.mof.egl.IntegerLiteral;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.impl.NumericLiteralImpl;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class IntegerLiteralImpl
extends NumericLiteralImpl
implements IntegerLiteral {
    private Type type = null;

    @Override
    public Type getType() {
        if (this.type == null) {
            String value = this.getUnsignedValue();
            BigInteger bigInt = new BigInteger(value);
            if (bigInt.bitLength() < 16) {
                this.type = IRUtils.getEGLPrimitiveType("eglx.lang.ESmallint");
                return this.type;
            }
            if (bigInt.bitLength() < 32) {
                this.type = IRUtils.getEGLPrimitiveType("eglx.lang.EInt");
                return this.type;
            }
            if (bigInt.bitLength() < 64) {
                this.type = IRUtils.getEGLPrimitiveType("eglx.lang.EBigint");
                return this.type;
            }
            this.type = IRUtils.getEGLPrimitiveType("eglx.lang.EDecimal", value.length(), 0);
            return this.type;
        }
        return this.type;
    }

    @Override
    public Object getObjectValue() {
        Type type = this.getType();
        if (type.equals(TypeUtils.Type_SMALLINT).booleanValue()) {
            return new Short(this.getValue());
        }
        if (type.equals(TypeUtils.Type_INT).booleanValue()) {
            return new Integer(this.getValue());
        }
        if (type.equals(TypeUtils.Type_BIGINT).booleanValue()) {
            return new Long(this.getValue());
        }
        return new BigInteger(this.getValue());
    }
}

