/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.dependency;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.edt.ide.core.internal.dependency.Function;
import org.eclipse.edt.ide.core.internal.dependency.IDependencyGraphEntry;

public class FunctionEntry
implements IDependencyGraphEntry {
    Set functions = Collections.EMPTY_SET;

    public void addFunction(Function function) {
        if (this.functions == Collections.EMPTY_SET) {
            this.functions = new HashSet();
        }
        this.functions.add(function);
    }

    public void removeFunction(Function function) {
        this.functions.remove(function);
    }

    public Set getFunctions() {
        return this.functions;
    }

    @Override
    public boolean isEmpty() {
        return this.functions.size() == 0;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.functions.size());
        for (Function function : this.functions) {
            function.serialize(outputStream);
        }
    }

    @Override
    public void deserialize(DataInputStream inputStream) throws IOException {
        int numFunctions = inputStream.readInt();
        int i = 0;
        while (i < numFunctions) {
            Function function = new Function();
            function.deserialize(inputStream);
            this.addFunction(function);
            ++i;
        }
    }

    @Override
    public int getKind() {
        return 3;
    }
}

