/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.model.Openable;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.WorkingCopy;
import org.eclipse.edt.ide.core.internal.search.matching.MatchLocator2;
import org.eclipse.edt.ide.core.internal.search.matching.MatchingNodeSet;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;

public class PotentialMatch {
    public static final String NO_SOURCE_FILE_NAME = "NO SOURCE FILE NAME";
    private MatchLocator2 locator;
    public IResource resource;
    public Openable openable;
    public char[][] compoundName;
    MatchingNodeSet matchingNodeSet;

    public PotentialMatch(MatchLocator2 locator, IResource resource, Openable openable) {
        this.locator = locator;
        this.resource = resource;
        this.openable = openable;
        this.matchingNodeSet = new MatchingNodeSet(locator);
        char[] qualifiedName = this.getQualifiedName();
        if (qualifiedName != null) {
            this.compoundName = CharOperation.splitOn((char)'.', (char[])qualifiedName);
        }
    }

    public boolean equals(Object obj) {
        if (this.compoundName == null) {
            return super.equals(obj);
        }
        if (!(obj instanceof PotentialMatch)) {
            return false;
        }
        return CharOperation.equals((char[][])this.compoundName, (char[][])((PotentialMatch)obj).compoundName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char[] getContents() {
        char[] source;
        block6: {
            source = null;
            try {
                if (this.openable instanceof WorkingCopy) {
                    IBuffer buffer = this.openable.getBuffer();
                    if (buffer == null) {
                        return null;
                    }
                    source = buffer.getCharacters();
                    break block6;
                }
                if (this.openable instanceof EGLFile) {
                    source = Util.getResourceContentsAsCharArray((IFile)this.resource);
                }
            }
            catch (EGLModelException eGLModelException) {}
        }
        if (source == null) {
            return CharOperation.NO_CHAR;
        }
        return source;
    }

    private char[] getQualifiedName() {
        if (this.openable instanceof EGLFile) {
            String fileName = this.resource.getFullPath().lastSegment();
            char[] mainTypeName = fileName.substring(0, fileName.length() - 4).toCharArray();
            EGLFile cu = (EGLFile)this.openable;
            return cu.getPart(new String(mainTypeName)).getFullyQualifiedName().toCharArray();
        }
        return null;
    }

    public int hashCode() {
        if (this.compoundName == null) {
            return super.hashCode();
        }
        int hashCode = 0;
        int i = 0;
        int length = this.compoundName.length;
        while (i < length) {
            hashCode += CharOperation.hashCode((char[])this.compoundName[i]);
            ++i;
        }
        return hashCode;
    }

    public char[] getMainTypeName() {
        return null;
    }

    public char[][] getPackageName() {
        int length = this.compoundName.length;
        if (length > 1) {
            return CharOperation.subarray((char[][])this.compoundName, (int)0, (int)(length - 1));
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    public String toString() {
        return this.openable == null ? "Fake PotentialMatch" : this.openable.toString();
    }

    public char[] getFileName() {
        return this.openable.getPath().toString().toCharArray();
    }
}

