/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.ide.core.AbstractGenerator;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.IIDECompiler;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProjectSettingsUtility {
    private static final IGenerator[] EMPTY_GENERATORS = new IGenerator[0];
    private static final String[] EMPTY_GENERATOR_IDS = new String[0];
    public static final String PROPERTY_COMPILER_ID = "compilerId";
    public static final String PROPERTY_GENERATOR_IDS = "generatorIds";
    public static final String PROJECT_KEY = "<project>";
    public static final String PROJECT_DEFAULT_DEPLOYMENT_DESCRIPTOR = "DefaultDeploymentDescriptorPath";
    public static final String LANGUAGE_JAVA = "Java";
    public static final String LANGUAGE_JAVASCRIPT = "JavaScript";
    public static final String GENERATOR_ID_JAVASCRIPT_DEV = "org.eclipse.edt.ide.gen.JavaScriptDevGenProvider";
    private static final Map<ICompiler, String[]> preferenceNodes = new HashMap<ICompiler, String[]>();
    private static final Object lock = new Object();

    private ProjectSettingsUtility() {
    }

    public static IIDECompiler getCompiler(IProject project) {
        String id = ProjectSettingsUtility.getCompilerId(project);
        if (id == null) {
            id = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString(PROPERTY_COMPILER_ID);
        }
        if (id != null) {
            IIDECompiler[] compilers = EDTCoreIDEPlugin.getPlugin().getCompilers();
            int i = 0;
            while (i < compilers.length) {
                if (compilers[i].getId().equals(id)) {
                    return compilers[i];
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCompilerId(IProject project) {
        if (project != null) {
            Preferences prefs;
            Object object = lock;
            synchronized (object) {
                prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node(PROPERTY_COMPILER_ID);
            }
            String setting = ProjectSettingsUtility.findSetting(project.getFullPath(), prefs, false);
            if (setting != null && (setting = setting.trim()).length() != 0) {
                return setting;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCompiler(IProject project, String id) throws BackingStoreException {
        Preferences prefs;
        Object object = lock;
        synchronized (object) {
            prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node(PROPERTY_COMPILER_ID);
        }
        if (id == null || id.length() == 0) {
            prefs.remove(ProjectSettingsUtility.keyFor(project.getFullPath()));
        } else {
            prefs.put(ProjectSettingsUtility.keyFor(project.getFullPath()), id);
        }
        object = lock;
        synchronized (object) {
            prefs.flush();
        }
    }

    public static IGenerator[] getGenerators(IResource resource) {
        String[] ids = ProjectSettingsUtility.getGeneratorIds(resource);
        if (ids == null) {
            ids = ProjectSettingsUtility.getWorkspaceGeneratorIds();
        }
        if (ids != null && ids.length != 0) {
            IIDECompiler compiler = ProjectSettingsUtility.getCompiler(resource.getProject());
            IGenerator[] gens = EDTCoreIDEPlugin.getPlugin().getGenerators();
            if (gens.length > 0) {
                ArrayList<IGenerator> generators = new ArrayList<IGenerator>(ids.length);
                int i = 0;
                while (i < gens.length) {
                    if (gens[i].getCompiler() == compiler) {
                        String nextId = gens[i].getId();
                        int j = 0;
                        while (j < ids.length) {
                            if (nextId.equals(ids[j].trim())) {
                                generators.add(gens[i]);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                return generators.toArray(new IGenerator[generators.size()]);
            }
        }
        return EMPTY_GENERATORS;
    }

    public static IGenerator[] getProjectGenerators(IProject resource) {
        String[] ids = ProjectSettingsUtility.getChildrenGeneratorIds((IResource)resource);
        if (ids.length != 0) {
            IIDECompiler compiler = ProjectSettingsUtility.getCompiler(resource.getProject());
            IGenerator[] gens = EDTCoreIDEPlugin.getPlugin().getGenerators();
            if (gens.length > 0) {
                ArrayList<IGenerator> generators = new ArrayList<IGenerator>(ids.length);
                int i = 0;
                while (i < gens.length) {
                    if (gens[i].getCompiler() == compiler) {
                        String nextId = gens[i].getId();
                        int j = 0;
                        while (j < ids.length) {
                            if (nextId.equals(ids[j].trim())) {
                                generators.add(gens[i]);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                return generators.toArray(new IGenerator[generators.size()]);
            }
        }
        return EMPTY_GENERATORS;
    }

    public static String[] getWorkspaceGeneratorIds() {
        String genIDs = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString(PROPERTY_GENERATOR_IDS);
        if (genIDs != null && (genIDs = genIDs.trim()).length() != 0) {
            return genIDs.split(",");
        }
        return EMPTY_GENERATOR_IDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getGeneratorIds(IResource resource) {
        Preferences prefs;
        IProject project = resource.getProject();
        Object object = lock;
        synchronized (object) {
            prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node(PROPERTY_GENERATOR_IDS);
        }
        String setting = ProjectSettingsUtility.findSetting(resource.getFullPath(), prefs, true);
        if (setting != null) {
            if ((setting = setting.trim()).length() != 0) {
                String[] ids = setting.split(",");
                int i = 0;
                while (i < ids.length) {
                    ids[i] = ids[i].trim();
                    ++i;
                }
                return ids;
            }
            return EMPTY_GENERATOR_IDS;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getChildrenGeneratorIds(IResource resource) {
        Preferences prefs;
        ArrayList<String> generators = new ArrayList<String>(0);
        IProject project = resource.getProject();
        Object object = lock;
        synchronized (object) {
            prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node(PROPERTY_GENERATOR_IDS);
        }
        try {
            String[] keys = prefs.keys();
            String resourcePath = ProjectSettingsUtility.keyFor(resource.getFullPath());
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String setting = prefs.get(key, null);
                String path = EclipseUtilities.convertToInternalPath(key);
                if ((PROJECT_KEY.equals(resourcePath) || ProjectSettingsUtility.pathStartWith(path, resourcePath)) && (setting = setting.trim()).length() != 0) {
                    String[] ids = setting.split(",");
                    int i = 0;
                    while (i < ids.length) {
                        generators.add(ids[i].trim());
                        ++i;
                    }
                }
                ++n2;
            }
        }
        catch (BackingStoreException bse) {
            EDTCoreIDEPlugin.log(bse);
        }
        if (ProjectSettingsUtility.findSetting(resource.getFullPath(), prefs, false) == null) {
            String[] stringArray = ProjectSettingsUtility.getWorkspaceGeneratorIds();
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String id = stringArray[n3];
                generators.add(id);
                ++n3;
            }
        }
        return generators.toArray(new String[generators.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGeneratorIds(IResource resource, String[] ids) throws BackingStoreException {
        Preferences prefs;
        IProject project = resource.getProject();
        Object object = lock;
        synchronized (object) {
            prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node(PROPERTY_GENERATOR_IDS);
        }
        if (ids == null) {
            prefs.remove(ProjectSettingsUtility.keyFor(resource.getFullPath()));
        } else if (ids.length == 0) {
            prefs.put(ProjectSettingsUtility.keyFor(resource.getFullPath()), "");
        } else {
            StringBuilder buf = new StringBuilder(100);
            int i = 0;
            while (i < ids.length) {
                if (i != 0) {
                    buf.append(',');
                }
                buf.append(ids[i]);
                ++i;
            }
            prefs.put(ProjectSettingsUtility.keyFor(resource.getFullPath()), buf.toString());
        }
        object = lock;
        synchronized (object) {
            prefs.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAllGeneratorIds(IProject project) throws BackingStoreException {
        Preferences prefs;
        Object object = lock;
        synchronized (object) {
            prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node(PROPERTY_GENERATOR_IDS);
        }
        prefs.clear();
        object = lock;
        synchronized (object) {
            prefs.flush();
        }
    }

    public static String findSetting(IPath path, Preferences prefs, boolean checkParent) {
        String setting = prefs.get(ProjectSettingsUtility.keyFor(path), null);
        if (checkParent && setting == null && path.segmentCount() > 1) {
            setting = ProjectSettingsUtility.findSetting(path.removeLastSegments(1), prefs, checkParent);
        }
        return setting;
    }

    public static String keyFor(IPath fullPath) {
        return fullPath.segmentCount() > 1 ? fullPath.removeFirstSegments(1).toString() : PROJECT_KEY;
    }

    public static IPath findPathForSetting(IPath path, Preferences prefs) {
        String setting = prefs.get(ProjectSettingsUtility.keyFor(path), null);
        if (setting != null) {
            return path;
        }
        if (path.segmentCount() > 1) {
            return ProjectSettingsUtility.findPathForSetting(path.removeLastSegments(1), prefs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGenerationDirectory(IResource resource, IPreferenceStore store, IEclipsePreferences prefs, String propertyID, String preferenceID) {
        Preferences propertyPrefs;
        Object object = lock;
        synchronized (object) {
            propertyPrefs = prefs.node(propertyID);
        }
        String setting = ProjectSettingsUtility.findSetting(resource.getFullPath(), propertyPrefs, true);
        if (setting != null && setting.length() > 0) {
            return setting;
        }
        if (store != null && preferenceID != null && preferenceID.length() > 0) {
            if (setting == null || setting.length() == 0) {
                setting = store.getString(preferenceID);
            }
            if (setting == null || setting.length() == 0) {
                setting = store.getDefaultString(preferenceID);
            }
        }
        return EclipseUtilities.convertToInternalPath(setting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGenerationArgument(IResource resource, IPreferenceStore store, IEclipsePreferences prefs, String propertyID) {
        Preferences propertyPrefs;
        Object object = lock;
        synchronized (object) {
            propertyPrefs = prefs.node(propertyID);
        }
        String setting = ProjectSettingsUtility.findSetting(resource.getFullPath(), propertyPrefs, true);
        if (setting != null && setting.length() > 0) {
            return setting;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGenerationDirectory(IResource resource, String value, IEclipsePreferences prefs, String propertyID) throws BackingStoreException {
        Preferences propertyPrefs;
        Object object = lock;
        synchronized (object) {
            propertyPrefs = prefs.node(propertyID);
        }
        if (value == null || value.length() == 0) {
            propertyPrefs.remove(ProjectSettingsUtility.keyFor(resource.getFullPath()));
        } else {
            propertyPrefs.put(ProjectSettingsUtility.keyFor(resource.getFullPath()), value);
        }
        object = lock;
        synchronized (object) {
            propertyPrefs.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultDeploymentDescriptor(IProject project, String pathValue) throws BackingStoreException {
        Preferences prefs;
        Object object = lock;
        synchronized (object) {
            prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node(PROJECT_DEFAULT_DEPLOYMENT_DESCRIPTOR);
        }
        if (pathValue == null || pathValue.length() == 0) {
            prefs.remove(ProjectSettingsUtility.keyFor(project.getFullPath()));
        } else {
            prefs.put(ProjectSettingsUtility.keyFor(project.getFullPath()), pathValue);
        }
        object = lock;
        synchronized (object) {
            prefs.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultDeploymentDescriptor(IResource resource) {
        Preferences prefs;
        IProject project = resource.getProject();
        Object object = lock;
        synchronized (object) {
            prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node(PROJECT_DEFAULT_DEPLOYMENT_DESCRIPTOR);
        }
        String setting = ProjectSettingsUtility.findSetting(resource.getFullPath(), prefs, true);
        if (setting != null) {
            setting = setting.trim();
            return setting;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGenerationArgument(IResource resource, String value, IEclipsePreferences prefs, String propertyID) throws BackingStoreException {
        Preferences propertyPrefs;
        Object object = lock;
        synchronized (object) {
            propertyPrefs = prefs.node(propertyID);
        }
        if (value == null || value.length() == 0) {
            propertyPrefs.remove(ProjectSettingsUtility.keyFor(resource.getFullPath()));
        } else {
            propertyPrefs.put(ProjectSettingsUtility.keyFor(resource.getFullPath()), value);
        }
        object = lock;
        synchronized (object) {
            propertyPrefs.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBuildFlag(IResource resource) throws BackingStoreException {
        if (resource != null) {
            Preferences prefs;
            IProject project = resource.getProject();
            Object object = lock;
            synchronized (object) {
                prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node("buildFlag");
            }
            String key = ProjectSettingsUtility.keyFor(resource.getFullPath());
            int buildFlag = prefs.getInt(key, 0);
            prefs.putInt(key, ++buildFlag);
            Object object2 = lock;
            synchronized (object2) {
                prefs.flush();
            }
        }
        IPreferenceStore store = EDTCoreIDEPlugin.getPlugin().getPreferenceStore();
        int buildFlag = store.getInt("buildFlag");
        store.setValue("buildFlag", ++buildFlag);
    }

    public static String[] getJavaGenerationDirectory(IProject project) {
        return ProjectSettingsUtility.getGenerationDirectoryForLanguage(project, LANGUAGE_JAVA);
    }

    public static String[] getJavaScriptGenerationDirectory(IProject project) {
        return ProjectSettingsUtility.getGenerationDirectoryForLanguage(project, LANGUAGE_JAVASCRIPT);
    }

    public static String getJavaScriptDevGenerationDirectory(IProject project) {
        IGenerator[] generators = ProjectSettingsUtility.getGenerators((IResource)project);
        int i = 0;
        while (i < generators.length) {
            IGenerator generator = generators[i];
            if (generator.getId().equalsIgnoreCase(GENERATOR_ID_JAVASCRIPT_DEV) && generator instanceof AbstractGenerator) {
                AbstractGenerator ideGenerator = (AbstractGenerator)generator;
                return ideGenerator.getOutputDirectory((IResource)project);
            }
            ++i;
        }
        return null;
    }

    protected static String[] getGenerationDirectoryForLanguage(IProject project, String language) {
        if (language == null) {
            return new String[0];
        }
        HashSet<String> retValue = new HashSet<String>();
        IGenerator[] generators = ProjectSettingsUtility.getProjectGenerators(project);
        int i = 0;
        while (i < generators.length) {
            IGenerator generator = generators[i];
            if (language.equalsIgnoreCase(generator.getLanguage()) && !generator.getId().equalsIgnoreCase(GENERATOR_ID_JAVASCRIPT_DEV) && generator instanceof AbstractGenerator) {
                AbstractGenerator ideGenerator = (AbstractGenerator)generator;
                String[] values = ideGenerator.getPrjojectOutputDirectors(project);
                int j = 0;
                while (j < values.length) {
                    retValue.add(values[j]);
                    ++j;
                }
            }
            ++i;
        }
        return retValue.toArray(new String[0]);
    }

    public static void replaceWorkspaceSettings(IPath oldPath, IPath newPath) throws BackingStoreException {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                ProjectSettingsUtility.replaceWorkspaceSettings(project, oldPath, newPath);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceWorkspaceSettings(IProject project, IPath oldPath, IPath newPath) throws BackingStoreException {
        String[] prefsFiles;
        Preferences projectPrefs;
        Object object = lock;
        synchronized (object) {
            projectPrefs = Platform.getPreferencesService().getRootNode().node("project").node(project.getName());
        }
        String[] stringArray = prefsFiles = ProjectSettingsUtility.getPreferenceNodes(project);
        int n = prefsFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String[] names;
            Preferences prefs;
            String file = stringArray[n2];
            Object object2 = lock;
            synchronized (object2) {
                prefs = projectPrefs.node(file);
            }
            String[] stringArray2 = names = prefs.childrenNames();
            int n3 = names.length;
            int n4 = 0;
            while (n4 < n3) {
                String[] keys;
                Preferences nextNode;
                String name = stringArray2[n4];
                Object object3 = lock;
                synchronized (object3) {
                    nextNode = prefs.node(name);
                }
                String[] stringArray3 = keys = nextNode.keys();
                int n5 = keys.length;
                int n6 = 0;
                while (n6 < n5) {
                    String pathStr;
                    String key = stringArray3[n6];
                    String oldKey = ProjectSettingsUtility.keyFor(oldPath);
                    String oldValue = EclipseUtilities.convertToInternalPath(oldPath.toString());
                    String oldValue1 = EclipseUtilities.convertToInternalPath(oldKey);
                    String value = nextNode.get(key, null);
                    if (ProjectSettingsUtility.pathStartWith(value, oldValue)) {
                        pathStr = EclipseUtilities.convertToInternalPath(newPath.toString());
                        value = value.replace(oldValue, pathStr);
                        nextNode.put(key, value);
                    } else if (ProjectSettingsUtility.pathStartWith(value, oldPath.toString())) {
                        pathStr = newPath.toString();
                        value = value.replace(oldPath.toString(), pathStr);
                        nextNode.put(key, value);
                    } else if (project.getFullPath().matchingFirstSegments(oldPath) == 1 && ProjectSettingsUtility.pathStartWith(value, oldValue1)) {
                        String newValue = EclipseUtilities.convertToInternalPath(ProjectSettingsUtility.keyFor(newPath));
                        value = value.replace(oldValue1, newValue);
                        nextNode.put(key, value);
                    } else if (!PROJECT_KEY.equals(key) && ProjectSettingsUtility.pathStartWith(key, oldKey)) {
                        nextNode.remove(key);
                        key = key.replace(oldKey, ProjectSettingsUtility.keyFor(newPath));
                        nextNode.put(key, value);
                    }
                    ++n6;
                }
                ++n4;
            }
            Object object4 = lock;
            synchronized (object4) {
                prefs.flush();
            }
            ++n2;
        }
    }

    public static void removeWorkspaceSettings(IPath path) throws BackingStoreException {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                ProjectSettingsUtility.removeWorkspaceSettings(project, path);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWorkspaceSettings(IProject project, IPath path) throws BackingStoreException {
        String[] prefsFiles;
        Preferences projectPrefs;
        Object object = lock;
        synchronized (object) {
            projectPrefs = Platform.getPreferencesService().getRootNode().node("project").node(project.getName());
        }
        String[] stringArray = prefsFiles = ProjectSettingsUtility.getPreferenceNodes(project);
        int n = prefsFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String[] names;
            Preferences prefs;
            String file = stringArray[n2];
            Object object2 = lock;
            synchronized (object2) {
                prefs = projectPrefs.node(file);
            }
            String[] stringArray2 = names = prefs.childrenNames();
            int n3 = names.length;
            int n4 = 0;
            while (n4 < n3) {
                String[] keys;
                Preferences nextNode;
                String name = stringArray2[n4];
                Object object3 = lock;
                synchronized (object3) {
                    nextNode = prefs.node(name);
                }
                String[] stringArray3 = keys = nextNode.keys();
                int n5 = keys.length;
                int n6 = 0;
                while (n6 < n5) {
                    String key = stringArray3[n6];
                    String oldKey = ProjectSettingsUtility.keyFor(path);
                    String oldValue = EclipseUtilities.convertToInternalPath(path.toString());
                    String oldValue1 = EclipseUtilities.convertToInternalPath(oldKey);
                    String value = nextNode.get(key, null);
                    if (!PROJECT_KEY.equals(oldKey) && key.equals(oldKey) || ProjectSettingsUtility.pathStartWith(value, oldValue) || ProjectSettingsUtility.pathStartWith(value, path.toString()) || project.getFullPath().matchingFirstSegments(path) == 1 && ProjectSettingsUtility.pathStartWith(value, oldValue1)) {
                        nextNode.remove(key);
                    }
                    ++n6;
                }
                ++n4;
            }
            Object object4 = lock;
            synchronized (object4) {
                prefs.flush();
            }
            ++n2;
        }
    }

    private static boolean pathStartWith(String path1, String path2) {
        return path1.equals(path2) || path1.startsWith(String.valueOf(path2) + "/");
    }

    private static String[] getPreferenceNodes(IProject project) {
        IIDECompiler compiler = ProjectSettingsUtility.getCompiler(project);
        String[] nodes = new String[]{};
        if (compiler != null && (nodes = preferenceNodes.get(compiler)) == null) {
            List gens = compiler.getGenerators();
            ArrayList<String> ids = new ArrayList<String>(gens.size());
            if (gens.size() > 0) {
                for (org.eclipse.edt.compiler.IGenerator gen : gens) {
                    String id;
                    if (!(gen instanceof IGenerator) || (id = ((IGenerator)gen).getProjectSettingsPluginId()) == null || id.length() <= 0 || ids.contains(id)) continue;
                    ids.add(id);
                }
            }
            nodes = ids.toArray(new String[ids.size()]);
            preferenceNodes.put(compiler, nodes);
        }
        String[] newNodes = new String[nodes.length + 1];
        System.arraycopy(nodes, 0, newNodes, 0, nodes.length);
        newNodes[nodes.length] = EDTCoreIDEPlugin.PLUGIN_ID;
        return newNodes;
    }
}

