/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor.sections;

import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSModel;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.ui.Activator;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.pde.internal.ds.ui.editor.DSInputContext;
import org.eclipse.pde.internal.ds.ui.editor.DSLabelProvider;
import org.eclipse.pde.internal.ds.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ds.ui.editor.dialogs.DSEditPropertiesDialog;
import org.eclipse.pde.internal.ds.ui.editor.dialogs.DSEditPropertyDialog;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DSPropertiesSection
extends TableSection {
    private TableViewer fPropertiesTable;
    private Action fRemoveAction;
    private Action fAddPropertiesAction;
    private Action fAddPropertyAction;
    private Action fEditAction;
    private static final int F_UP_FLAG = -1;
    private static final int F_DOWN_FLAG = 1;

    public DSPropertiesSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{Messages.DSPropertiesSection_addProperties, Messages.DSPropertiesSection_addProperty, Messages.DSPropertiesSection_edit, Messages.DSPropertiesSection_remove, Messages.DSPropertiesSection_up, Messages.DSPropertiesSection_down});
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(Messages.DSPropertiesSection_title);
        section.setDescription(Messages.DSPropertiesSection_description);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        section.setLayoutData((Object)data);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setEditable(this.isEditable());
        this.createViewerPartControl(container, 65538, 2, toolkit);
        this.fPropertiesTable = tablePart.getTableViewer();
        this.fPropertiesTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fPropertiesTable.setLabelProvider((IBaseLabelProvider)new DSLabelProvider());
        this.makeActions();
        IDSModel model = this.getDSModel();
        if (model != null) {
            this.fPropertiesTable.setInput((Object)model);
            model.addModelChangedListener((IModelChangedListener)this);
        }
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
    }

    public void dispose() {
        IDSModel model = this.getDSModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
    }

    public void refresh() {
        this.fPropertiesTable.refresh();
        this.updateButtons();
        this.updateTitle();
    }

    private void updateTitle() {
        int itemCount = this.fPropertiesTable.getTable().getItemCount();
        this.getSection().setText(NLS.bind((String)Messages.DSPropertiesSection_title, (Object)new Integer(itemCount)));
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAddProperties();
                break;
            }
            case 1: {
                this.handleAddProperty();
                break;
            }
            case 2: {
                this.handleEdit();
                break;
            }
            case 3: {
                this.handleRemove();
                break;
            }
            case 4: {
                this.handleUpDown(-1);
                break;
            }
            case 5: {
                this.handleUpDown(1);
            }
        }
    }

    private void handleUpDown(int newRelativeIndex) {
        ISelection sel = this.fPropertiesTable.getSelection();
        Object[] array = ((IStructuredSelection)sel).toArray();
        if (newRelativeIndex == -1) {
            this.moveUp(newRelativeIndex, array);
        } else {
            this.moveDown(newRelativeIndex, array);
        }
    }

    private void moveDown(int newRelativeIndex, Object[] array) {
        int i = array.length - 1;
        while (i >= 0) {
            Object object = array[i];
            if (object != null && object instanceof IDocumentElementNode) {
                this.getDSModel().getDSComponent().moveChildNode((IDocumentElementNode)object, newRelativeIndex, true);
            }
            --i;
        }
    }

    private void moveUp(int newRelativeIndex, Object[] array) {
        int i = 0;
        while (i < array.length) {
            Object object = array[i];
            if (object != null && object instanceof IDocumentElementNode) {
                this.getDSModel().getDSComponent().moveChildNode((IDocumentElementNode)object, newRelativeIndex, true);
            }
            ++i;
        }
    }

    private void handleAddProperty() {
        DSEditPropertyDialog dialog = new DSEditPropertyDialog(Activator.getActiveWorkbenchShell(), this.createPropertyElement(), this, true);
        dialog.open();
    }

    private void handleEdit() {
        int selectionIndex;
        ISelection selection = this.fPropertiesTable.getSelection();
        if (selection != null && (selectionIndex = this.fPropertiesTable.getTable().getSelectionIndex()) != -1) {
            Object selectionElement = this.fPropertiesTable.getElementAt(selectionIndex);
            if (selectionElement instanceof IDSProperties) {
                DSEditPropertiesDialog dialog = new DSEditPropertiesDialog(Activator.getActiveWorkbenchShell(), (IDSProperties)selectionElement, this);
                dialog.create();
                dialog.getShell().setSize(500, 200);
                dialog.open();
            } else if (selectionElement instanceof IDSProperty) {
                DSEditPropertyDialog dialog = new DSEditPropertyDialog(Activator.getActiveWorkbenchShell(), (IDSProperty)selectionElement, this, false);
                dialog.create();
                dialog.getShell().setSize(500, 300);
                dialog.open();
            }
        }
    }

    private void makeActions() {
        this.fAddPropertiesAction = new Action(Messages.DSPropertiesSection_addProperties){

            public void run() {
                DSPropertiesSection.this.handleAddProperties();
            }
        };
        this.fAddPropertiesAction.setEnabled(this.isEditable());
        this.fAddPropertyAction = new Action(Messages.DSPropertiesSection_addProperty){

            public void run() {
                DSPropertiesSection.this.handleAddProperty();
            }
        };
        this.fAddPropertyAction.setEnabled(this.isEditable());
        this.fEditAction = new Action(Messages.DSPropertiesSection_edit){

            public void run() {
                DSPropertiesSection.this.handleEdit();
            }
        };
        this.fEditAction.setEnabled(this.isEditable());
        this.fRemoveAction = new Action(Messages.DSPropertiesSection_remove){

            public void run() {
                DSPropertiesSection.this.handleRemove();
            }
        };
        this.fRemoveAction.setEnabled(this.isEditable());
    }

    private void updateButtons() {
        Table table = this.fPropertiesTable.getTable();
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, this.isEditable());
        tablePart.setButtonEnabled(1, this.isEditable());
        tablePart.setButtonEnabled(2, this.isEditable() && table.getSelection().length > 0);
        tablePart.setButtonEnabled(3, this.isEditable());
        tablePart.setButtonEnabled(4, this.isEditable() && table.getSelection().length > 0 && !table.isSelected(0));
        tablePart.setButtonEnabled(5, this.isEditable() && table.getSelection().length > 0 && !table.isSelected(table.getItems().length - 1));
    }

    private void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fPropertiesTable.getSelection();
        if (ssel.size() > 0) {
            Iterator iter = ssel.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (object instanceof IDSProperties) {
                    this.getDSModel().getDSComponent().removePropertiesElement((IDSProperties)object);
                }
                if (!(object instanceof IDSProperty)) continue;
                this.getDSModel().getDSComponent().removePropertyElement((IDSProperty)object);
            }
        }
    }

    private void handleAddProperties() {
        this.doOpenSelectionDialogProperties();
    }

    private void doOpenSelectionDialogProperties() {
        final IProject project = this.getProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Activator.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)project.getWorkspace());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).equals((Object)project);
                }
                return true;
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle(Messages.DSPropertiesDetails_dialogTitle);
        dialog.setMessage(Messages.DSPropertiesDetails_dialogMessage);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] instanceof IFile) {
                    return new Status(0, "org.eclipse.pde.ds.ui", 0, "", null);
                }
                return new Status(4, "org.eclipse.pde.ds.ui", 4, "", null);
            }
        });
        if (dialog.open() == 0) {
            IResource res = (IResource)dialog.getFirstResult();
            IPath path = res.getProjectRelativePath();
            if (res instanceof IContainer) {
                path = path.addTrailingSeparator();
            }
            String value = path.toString();
            this.addProperties(value);
        }
    }

    private void addProperties(String entry) {
        IDSDocumentFactory factory = this.getDSModel().getFactory();
        IDSComponent component = this.getDSModel().getDSComponent();
        IDSProperties properties = factory.createProperties();
        properties.setEntry(entry);
        component.addPropertiesElement(properties);
    }

    private IDSProperty createPropertyElement() {
        IDSDocumentFactory factory = this.getDSModel().getFactory();
        IDSProperty property = factory.createProperty();
        return property;
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        } else if (e.getChangeType() == 2) {
            Object[] objects = e.getChangedObjects();
            int i = 0;
            while (i < objects.length) {
                int index;
                Table table = this.fPropertiesTable.getTable();
                if (objects[i] instanceof IDSProperties) {
                    index = table.getSelectionIndex();
                    this.fPropertiesTable.remove(objects[i]);
                    if (this.canSelect()) {
                        table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
                    }
                }
                if (objects[i] instanceof IDSProperty) {
                    index = table.getSelectionIndex();
                    this.fPropertiesTable.remove(objects[i]);
                    if (this.canSelect()) {
                        table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
                    }
                }
                ++i;
            }
            this.updateButtons();
        } else if (e.getChangeType() == 1) {
            Object[] objects = e.getChangedObjects();
            if (objects.length > 0) {
                this.fPropertiesTable.refresh();
                this.fPropertiesTable.setSelection((ISelection)new StructuredSelection(objects[objects.length - 1]));
            }
            this.updateButtons();
        } else {
            this.fPropertiesTable.refresh();
            this.updateButtons();
        }
        this.fPropertiesTable.getTable().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!DSPropertiesSection.this.fPropertiesTable.getTable().isDisposed()) {
                    DSPropertiesSection.this.updateTitle();
                }
            }
        });
    }

    private DSInputContext getDSContext() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        return (DSInputContext)manager.findContext("ds-context");
    }

    private IDSModel getDSModel() {
        DSInputContext context = this.getDSContext();
        return context == null ? null : (IDSModel)context.getModel();
    }

    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        return false;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons();
    }

    class ContentProvider
    extends DefaultTableProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IDSModel model;
            IDSComponent component;
            if (inputElement instanceof IDSModel && (component = (model = (IDSModel)inputElement).getDSComponent()) != null) {
                IDocumentElementNode[] childNodes = component.getChildNodes();
                int propertyLength = 0;
                int propertiesLength = 0;
                if (component.getPropertyElements() != null) {
                    propertyLength = component.getPropertyElements().length;
                }
                if (component.getPropertiesElements() != null) {
                    propertiesLength = component.getPropertiesElements().length;
                }
                Object[] props = new Object[propertyLength + propertiesLength];
                int index = 0;
                int i = 0;
                while (i < childNodes.length) {
                    IDocumentElementNode child = childNodes[i];
                    if (child instanceof IDSProperties || child instanceof IDSProperty) {
                        props[index] = child;
                        ++index;
                    }
                    ++i;
                }
                return props;
            }
            return new Object[0];
        }
    }
}

