/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.utility.CommandExecutor;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.jpa.core.JpaAnnotationProvider;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceCompilationUnit;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceTypeCompilationUnit
extends SourceCompilationUnit {
    private JavaResourcePersistentType persistentType = this.buildPersistentType();

    public SourceTypeCompilationUnit(ICompilationUnit compilationUnit, JpaAnnotationProvider annotationProvider, AnnotationEditFormatter annotationEditFormatter, CommandExecutor modifySharedDocumentCommandExecutor) {
        super(compilationUnit, annotationProvider, annotationEditFormatter, modifySharedDocumentCommandExecutor);
    }

    private JavaResourcePersistentType buildPersistentType() {
        this.openCompilationUnit();
        CompilationUnit astRoot = this.buildASTRoot();
        this.closeCompilationUnit();
        return this.buildPersistentType(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncPersistentType(astRoot);
    }

    @Override
    public Iterator<JavaResourcePersistentType> persistentTypes() {
        return this.persistentType == null ? EmptyIterator.instance() : this.persistentType.allTypes();
    }

    public JptResourceType getResourceType() {
        return JptCommonCorePlugin.JAVA_SOURCE_RESOURCE_TYPE;
    }

    @Override
    public void resolveTypes() {
        if (this.persistentType != null) {
            this.persistentType.resolveTypes(this.buildASTRoot());
        }
    }

    private JavaResourcePersistentType buildPersistentType(CompilationUnit astRoot) {
        TypeDeclaration td = this.getPrimaryTypeDeclaration(astRoot);
        return td == null ? null : this.buildPersistentType(astRoot, td);
    }

    private void syncPersistentType(CompilationUnit astRoot) {
        TypeDeclaration td = this.getPrimaryTypeDeclaration(astRoot);
        if (td == null) {
            this.syncPersistentType_(null);
        } else if (this.persistentType == null) {
            this.syncPersistentType_(this.buildPersistentType(astRoot, td));
        } else {
            this.persistentType.synchronizeWith(astRoot);
        }
    }

    private void syncPersistentType_(JavaResourcePersistentType astPersistentType) {
        JavaResourcePersistentType old = this.persistentType;
        this.persistentType = astPersistentType;
        this.firePropertyChanged("persistentTypes", old, astPersistentType);
    }

    private JavaResourcePersistentType buildPersistentType(CompilationUnit astRoot, TypeDeclaration typeDeclaration) {
        return SourcePersistentType.newInstance(this, typeDeclaration, astRoot);
    }

    private TypeDeclaration getPrimaryTypeDeclaration(CompilationUnit astRoot) {
        String primaryTypeName = this.getPrimaryTypeName();
        for (AbstractTypeDeclaration atd : this.types(astRoot)) {
            if (!this.nodeIsPrimaryTypeDeclaration(atd, primaryTypeName)) continue;
            return atd.resolveBinding() == null ? null : (TypeDeclaration)atd;
        }
        return null;
    }

    private boolean nodeIsPrimaryTypeDeclaration(AbstractTypeDeclaration atd, String primaryTypeName) {
        return atd.getNodeType() == 55 && atd.getName().getFullyQualifiedName().equals(primaryTypeName);
    }

    private String getPrimaryTypeName() {
        return this.getCompilationUnitName();
    }

    private List<AbstractTypeDeclaration> types(CompilationUnit astRoot) {
        return astRoot.types();
    }
}

