/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ForeignLanguageTypeBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.SystemFunctionParameterSpecialTypeBinding;
import org.eclipse.edt.compiler.core.ast.AsExpression;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.jface.text.ITextViewer;

public class EGLJavaLibArgumentProposalHandler
extends EGLAbstractProposalHandler {
    private Node boundNode;

    public EGLJavaLibArgumentProposalHandler(ITextViewer viewer, int documentOffset, String prefix, Node boundNode) {
        super(viewer, documentOffset, prefix);
        this.boundNode = boundNode;
    }

    public List getProposals() {
        ITypeBinding parameterType = this.getMatchingParameterType(this.boundNode);
        if (parameterType != null) {
            if (SystemFunctionParameterSpecialTypeBinding.OBJIDTYPE == parameterType || SystemFunctionParameterSpecialTypeBinding.OBJIDTYPEOPT == parameterType) {
                return this.createObjIdProposals();
            }
            if (SystemFunctionParameterSpecialTypeBinding.ANYEGLORASJAVA == parameterType) {
                return this.createJavaCastProposals();
            }
        }
        return Collections.EMPTY_LIST;
    }

    private List createObjIdProposals() {
        return this.createProposals(new String[]{ForeignLanguageTypeBinding.OBJIDJAVA.getCaseSensitiveName()});
    }

    private List createJavaCastProposals() {
        Node node = this.boundNode;
        while (!(node instanceof AsExpression)) {
            node = node.getParent();
        }
        ITypeBinding tBinding = ((AsExpression)node).getExpression().resolveTypeBinding();
        if (Binding.isValidBinding((IBinding)tBinding) && 3 == tBinding.getKind()) {
            Primitive prim = ((PrimitiveTypeBinding)tBinding).getPrimitive();
            if (Primitive.BOOLEAN == prim) {
                return this.createProposals(new String[]{ForeignLanguageTypeBinding.JAVABOOLEAN.getCaseSensitiveName()});
            }
            if (Primitive.isStringType((Primitive)prim)) {
                return this.createProposals(new String[]{ForeignLanguageTypeBinding.JAVACHAR.getCaseSensitiveName()});
            }
            if (Primitive.isNumericType((Primitive)prim)) {
                return this.createProposals(new String[]{ForeignLanguageTypeBinding.JAVASHORT.getCaseSensitiveName(), ForeignLanguageTypeBinding.JAVAINT.getCaseSensitiveName(), ForeignLanguageTypeBinding.JAVALONG.getCaseSensitiveName(), ForeignLanguageTypeBinding.JAVAFLOAT.getCaseSensitiveName(), ForeignLanguageTypeBinding.JAVADOUBLE.getCaseSensitiveName(), ForeignLanguageTypeBinding.JAVABOOLEAN.getCaseSensitiveName(), ForeignLanguageTypeBinding.JAVABIGINTEGER.getCaseSensitiveName(), ForeignLanguageTypeBinding.JAVABIGDECIMAL.getCaseSensitiveName(), ForeignLanguageTypeBinding.JAVABYTE.getCaseSensitiveName()});
            }
        }
        return new ArrayList();
    }

    private ITypeBinding getMatchingParameterType(Node boundNode) {
        List parameters;
        Node lastNode = boundNode;
        Node parentNode = boundNode.getParent();
        while (!(parentNode instanceof FunctionInvocation)) {
            lastNode = parentNode;
            parentNode = lastNode.getParent();
        }
        FunctionInvocation functionInvocation = (FunctionInvocation)parentNode;
        IFunctionBinding fBinding = (IFunctionBinding)functionInvocation.getTarget().resolveDataBinding().getType();
        int argNum = functionInvocation.getArguments().indexOf(lastNode);
        if (argNum < (parameters = fBinding.getParameters()).size()) {
            return ((FunctionParameterBinding)parameters.get(argNum)).getType();
        }
        return null;
    }

    private List createProposals(String[] strings) {
        ArrayList<EGLCompletionProposal> result = new ArrayList<EGLCompletionProposal>();
        int i = 0;
        while (i < strings.length) {
            if (strings[i].toUpperCase().startsWith(this.getPrefix().toUpperCase())) {
                result.add(this.createProposal(strings[i]));
            }
            ++i;
        }
        return result;
    }

    private EGLCompletionProposal createProposal(String caseSensitiveName) {
        String proposalString = this.needQuotes() ? "\"" + caseSensitiveName + "\"" : caseSensitiveName;
        return new EGLCompletionProposal(this.viewer, caseSensitiveName, proposalString, null, this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), proposalString.length(), 61, "");
    }

    private boolean needQuotes() {
        return !(this.boundNode instanceof StringLiteral) || this.getDocumentOffset() <= this.boundNode.getOffset();
    }
}

