/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.project.wizard.pages;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.PPListElement;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.project.wizard.pages.ContainerWizardPage;
import org.eclipse.edt.ide.ui.internal.project.wizards.NewEGLProjectWizard;
import org.eclipse.edt.ide.ui.internal.util.TabFolderLayout;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.buildpaths.EGLPathOrderingWorkbookPage;
import org.eclipse.edt.ide.ui.internal.wizards.buildpaths.PPListLabelProvider;
import org.eclipse.edt.ide.ui.internal.wizards.buildpaths.ProjectsWorkbookPage;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.edt.ide.ui.project.templates.ProjectTemplateWizard;
import org.eclipse.edt.ide.ui.wizards.EGLProjectUtility;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SourceProjectWizardCapabilityPage
extends ContainerWizardPage {
    private boolean fCanRemoveContent = false;
    private IPath fCurrProjectLocation = null;
    protected IProject fCurrProject = null;
    private IPath fOutputLocationPath;
    private CheckedListDialogField fClassPathList;
    private StringButtonDialogField fBuildPathDialogField;
    private ProjectsWorkbookPage fProjectsPage;
    private StatusInfo fClassPathStatus;
    private StatusInfo fBuildPathStatus;
    private List<String> fSelectedImportProjectList;

    public void setfSelectedImportProjectList(List<String> fSelectedImportProjectList) {
        this.fSelectedImportProjectList = fSelectedImportProjectList;
        if (this.fProjectsPage != null) {
            this.fProjectsPage.updateSelectedImportProjectList(fSelectedImportProjectList);
            this.fProjectsPage.setfSelectedImportProjectList(fSelectedImportProjectList);
        }
    }

    public SourceProjectWizardCapabilityPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.CapabilityConfigurationPageTitle);
        this.setDescription(NewWizardMessages.CapabilityConfigurationPageDescription);
        this.fClassPathStatus = new StatusInfo();
        this.fBuildPathStatus = new StatusInfo();
    }

    private ProjectConfiguration getConfiguration() {
        ProjectTemplateWizard wizard = (ProjectTemplateWizard)this.getWizard();
        return ((NewEGLProjectWizard)wizard.getParentWizard()).getModel();
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.createCapabilityControls(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_PROJECT_REQUIRED_PROJECTS);
        this.validatePage();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.changeToNewProject();
        } else {
            this.removeProject();
        }
        super.setVisible(visible);
    }

    private void createCapabilityControls(Composite composite) {
        BuildPathAdapter adapter = new BuildPathAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = NewWizardMessages.BuildPathsBlockClasspathUpButton;
        stringArray[1] = NewWizardMessages.BuildPathsBlockClasspathDownButton;
        stringArray[3] = NewWizardMessages.BuildPathsBlockClasspathCheckallButton;
        stringArray[4] = NewWizardMessages.BuildPathsBlockClasspathUncheckallButton;
        String[] buttonLabels = stringArray;
        this.fClassPathList = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)new PPListLabelProvider());
        this.fClassPathList.setDialogFieldListener(adapter);
        this.fClassPathList.setLabelText(NewWizardMessages.BuildPathsBlockClasspathLabel);
        this.fClassPathList.setUpButtonIndex(0);
        this.fClassPathList.setDownButtonIndex(1);
        this.fClassPathList.setCheckAllButtonIndex(3);
        this.fClassPathList.setUncheckAllButtonIndex(4);
        this.fBuildPathDialogField = new StringButtonDialogField(adapter);
        this.fBuildPathDialogField.setButtonLabel(NewWizardMessages.BuildPathsBlockBuildpathButton);
        this.fBuildPathDialogField.setDialogFieldListener(adapter);
        this.fBuildPathDialogField.setLabelText(NewWizardMessages.BuildPathsBlockBuildpathLabel);
        Composite tabComposite = new Composite(composite, 0);
        GridLayout tabLayout = new GridLayout();
        tabLayout.marginWidth = 0;
        tabLayout.numColumns = 1;
        tabComposite.setLayout((Layout)tabLayout);
        tabComposite.setLayoutData((Object)new GridData(1808));
        TabFolder folder = new TabFolder(tabComposite, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        this.fProjectsPage = new ProjectsWorkbookPage(this.fClassPathList);
        IWorkbench workbench = EDTUIPlugin.getDefault().getWorkbench();
        Image projectImage = workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        TabItem item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlockTabProjects);
        item.setImage(projectImage);
        item.setData((Object)this.fProjectsPage);
        item.setControl(this.fProjectsPage.getControl((Composite)folder));
        Image cpoImage = PluginImages.DESC_OBJS_EGLBUILDPATH_ORDER.createImage();
        EGLPathOrderingWorkbookPage ordpage = new EGLPathOrderingWorkbookPage(this.fClassPathList);
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlockTabOrder);
        item.setImage(cpoImage);
        item.setData((Object)ordpage);
        item.setControl(ordpage.getControl((Composite)folder));
        if (this.fCurrProject != null) {
            this.fProjectsPage.init(EGLCore.create((IProject)this.fCurrProject));
        }
    }

    private void handleBuildPathDialogFieldChanged(DialogField field) {
        this.getConfiguration().setRequiredProjects(this.fClassPathList.getElements());
        this.validatePage();
    }

    private void changeToNewProject() {
        Path newProjectLocation;
        IProject newProjectHandle = this.fWorkspaceRoot.getProject(this.getConfiguration().getProjectName());
        this.fCanRemoveContent = this.getConfiguration().isUseDefaults() ? !(newProjectLocation = new Path(this.getConfiguration().getInitialProjectLocation())).append(this.getConfiguration().getProjectName()).toFile().exists() : !(newProjectLocation = new Path(this.getConfiguration().getCustomProjectLocation())).toFile().exists();
        final boolean initialize = !newProjectHandle.equals((Object)this.fCurrProject) || !newProjectLocation.equals((Object)this.fCurrProjectLocation);
        final boolean noProgressMonitor = !initialize && this.fCanRemoveContent;
        final IProject preCreationProject = newProjectHandle;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null || noProgressMonitor) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    monitor.beginTask(NewWizardMessages.NewProjectCreationWizardPageEarlyCreationOperationDesc, 2);
                    if (initialize) {
                        IEGLPathEntry[] entries = null;
                        IPath outputLocation = null;
                        SourceProjectWizardCapabilityPage.this.init(EGLCore.create((IProject)preCreationProject), outputLocation, entries, false);
                    }
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, true, op);
            this.fCurrProject = newProjectHandle;
            this.fCurrProjectLocation = newProjectLocation;
        }
        catch (InvocationTargetException invocationTargetException) {
            String message = NewWizardMessages.NewProjectCreationWizardPageEarlyCreationOperationErrorDesc;
            EDTUIPlugin.logErrorMessage(message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                boolean noProgressMonitor = Platform.getLocation().equals((Object)SourceProjectWizardCapabilityPage.this.fCurrProjectLocation);
                if (monitor == null || noProgressMonitor) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(NewWizardMessages.NewProjectCreationWizardPageRemoveprojectDesc, 3);
                try {
                    try {
                        SourceProjectWizardCapabilityPage.this.fCurrProject.delete(SourceProjectWizardCapabilityPage.this.fCanRemoveContent, false, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                    SourceProjectWizardCapabilityPage.this.fCurrProject = null;
                    SourceProjectWizardCapabilityPage.this.fCanRemoveContent = false;
                }
            }
        };
        try {
            op.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException invocationTargetException) {
            String message = NewWizardMessages.NewProjectCreationWizardPageOp_error_removeMessage;
            EDTUIPlugin.logErrorMessage(message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void init(IEGLProject eproject, IPath defaultOutputLocation, IEGLPathEntry[] defaultEntries, boolean defaultsOverrideExistingEGLPath) {
        PPListElement currEGL;
        if (!defaultsOverrideExistingEGLPath && eproject.exists() && eproject.getProject().getFile(".classpath").exists()) {
            defaultOutputLocation = null;
            defaultEntries = null;
        }
        IEGLProject fCurrEProject = eproject;
        IPath outputLocation = defaultOutputLocation;
        IEGLPathEntry[] eglPathEntries = defaultEntries;
        boolean projectExists = false;
        List<PPListElement> newEGLPath = null;
        try {
            IProject project = fCurrEProject.getProject();
            boolean bl = projectExists = project.exists() && project.getFile(".eglPath").exists();
            if (projectExists) {
                if (outputLocation == null) {
                    outputLocation = fCurrEProject.getOutputLocation();
                }
                if (eglPathEntries == null) {
                    eglPathEntries = fCurrEProject.getRawEGLPath();
                }
            }
            if (outputLocation == null) {
                outputLocation = EGLProjectUtility.getDefaultEGLOutputPath(eproject);
            }
            if (eglPathEntries != null) {
                newEGLPath = EGLProjectUtility.getExistingEntries(eglPathEntries, eproject);
            }
        }
        catch (CoreException e) {
            EDTUIPlugin.log(e);
        }
        if (newEGLPath == null) {
            newEGLPath = EGLProjectUtility.getDefaultClassPath(eproject);
        }
        ArrayList<PPListElement> exportedEntries = new ArrayList<PPListElement>();
        int i = 0;
        while (i < newEGLPath.size()) {
            currEGL = newEGLPath.get(i);
            if (currEGL.isExported() || currEGL.getEntryKind() == 3) {
                exportedEntries.add(currEGL);
            }
            ++i;
        }
        this.fBuildPathDialogField.setText(outputLocation.makeRelative().toString());
        this.fBuildPathDialogField.enableButton(projectExists);
        i = 0;
        while (i < exportedEntries.size()) {
            currEGL = (PPListElement)exportedEntries.get(i);
            if (currEGL.isExported() || currEGL.getEntryKind() == 3) {
                this.fClassPathList.setGrayedWithoutUpdate(currEGL, true);
            }
            ++i;
        }
        this.fClassPathList.setElements(newEGLPath);
        this.fClassPathList.setCheckedElements(exportedEntries);
        this.fClassPathList.refresh();
        if (this.fProjectsPage != null) {
            this.fProjectsPage.setfSelectedImportProjectList(this.fSelectedImportProjectList);
            this.fProjectsPage.init(fCurrEProject);
        }
        this.fOutputLocationPath = outputLocation;
        this.validatePage();
    }

    private void validatePage() {
        IEGLModelStatus status;
        PPListElement currElement;
        this.fClassPathStatus.setOK();
        List<PPListElement> elements = this.getConfiguration().getRequiredProjects();
        PPListElement entryMissing = null;
        int nEntriesMissing = 0;
        IEGLPathEntry[] entries = new IEGLPathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            currElement = elements.get(i);
            boolean isChecked = this.fClassPathList.isChecked(currElement);
            if (currElement.getEntryKind() == 3) {
                if (!isChecked) {
                    this.fClassPathList.setCheckedWithoutUpdate(currElement, true);
                }
            } else {
                currElement.setExported(isChecked);
            }
            entries[i] = currElement.getEGLPathEntry();
            if (currElement.isMissing()) {
                ++nEntriesMissing;
                if (entryMissing == null) {
                    entryMissing = currElement;
                }
            }
            --i;
        }
        if (nEntriesMissing > 0) {
            if (nEntriesMissing == 1) {
                this.fClassPathStatus.setWarning(NewWizardMessages.bind((String)NewWizardMessages.BuildPathsBlockWarningEntryMissing, (Object)entryMissing.getPath().toString()));
            } else {
                this.fClassPathStatus.setWarning(NewWizardMessages.bind((String)NewWizardMessages.BuildPathsBlockWarningEntriesMissing, (Object)String.valueOf(nEntriesMissing)));
            }
        }
        this.fBuildPathStatus.setOK();
        elements = this.getConfiguration().getRequiredProjects();
        entries = new IEGLPathEntry[elements.size()];
        i = elements.size() - 1;
        while (i >= 0) {
            currElement = elements.get(i);
            entries[i] = currElement.getEGLPathEntry();
            --i;
        }
        if (this.fCurrProject != null && entries.length > 0 && this.fCurrProjectLocation != null && !(status = EGLConventions.validateEGLPath((IEGLProject)EGLCore.create((IProject)this.fCurrProject), (IEGLPathEntry[])entries, (IPath)this.fOutputLocationPath)).isOK()) {
            this.fBuildPathStatus.setError(status.getMessage());
        }
        this.updateStatus(new IStatus[]{this.fClassPathStatus, this.fBuildPathStatus});
    }

    private class BuildPathAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private BuildPathAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            SourceProjectWizardCapabilityPage.this.handleBuildPathDialogFieldChanged(field);
        }
    }
}

