/*
 * Decompiled with CFR 0.152.
 */
package eglx.persistence.sql;

import eglx.lang.EDictionary;
import eglx.persistence.sql.SQLDataSource;
import eglx.persistence.sql.SQLException;
import java.sql.Connection;
import javax.naming.NamingException;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.Runtime;
import org.eclipse.edt.javart.util.JavartUtil;

public class SQLJNDIDataSource
extends SQLDataSource {
    public SQLJNDIDataSource(String connectionUrl) {
        super(connectionUrl);
    }

    public SQLJNDIDataSource(String connectionUrl, RunUnit ru) {
        super(connectionUrl, ru);
    }

    public SQLJNDIDataSource(String connectionUrl, EDictionary properties) {
        super(connectionUrl, properties);
    }

    @Override
    public Connection getConnection() throws SQLException {
        block15: {
            if (this.conn == null) {
                CommonDataSource ds;
                String jndiName = this.connectionUrl;
                if (!jndiName.startsWith("java:comp/env/")) {
                    jndiName = "java:comp/env/" + jndiName;
                }
                try {
                    ds = (CommonDataSource)Runtime.getRunUnit().jndiLookup(jndiName);
                }
                catch (NamingException ne) {
                    try {
                        ds = (CommonDataSource)Runtime.getRunUnit().jndiLookup(this.connectionUrl);
                    }
                    catch (NamingException namingException) {
                        SQLException sqlEx = new SQLException();
                        throw sqlEx.fillInMessage("EGL0050E", jndiName, ne);
                    }
                }
                String user = this.properties.getProperty("user");
                String password = this.properties.getProperty("password");
                try {
                    if (!(user != null && user.length() != 0 || password != null && password.length() != 0)) {
                        if (ds instanceof DataSource) {
                            this.conn = ((DataSource)ds).getConnection();
                            break block15;
                        }
                        if (ds instanceof ConnectionPoolDataSource) {
                            this.conn = ((ConnectionPoolDataSource)ds).getPooledConnection().getConnection();
                            break block15;
                        }
                        if (ds instanceof XADataSource) {
                            this.conn = ((XADataSource)ds).getXAConnection().getConnection();
                            break block15;
                        }
                        SQLException sqlEx = new SQLException();
                        throw sqlEx.fillInMessage("EGL0051E", ds == null ? "null" : ds.getClass().getCanonicalName());
                    }
                    if (ds instanceof DataSource) {
                        this.conn = ((DataSource)ds).getConnection(user, password);
                        break block15;
                    }
                    if (ds instanceof ConnectionPoolDataSource) {
                        this.conn = ((ConnectionPoolDataSource)ds).getPooledConnection(user, password).getConnection();
                        break block15;
                    }
                    if (ds instanceof XADataSource) {
                        this.conn = ((XADataSource)ds).getXAConnection(user, password).getConnection();
                        break block15;
                    }
                    SQLException sqlEx = new SQLException();
                    throw sqlEx.fillInMessage("EGL0051E", ds == null ? "null" : ds.getClass().getCanonicalName());
                }
                catch (java.sql.SQLException e) {
                    throw JavartUtil.makeEglException(e);
                }
            }
        }
        return this.conn;
    }
}

