/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.resources.egldd;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.javart.resources.egldd.Binding;
import org.eclipse.edt.javart.resources.egldd.RestBinding;
import org.eclipse.edt.javart.resources.egldd.RuntimeDeploymentDescParser;
import org.eclipse.edt.javart.resources.egldd.SQLDatabaseBinding;

public class RuntimeDeploymentDesc {
    private String name;
    protected ArrayList<String> includes;
    private List<Binding> bindings = new ArrayList<Binding>();

    public static RuntimeDeploymentDesc createRuntimeDeploymentDesc(String filepath) throws Exception {
        RuntimeDeploymentDesc desc = new RuntimeDeploymentDesc();
        desc.setName(RuntimeDeploymentDesc.getNameFromFilePath(filepath));
        RuntimeDeploymentDescParser parser = new RuntimeDeploymentDescParser();
        parser.parse(desc, filepath);
        return desc;
    }

    public static RuntimeDeploymentDesc createDeploymentDescriptor(String name, InputStream is) throws Exception {
        RuntimeDeploymentDesc desc = new RuntimeDeploymentDesc();
        desc.setName(name);
        RuntimeDeploymentDescParser parser = new RuntimeDeploymentDescParser();
        parser.parse(desc, is);
        return desc;
    }

    protected static String getNameFromFilePath(String path) {
        String name = null;
        String fileName = new File(path).getName();
        int eIdx = fileName.lastIndexOf(46);
        if (eIdx < 1) {
            eIdx = fileName.length();
        }
        name = fileName.substring(0, eIdx);
        return name;
    }

    protected RuntimeDeploymentDesc() {
        this.includes = new ArrayList();
    }

    public List<SQLDatabaseBinding> getSqlDatabaseBindings() {
        ArrayList<SQLDatabaseBinding> sqlDatabaseBindings = new ArrayList<SQLDatabaseBinding>();
        for (Binding binding : this.bindings) {
            if (!(binding instanceof SQLDatabaseBinding)) continue;
            sqlDatabaseBindings.add((SQLDatabaseBinding)binding);
        }
        return sqlDatabaseBindings;
    }

    public void addSqlDatabaseBindingsAll(List<SQLDatabaseBinding> bindings) {
        bindings.addAll(bindings);
    }

    public void addSqlDatabaseBindings(SQLDatabaseBinding binding) {
        this.bindings.add(binding);
    }

    public void addRestBinding(RestBinding binding) {
        this.bindings.add(binding);
    }

    public void addRestBindingsAll(List<RestBinding> bindings) {
        this.bindings.addAll(bindings);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.toLowerCase();
    }

    public List<RestBinding> getRestBindings() {
        ArrayList<RestBinding> restBindings = new ArrayList<RestBinding>();
        for (Binding binding : this.bindings) {
            if (!(binding instanceof RestBinding)) continue;
            restBindings.add((RestBinding)binding);
        }
        return restBindings;
    }

    public void addInclude(String location) {
        this.includes.add(location);
    }

    public ArrayList<String> getIncludedDescs() {
        return this.includes;
    }

    public ArrayList<String> getIncludes() {
        return this.includes;
    }

    public void addBinding(Binding binding) {
        if (Binding.BINDING_DB_SQL.equalsIgnoreCase(binding.getType())) {
            this.bindings.add(new SQLDatabaseBinding(binding));
        } else if (Binding.BINDING_SERVICE_REST.equalsIgnoreCase(binding.getType())) {
            this.bindings.add(new RestBinding(binding));
        } else {
            this.bindings.add(new Binding(binding));
        }
    }

    public List<Binding> getBindings() {
        return this.bindings;
    }
}

