/*
 * Decompiled with CFR 0.152.
 */
package resources.edt.binding;

import eglx.java.JavaObjectException;
import eglx.lang.AnyException;
import eglx.lang.DynamicAccessException;
import eglx.lang.SysLib;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.edt.javart.Executable;
import org.eclipse.edt.javart.Runtime;
import org.eclipse.edt.javart.resources.egldd.Binding;
import org.eclipse.edt.javart.resources.egldd.RuntimeDeploymentDesc;
import resources.edt.binding.BindingFactory;
import resources.edt.binding.RuntimeResourceLocator;

public class BindingResourceProcessor {
    protected static Map<QName, Binding> bindings = new HashMap<QName, Binding>();
    protected SysLib.ResourceLocator resourceLocator = new RuntimeResourceLocator();

    public Object resolve(URI uri) throws AnyException {
        String name;
        URI dd = null;
        if (uri.getFragment() == null) {
            dd = this.getDefaultDDURI();
            name = uri.getSchemeSpecificPart();
        } else {
            try {
                dd = new URI(uri.getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                JavaObjectException jox = new JavaObjectException();
                jox.exceptionType = URI.class.getName();
                jox.initCause(e);
                throw jox.fillInMessage("EGL0047E", uri);
            }
            name = uri.getFragment();
        }
        Binding binding = this.getBinding(name, dd, this.resourceLocator);
        if (binding != null && binding.getType() != null) {
            return this.getResource(binding, dd);
        }
        DynamicAccessException dax = new DynamicAccessException();
        dax.key = name;
        throw dax.fillInMessage("EGL0044E", name, dd);
    }

    protected Object getResource(Binding binding, URI dd) throws AnyException {
        String factoryPackage;
        String factoryName;
        int idx = binding.getType().lastIndexOf(46);
        if (idx > -1) {
            factoryName = binding.getType().substring(idx + 1);
            factoryPackage = binding.getType().substring(0, idx + 1);
        } else {
            factoryName = binding.getType();
            factoryPackage = "";
        }
        factoryName = String.valueOf(new StringBuffer(factoryName).replace(0, 1, String.valueOf(factoryName.charAt(0)).toUpperCase()).toString()) + "Factory";
        String implFactory = "resources." + factoryPackage + factoryName;
        BindingFactory factory = null;
        try {
            Class<?> clazz = Runtime.getRunUnit().getClass().getClassLoader().loadClass(implFactory);
            factory = (BindingFactory)clazz.newInstance();
        }
        catch (Exception e) {
            DynamicAccessException dax = new DynamicAccessException();
            dax.key = binding.getName();
            dax.initCause(e);
            throw dax.fillInMessage("EGL0043E", binding.getName(), binding.getType(), dd);
        }
        try {
            Object resource = factory.createResource(binding);
            if (resource == null) {
                DynamicAccessException dax = new DynamicAccessException();
                dax.key = binding.getName();
                throw dax.fillInMessage("EGL0045E", binding.getName(), binding.getType(), dd);
            }
            return resource;
        }
        catch (Exception e) {
            DynamicAccessException dax = new DynamicAccessException();
            dax.key = binding.getName();
            dax.initCause(e);
            throw dax.fillInMessage("EGL0046E", binding.getName(), binding.getType(), dd);
        }
    }

    protected URI getDefaultDDURI() throws AnyException {
        Executable app = Runtime.getRunUnit().getActiveExecutable();
        String dd = "";
        if (app != null) {
            dd = SysLib.getProperty("egl.application.property.file." + app.getClass().getCanonicalName());
        }
        if (dd == null) {
            dd = SysLib.getProperty("egl.application.property.file");
        }
        if (dd == null) {
            AnyException ae = new AnyException();
            throw ae.fillInMessage("EGL0049E", new Object[0]);
        }
        try {
            return this.createFileURI(dd);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    protected URI createFileURI(String fileName) throws URISyntaxException {
        return new URI("file:" + fileName);
    }

    private Binding getBinding(String bindingURI, URI propertyFileURI, SysLib.ResourceLocator resourceLocator) {
        QName resourceId = new QName(propertyFileURI.toASCIIString(), bindingURI);
        Binding binding = bindings.get(resourceId);
        if (binding == null) {
            RuntimeDeploymentDesc dd = this.getDeploymentDesc(propertyFileURI, resourceLocator);
            binding = this.getBinding(bindingURI, dd);
            if (binding == null) {
                binding = this.getBinding(bindingURI, dd.getIncludedDescs(), resourceLocator);
            }
            if (binding != null) {
                bindings.put(resourceId, binding);
            }
        }
        return binding;
    }

    private RuntimeDeploymentDesc getDeploymentDesc(URI propertyFileURI, SysLib.ResourceLocator resourceLocator) {
        return resourceLocator.getDeploymentDesc(propertyFileURI);
    }

    private Binding getBinding(String name, List<String> includes, SysLib.ResourceLocator resourceLocator) throws AnyException {
        ArrayList<RuntimeDeploymentDesc> includedDDs = new ArrayList<RuntimeDeploymentDesc>();
        Binding binding = null;
        for (String ddName : includes) {
            try {
                RuntimeDeploymentDesc includedDD = this.getDeploymentDesc(this.createFileURI(ddName), resourceLocator);
                binding = this.getBinding(name, includedDD);
                if (binding != null) break;
                includedDDs.add(includedDD);
            }
            catch (URISyntaxException e) {
                JavaObjectException jox = new JavaObjectException();
                jox.exceptionType = URI.class.getName();
                jox.initCause(e);
                throw jox.fillInMessage("EGL0047E", ddName);
            }
        }
        for (RuntimeDeploymentDesc includedDD : includedDDs) {
            binding = this.getBinding(name, includedDD.getIncludedDescs(), resourceLocator);
            if (binding != null) break;
        }
        return binding;
    }

    private Binding getBinding(String name, RuntimeDeploymentDesc dd) {
        for (Binding binding : dd.getBindings()) {
            if (!name.equalsIgnoreCase(binding.getName())) continue;
            return binding;
        }
        return null;
    }

    public static Map<QName, Binding> getBindings() {
        return bindings;
    }
}

