/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates.eglx.lang;

import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.BoxingExpression;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.FixedPrecisionType;
import org.eclipse.edt.mof.egl.IntegerLiteral;
import org.eclipse.edt.mof.egl.IsAExpression;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class NumberTypeTemplate
extends JavaScriptTemplate {
    public void genDefaultValue(FixedPrecisionType type, Context ctx, TabbedWriter out) {
        if (type.getTypeSignature().equalsIgnoreCase("eglx.lang.ENumber")) {
            this.processDefaultValue((Type)type, ctx, out);
        } else {
            ctx.invokeSuper((Template)this, "genDefaultValue", (Type)type, new Object[]{ctx, out});
        }
    }

    public void genDefaultValue(Type type, Context ctx, TabbedWriter out) {
        if (type.getTypeSignature().equalsIgnoreCase("eglx.lang.ENumber")) {
            this.processDefaultValue(type, ctx, out);
        } else {
            ctx.invokeSuper((Template)this, "genDefaultValue", type, new Object[]{ctx, out});
        }
    }

    public void processDefaultValue(Type type, Context ctx, TabbedWriter out) {
        out.print("egl." + ctx.getNativeMapping("eglx.lang.ENumber") + ".ZERO");
    }

    public void genSignature(FixedPrecisionType type, Context ctx, TabbedWriter out) {
        if (type.getTypeSignature().equalsIgnoreCase("eglx.lang.ENumber")) {
            String signature = "N" + type.getLength() + ":" + type.getDecimals() + ";";
            out.print(signature);
        } else {
            ctx.invokeSuper((Template)this, "genSignature", (Type)type, new Object[]{ctx, out});
        }
    }

    public void genSignature(ParameterizableType type, Context ctx, TabbedWriter out) {
        if (type.getTypeSignature().equalsIgnoreCase("eglx.lang.ENumber")) {
            String signature = "N;";
            out.print(signature);
        } else {
            ctx.invokeSuper((Template)this, "genSignature", (Type)type, new Object[]{ctx, out});
        }
    }

    protected boolean needsConversion(Type fromType, Type toType) {
        boolean result = true;
        if (TypeUtils.isNumericType((Type)fromType) && !CommonUtilities.needsConversion((Type)fromType, (Type)toType)) {
            result = CommonUtilities.isJavaScriptBigDecimal((Type)toType);
        }
        return result;
    }

    public void genConversionOperation(Type type, Context ctx, TabbedWriter out, AsExpression arg) {
        if (type.getTypeSignature().equalsIgnoreCase("eglx.lang.ENumber") && arg.getConversionOperation() != null) {
            Type toType = arg.getEType();
            arg.getObjectExpr().getType();
            out.print(String.valueOf(ctx.getNativeImplementationMapping(toType)) + '.');
            out.print(CommonUtilities.getOpName((Context)ctx, (Operation)arg.getConversionOperation()));
            out.print("(");
            Expression objectExpr = arg.getObjectExpr();
            if (objectExpr instanceof BoxingExpression) {
                objectExpr = ((BoxingExpression)objectExpr).getExpr();
            }
            ctx.invoke("genExpression", (EObject)objectExpr, new Object[]{ctx, out});
            ctx.invoke("genTypeDependentOptions", arg.getEType(), new Object[]{ctx, out, arg});
            out.print(")");
        } else {
            ctx.invokeSuper((Template)this, "genConversionOperation", type, new Object[]{ctx, out, arg});
        }
    }

    public void genTypeDependentOptions(ParameterizableType type, Context ctx, TabbedWriter out, AsExpression arg) {
        if (type.getTypeSignature().equalsIgnoreCase("eglx.lang.ENumber")) {
            out.print(", ");
            if (arg.getObjectExpr() instanceof IntegerLiteral) {
                String value = ((IntegerLiteral)arg.getObjectExpr()).getValue();
                if (value.startsWith("-")) {
                    value = value.substring(1);
                }
                if (value.length() > 4) {
                    out.print("egl.javascript.BigDecimal.prototype.NINES[8]");
                } else {
                    out.print("egl.javascript.BigDecimal.prototype.NINES[3]");
                }
            } else {
                out.print("egl.javascript.BigDecimal.prototype.NINES[8]");
            }
        } else {
            ctx.invokeSuper((Template)this, "genTypeDependentOptions", (Type)type, new Object[]{ctx, out, arg});
        }
    }

    public void genTypeDependentOptions(ParameterizableType type, Context ctx, TabbedWriter out) {
        if (type.getTypeSignature().equalsIgnoreCase("eglx.lang.ENumber")) {
            out.print(", ");
            out.print("egl.javascript.BigDecimal.prototype.NINES[8]");
        } else {
            ctx.invokeSuper((Template)this, "genTypeDependentOptions", (Type)type, new Object[]{ctx, out});
        }
    }

    public void genBinaryExpression(Type type, Context ctx, TabbedWriter out, BinaryExpression arg) {
        if (type.getTypeSignature().equalsIgnoreCase("eglx.lang.ENumber")) {
            out.print(this.getNativeStringPrefixOperation(arg));
            ctx.invoke("genExpression", (EObject)arg.getLHS(), new Object[]{ctx, out});
            out.print(this.getNativeStringOperation(arg));
            ctx.invoke("genExpression", (EObject)arg.getRHS(), new Object[]{ctx, out});
            out.print(this.getNativeStringPostfixOperation(arg));
        } else {
            ctx.invokeSuper((Template)this, "genBinaryExpression", type, new Object[]{ctx, out, arg});
        }
    }

    public void genIsaExpression(Type type, Context ctx, TabbedWriter out, IsAExpression arg) {
        if (type.getTypeSignature().equalsIgnoreCase("eglx.lang.ENumber")) {
            if ("eglx.lang.ENumber".equals(type.getTypeSignature())) {
                out.print("egl.is(");
                ctx.invoke("genExpression", (EObject)arg.getObjectExpr(), new Object[]{ctx, out});
                if (arg.getObjectExpr().getType().getTypeSignature().equalsIgnoreCase("eglx.lang.ENumber")) {
                    out.print(".eze$$value");
                }
                out.print(", \"NUMERIC\",egl.isnumeric)");
            } else {
                ctx.invokeSuper((Template)this, "genIsaExpression", type, new Object[]{ctx, out, arg});
            }
        } else {
            ctx.invokeSuper((Template)this, "genIsaExpression", type, new Object[]{ctx, out, arg});
        }
    }

    protected String getNativeStringPrefixOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("+")) {
            return "egl.addEGLNumber(";
        }
        if (op.equals("-")) {
            return "egl.subtractEGLNumber(";
        }
        if (op.equals("*")) {
            return "egl.multiplyEGLNumber(";
        }
        if (op.equals("/")) {
            return "egl.divideEGLNumber(";
        }
        if (op.equals("%")) {
            return "egl.remainderEGLNumber(";
        }
        if (op.equals("==")) {
            return "egl.compareEGLNumbers(";
        }
        if (op.equals("!=")) {
            return "egl.compareEGLNumbers(";
        }
        if (op.equals("<")) {
            return "egl.compareEGLNumbers(";
        }
        if (op.equals(">")) {
            return "egl.compareEGLNumbers(";
        }
        if (op.equals("<=")) {
            return "egl.compareEGLNumbers(";
        }
        if (op.equals(">=")) {
            return "egl.compareEGLNumbers(";
        }
        if (op.equals("**")) {
            return "egl.powEGLNumber(";
        }
        return "(";
    }

    protected String getNativeStringOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("+")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getLHS()) + ", ";
        }
        if (op.equals("-")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getLHS()) + ", ";
        }
        if (op.equals("*")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getLHS()) + ", ";
        }
        if (op.equals("/")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getLHS()) + ", ";
        }
        if (op.equals("==")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getLHS()) + ", ";
        }
        if (op.equals("!=")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getLHS()) + ", ";
        }
        if (op.equals("<")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getLHS()) + ", ";
        }
        if (op.equals(">")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getLHS()) + ", ";
        }
        if (op.equals("<=")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getLHS()) + ", ";
        }
        if (op.equals(">=")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getLHS()) + ", ";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        if (op.equals("%")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getLHS()) + ", ";
        }
        if (op.equals("**")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getLHS().getType()) + ", ";
        }
        return "";
    }

    protected String getNativeStringPostfixOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("+")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getRHS()) + ")";
        }
        if (op.equals("-")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getRHS()) + ")";
        }
        if (op.equals("*")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getRHS()) + ")";
        }
        if (op.equals("/")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getRHS()) + ")";
        }
        if (op.equals("==")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getRHS()) + ") == 0";
        }
        if (op.equals("!=")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getRHS()) + ") !=0";
        }
        if (op.equals("<")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getRHS()) + ") < 0";
        }
        if (op.equals(">")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getRHS()) + ") > 0";
        }
        if (op.equals("<=")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getRHS()) + ") <= 0";
        }
        if (op.equals(">=")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getRHS()) + ") >= 0";
        }
        if (op.equals("%")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getRHS()) + ")";
        }
        if (op.equals("**")) {
            return ", " + NumberTypeTemplate.eglNumberTypeArg(expr.getRHS()) + ")";
        }
        return ")";
    }

    private static String eglNumberTypeArg(Expression expr) {
        return NumberTypeTemplate.eglNumberTypeArg(expr.getType());
    }

    private static String eglNumberTypeArg(Type type) {
        int kind = TypeUtils.getTypeKind((Type)type);
        if (type.getTypeSignature().equalsIgnoreCase("eglx.lang.ENumber") || NumberTypeTemplate.isCharacterType(type)) {
            return "-1";
        }
        if (NumberTypeTemplate.isBigDecimalType(type)) {
            return "1";
        }
        if (kind == 16 || kind == 17) {
            return "2";
        }
        return "0";
    }

    private static boolean isCharacterType(Type type) {
        switch (TypeUtils.getTypeKind((Type)type)) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    private static boolean isFixedLengthNumericType(Type type) {
        switch (TypeUtils.getTypeKind((Type)type)) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private static boolean isBigDecimalType(Type type) {
        return TypeUtils.getTypeKind((Type)type) == 9 || NumberTypeTemplate.isFixedLengthNumericType(type);
    }
}

