/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout;

import java.util.HashMap;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvWidgetContextMenuProviderRegister;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.DefaultWidgetLayout;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.GridLayoutWidgetContextMenuProvider;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.GridLayoutWidgetLayout;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.HandlerWidgetLayout;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.RootWidgetLayout;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.WidgetLayout;

public class WidgetLayoutRegistry {
    public static final String VE_HANDLER = "VE-HANDLER";
    public static final String ROOT = "ROOT";
    private static WidgetLayoutRegistry _instance = new WidgetLayoutRegistry();
    private HashMap _hashWidgetLayouts = new HashMap();

    private WidgetLayoutRegistry() {
        this.init();
    }

    public static WidgetLayoutRegistry getInstance() {
        return _instance;
    }

    public WidgetLayout getWidgetLayout(String widgetId, boolean isContainer) {
        Class layout = (Class)this._hashWidgetLayouts.get(widgetId);
        if (layout == null && isContainer) {
            return new DefaultWidgetLayout();
        }
        try {
            return (WidgetLayout)layout.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addWidgetLayout(String widgetId, Class layout) {
        this._hashWidgetLayouts.put(widgetId, layout);
    }

    private void init() {
        this.addWidgetLayout(VE_HANDLER, HandlerWidgetLayout.class);
        this.addWidgetLayout(ROOT, RootWidgetLayout.class);
        this.addWidgetLayout("org.eclipse.edt.rui.widgets.GridLayout", GridLayoutWidgetLayout.class);
        EvWidgetContextMenuProviderRegister.getInstance().addEvWidgetContextMenuProvider(new GridLayoutWidgetContextMenuProvider());
    }

    public static String getLayoutName(WidgetPart widget) {
        return String.valueOf(widget.getPackageName() == null ? "" : String.valueOf(widget.getPackageName()) + ".") + widget.getTypeName();
    }
}

