/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import java.util.List;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.MemberName;

public class InvocationExpressionTemplate
extends JavaScriptTemplate {
    public void genInvocation(InvocationExpression expr, Context ctx, TabbedWriter out) {
        if (expr.getQualifier() != null) {
            boolean nullCheck;
            boolean bl = nullCheck = expr.getQualifier().isNullable() && expr.getQualifier() instanceof MemberName;
            if (nullCheck) {
                out.print("egl.checkNull(");
            }
            ctx.invoke("genExpression", (EObject)expr.getQualifier(), new Object[]{ctx, out});
            if (nullCheck) {
                out.print(")");
            }
            out.print(".");
        } else {
            ctx.invoke("genQualifier", (EObject)expr.getTarget(), new Object[]{ctx, out});
        }
        ctx.invoke("genName", (EObject)expr.getTarget(), new Object[]{ctx, out});
        out.print("(");
        ctx.invoke("genInvocationArguments", (EObject)expr, new Object[]{ctx, out});
        out.print(")");
    }

    public void genInvocationArguments(InvocationExpression expr, Context ctx, TabbedWriter out) {
        if (expr.getArguments() != null) {
            int i = 0;
            while (i < expr.getArguments().size()) {
                Expression argExpr = (Expression)expr.getArguments().get(i);
                if (!((FunctionParameter)expr.getTarget().getParameters().get(i)).isNullable() && argExpr.isNullable()) {
                    out.print("egl.checkNull(");
                    ctx.invoke("genExpression", (EObject)argExpr, new Object[]{ctx, out});
                    out.print(")");
                } else {
                    if (((FunctionParameter)expr.getTarget().getParameters().get(i)).isConst().booleanValue()) {
                        ctx.putAttribute((Object)argExpr, "function parameter is const in", (Object)Boolean.TRUE);
                    }
                    ctx.invoke("genExpression", (EObject)argExpr, new Object[]{ctx, out});
                    if (((FunctionParameter)expr.getTarget().getParameters().get(i)).isConst().booleanValue()) {
                        List list = (List)ctx.get((Object)argExpr);
                        list.remove("function parameter is const in");
                    }
                }
                if (i < expr.getArguments().size() - 1) {
                    out.print(", ");
                }
                ++i;
            }
        }
    }

    protected String resetFunctionParmName(FunctionParameter parm) {
        StringBuilder name = new StringBuilder();
        switch (parm.getParameterKind()) {
            case PARM_IN: {
                name.append("in");
                break;
            }
            case PARM_OUT: {
                name.append("out");
                break;
            }
            case PARM_INOUT: {
                name.append("inout");
            }
        }
        name.append("$");
        name.append(parm.getName());
        return name.toString();
    }
}

