/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.BooleanLiteral;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.ide.rui.document.utils.IVEConstants;

public class PropertyValueVisitor
extends DefaultASTVisitor {
    protected String propertyType;
    protected boolean propertyTypeMatch = true;
    protected ArrayList result = new ArrayList();

    public PropertyValueVisitor(String propertyType) {
        this.propertyType = propertyType;
    }

    public ArrayList getResult() {
        return this.result;
    }

    public void processExpression(Expression expression) {
        this.doProcessExpression(expression, this.result, this.propertyType);
    }

    private void doProcessExpression(Expression expression, final List values, final String thePropertyType) {
        if (IVEConstants.CHOICE_TYPE.equals(thePropertyType)) {
            values.add(expression.getCanonicalString());
        } else {
            final boolean[] foundLiteral = new boolean[1];
            expression.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(StringLiteral stringLiteral) {
                    if (IVEConstants.STRING_TYPE.equals(thePropertyType) || IVEConstants.COLOR_TYPE.equals(thePropertyType)) {
                        values.add(stringLiteral.getValue());
                    } else {
                        PropertyValueVisitor.this.propertyTypeMatch = false;
                        values.add(stringLiteral.getCanonicalString());
                    }
                    foundLiteral[0] = true;
                    return false;
                }

                public boolean visit(BooleanLiteral booleanLiteral) {
                    if (!IVEConstants.BOOLEAN_TYPE.equals(thePropertyType)) {
                        PropertyValueVisitor.this.propertyTypeMatch = false;
                    }
                    values.add(String.valueOf(booleanLiteral.booleanValue().booleanValue()));
                    foundLiteral[0] = true;
                    return false;
                }

                public boolean visit(IntegerLiteral integerLiteral) {
                    if (!IVEConstants.INTEGER_TYPE.equals(thePropertyType)) {
                        PropertyValueVisitor.this.propertyTypeMatch = false;
                    }
                    values.add(integerLiteral.getValue());
                    foundLiteral[0] = true;
                    return false;
                }

                public boolean visit(ArrayLiteral arrayLiteral) {
                    if (IVEConstants.STRING_ARRAY_TYPE.equals(thePropertyType)) {
                        List expressions = arrayLiteral.getExpressions();
                        for (Expression expression : expressions) {
                            PropertyValueVisitor.this.doProcessExpression(expression, values, IVEConstants.STRING_TYPE);
                        }
                    } else {
                        StringBuffer value = new StringBuffer();
                        List expressions = arrayLiteral.getExpressions();
                        ArrayList theValues = new ArrayList();
                        for (Expression expression : expressions) {
                            PropertyValueVisitor.this.doProcessExpression(expression, theValues, IVEConstants.STRING_TYPE);
                        }
                        value.append("[");
                        Iterator iterator = theValues.iterator();
                        while (iterator.hasNext()) {
                            String theValue = (String)iterator.next();
                            value.append(theValue);
                            if (!iterator.hasNext()) continue;
                            value.append(",");
                        }
                        value.append("]");
                        PropertyValueVisitor.this.propertyTypeMatch = false;
                        values.add(value.toString());
                    }
                    foundLiteral[0] = true;
                    return false;
                }

                public boolean visit(UnaryExpression unaryExpression) {
                    StringBuffer value = new StringBuffer();
                    ArrayList theValues = new ArrayList();
                    PropertyValueVisitor.this.doProcessExpression(unaryExpression.getExpression(), theValues, thePropertyType);
                    value.append(unaryExpression.getOperator());
                    for (String theValue : theValues) {
                        value.append(theValue);
                    }
                    values.add(value.toString());
                    foundLiteral[0] = true;
                    return false;
                }

                public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                    StringBuffer value = new StringBuffer();
                    ArrayList theValues = new ArrayList();
                    PropertyValueVisitor.this.doProcessExpression(parenthesizedExpression.getExpression(), theValues, IVEConstants.INTEGER_TYPE);
                    value.append("(");
                    for (String theValue : theValues) {
                        value.append(theValue);
                    }
                    value.append(")");
                    values.add(value.toString());
                    foundLiteral[0] = IVEConstants.INTEGER_TYPE.equals(PropertyValueVisitor.this.propertyType);
                    return false;
                }
            });
            if (!foundLiteral[0]) {
                values.add(expression.getCanonicalString());
                this.propertyTypeMatch = false;
            }
        }
    }
}

