/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.QueryContainer;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlCompletionProposal;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlCompletionProposalComputer;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.contentassist.ICompletionProposalComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JpaJpqlSseCompletionProposalComputer
extends JpqlCompletionProposalComputer<ICompletionProposal>
implements ICompletionProposalComputer {
    @Override
    ICompletionProposal buildProposal(String proposal, String displayString, String additionalInfo, Image image, int cursorOffset) {
        return new JpqlCompletionProposal(this.contentAssistProposals, proposal, displayString, additionalInfo, image, this.namedQuery, this.actualQuery, this.jpqlQuery, this.offset, this.position, cursorOffset, false);
    }

    public List<ICompletionProposal> computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        monitor.beginTask(null, 100);
        try {
            int offset = context.getInvocationOffset();
            if (offset == -1) {
                List<ICompletionProposal> list = Collections.emptyList();
                return list;
            }
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer buffer = manager.getTextFileBuffer(context.getDocument());
            if (buffer == null) {
                List<ICompletionProposal> list = Collections.emptyList();
                return list;
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFile(buffer.getLocation());
            JpaFile jpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
            if (jpaFile == null) {
                List<ICompletionProposal> list = Collections.emptyList();
                return list;
            }
            monitor.worked(80);
            this.checkCanceled(monitor);
            int[] position = new int[1];
            OrmNamedQuery namedQuery = this.namedQuery(jpaFile, offset, position);
            if (namedQuery == null) {
                List<ICompletionProposal> list = Collections.emptyList();
                return list;
            }
            int tokenStart = offset - position[0];
            String jpqlQuery = this.jpqlQuery(namedQuery, context.getDocument());
            List<ICompletionProposal> list = this.buildProposals((NamedQuery)namedQuery, jpqlQuery, tokenStart, position[0]);
            return list;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.jpt.jpa.ui", JptUiMessages.JpaJpqlSseCompletionProposalComputer_Error, (Throwable)e);
            JptJpaCorePlugin.log((IStatus)status);
        }
        finally {
            monitor.done();
        }
        return Collections.emptyList();
    }

    public List<IContextInformation> computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    private OrmNamedQuery findNamedQuery(JpaStructureNode structureNode, int offset, int[] position) {
        if (structureNode instanceof EntityMappings) {
            EntityMappings entityMappings = (EntityMappings)structureNode;
            OrmNamedQuery query = this.findNamedQuery((QueryContainer)entityMappings.getQueryContainer(), offset, position);
            if (query != null) {
                return query;
            }
            for (PersistentType persistentType : entityMappings.getPersistentTypes()) {
                TypeMapping typeMapping = persistentType.getMapping();
                if (!(typeMapping instanceof OrmEntity) || (query = this.findNamedQuery((QueryContainer)((OrmEntity)typeMapping).getQueryContainer(), offset, position)) == null) continue;
                return query;
            }
        }
        return null;
    }

    private OrmNamedQuery findNamedQuery(QueryContainer container, int offset, int[] position) {
        ListIterator queries = container.namedQueries();
        while (queries.hasNext()) {
            OrmNamedQuery namedQuery = (OrmNamedQuery)queries.next();
            TextRange textRange = namedQuery.getQueryTextRange();
            if (!textRange.touches(offset)) continue;
            position[0] = offset - textRange.getOffset();
            return namedQuery;
        }
        return null;
    }

    private String jpqlQuery(OrmNamedQuery namedQuery, IDocument document) {
        try {
            TextRange range = namedQuery.getQueryTextRange();
            return document.get(range.getOffset(), range.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    @Override
    String modifyJpqlQuery(String jpqlQuery, int[] position) {
        return ExpressionTools.unescape((CharSequence)jpqlQuery, (int[])position);
    }

    private OrmNamedQuery namedQuery(JpaFile jpaFile, int offset, int[] position) {
        for (JpaStructureNode node : jpaFile.getRootStructureNodes()) {
            OrmNamedQuery namedQuery = this.findNamedQuery(node, offset, position);
            if (namedQuery == null) continue;
            return namedQuery;
        }
        return null;
    }
}

