/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.edt.mof.EVisitor;

public class AbstractVisitor
implements EVisitor {
    private static final Object UNRESOLVED_METHOD = new Object();
    private static final int CACHE_MAX;
    private static Map<Class<?>, Map<Class<?>, Map<String, Object>>> methodsByClass;
    private boolean allowRevisit = true;
    private boolean trackParent = false;
    private Set<Object> visited;
    private Set<Object> endVisited;
    private Stack<Object> parents;
    private Stack<Integer> slotIndices;
    private Object returnData;

    static {
        methodsByClass = new HashMap();
        int value = -1;
        String max = System.getProperty("edt.mof.visitor.cache.max", null);
        if (max != null) {
            try {
                value = Integer.parseInt(max);
            }
            catch (Exception exception) {}
        }
        if (value == -1) {
            value = 1000;
        }
        CACHE_MAX = value;
    }

    public Set<Object> getVisited() {
        return this.visited;
    }

    public Set<Object> getEndVisited() {
        return this.endVisited;
    }

    public void setVisited(Set<Object> visited) {
        this.visited = visited;
    }

    public void setEndVisited(Set<Object> endVisited) {
        this.endVisited = endVisited;
    }

    public void disallowRevisit() {
        this.allowRevisit = false;
        this.visited = new HashSet<Object>();
        this.endVisited = new HashSet<Object>();
    }

    public void allowParentTracking() {
        this.trackParent = true;
        this.parents = new Stack();
        this.slotIndices = new Stack();
    }

    @Override
    public boolean isTrackingParent() {
        return this.trackParent;
    }

    @Override
    public void pushParent(Object parent) {
        this.parents.push(parent);
    }

    @Override
    public Object popParent() {
        return this.parents.pop();
    }

    @Override
    public Object getParent() {
        return this.parents.peek();
    }

    public Stack<Object> getParents() {
        return this.parents;
    }

    @Override
    public void pushSlotIndex(int index) {
        this.slotIndices.push(index);
    }

    @Override
    public Integer popSlotIndex() {
        return this.slotIndices.pop();
    }

    @Override
    public int getParentSlotIndex() {
        return this.slotIndices.peek();
    }

    @Override
    public void primEndVisit(Object obj) {
        Class<?> clazz = obj.getClass();
        if (!this.allowRevisit) {
            if (this.alreadyEndVisited(obj)) {
                return;
            }
            this.endVisited.add(obj);
        }
        this.invokeEndVisit(clazz, obj);
    }

    @Override
    public boolean primVisit(Object obj) {
        if (!this.allowRevisit) {
            if (this.alreadyVisited(obj)) {
                return false;
            }
            this.visited.add(obj);
        }
        Class<?> clazz = obj.getClass();
        boolean visitChildren = this.invokeVisit(clazz, obj);
        return visitChildren;
    }

    @Override
    public void endVisit(Object obj) {
    }

    @Override
    public boolean visit(Object obj) {
        return true;
    }

    private boolean invokeVisit(Class<?> clazz, Object obj) {
        boolean visitChildren = false;
        if (clazz.getInterfaces().length == 0) {
            visitChildren = this.visit(obj);
        } else {
            try {
                Method method = this.getMethod("visit", clazz.getInterfaces()[0], true);
                visitChildren = method == null ? this.visit(obj) : ((Boolean)method.invoke((Object)this, obj)).booleanValue();
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return visitChildren;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Method primGetMethod(String methodName, Class<?> clazz) {
        Object mapValue;
        Map<String, Object> methodsByName;
        Method method = null;
        LinkedHashMap methodsForThisClassByParameterType = methodsByClass.get(this.getClass());
        if (methodsForThisClassByParameterType == null) {
            methodsForThisClassByParameterType = new LinkedHashMap<Class<?>, Map<String, Object>>(){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<Class<?>, Map<String, Object>> eldest) {
                    return this.size() > CACHE_MAX;
                }
            };
            methodsByClass.put(this.getClass(), methodsForThisClassByParameterType);
        }
        if ((methodsByName = methodsForThisClassByParameterType.get(clazz)) == null) {
            methodsByName = new HashMap<String, Object>(2);
            methodsForThisClassByParameterType.put(clazz, methodsByName);
        }
        if ((mapValue = methodsByName.get(methodName)) == null) {
            try {
                Method[] classMethods;
                Method[] methodArray = classMethods = this.getClass().getMethods();
                int n = classMethods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method nextMethod = methodArray[n2];
                    if (nextMethod.getParameterTypes().length == 1 && nextMethod.getParameterTypes()[0].equals(clazz) && nextMethod.getName().equals(methodName)) {
                        method = nextMethod;
                        methodsByName.put(methodName, method);
                        break;
                    }
                    ++n2;
                }
                if (method != null) return method;
                methodsByName.put(methodName, UNRESOLVED_METHOD);
                return method;
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        } else {
            if (mapValue == UNRESOLVED_METHOD) return method;
            return (Method)mapValue;
        }
    }

    private Method getMethod(String methodName, Class<?> ifaceClass, boolean doGet) {
        Method method = null;
        if (doGet) {
            method = this.primGetMethod(methodName, ifaceClass);
        }
        if (method == null) {
            Class<?>[] classArray = ifaceClass.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                method = this.primGetMethod(methodName, iface);
                if (method != null) break;
                ++n2;
            }
        }
        if (method == null && ifaceClass.getInterfaces().length > 0) {
            method = this.getMethod(methodName, ifaceClass.getInterfaces()[0], false);
        }
        return method;
    }

    private void invokeEndVisit(Class<?> clazz, Object obj) {
        if (clazz.getInterfaces().length == 0) {
            this.endVisit(obj);
        } else {
            try {
                Method method = this.getMethod("endVisit", clazz, true);
                if (method == null) {
                    this.endVisit(obj);
                } else {
                    method.invoke((Object)this, obj);
                }
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean alreadyVisited(Object obj) {
        return this.visited.contains(obj);
    }

    private boolean alreadyEndVisited(Object obj) {
        return this.endVisited.contains(obj);
    }

    public void setReturnData(Object returnData) {
        this.returnData = returnData;
    }

    public Object getReturnData() {
        return this.returnData;
    }
}

