/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.utils;

import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.ConstantField;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.FixedPrecisionType;
import org.eclipse.edt.mof.egl.IntegerLiteral;
import org.eclipse.edt.mof.egl.Name;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class ArithmeticTypeAnalyzer {
    private static final int maxLen = 32;

    private static boolean needsComputedType(BinaryExpression exp, Type LHSType, Type RHSType) {
        if (exp.getType() != IRUtils.getEGLPrimitiveType("eglx.lang.EDecimal")) {
            return false;
        }
        if (!ArithmeticTypeAnalyzer.isArithmeticOperator(exp.getOperator())) {
            return false;
        }
        if (exp.getLHS() == null || !TypeUtils.isNumericType(LHSType) || TypeUtils.isReferenceType(LHSType) || ArithmeticTypeAnalyzer.getLength(LHSType) == 0) {
            return false;
        }
        return exp.getRHS() != null && TypeUtils.isNumericType(RHSType) && !TypeUtils.isReferenceType(RHSType) && ArithmeticTypeAnalyzer.getLength(RHSType) != 0;
    }

    private static boolean isArithmeticOperator(String o) {
        if (o == null) {
            return false;
        }
        return o.equals("+") || o.equals("-") || o.equals("/") || o.equals("*") || o.equals("**") || o.equals("%");
    }

    public static Type getType(Expression exp) {
        int d;
        int i;
        Expression exp2;
        Expression exp1;
        if (!(exp instanceof BinaryExpression)) {
            return exp.getType();
        }
        BinaryExpression binExp = (BinaryExpression)exp;
        String operator = binExp.getOperator();
        if (operator.equals("/")) {
            exp1 = binExp.getRHS();
            exp2 = binExp.getLHS();
        } else {
            exp1 = binExp.getLHS();
            exp2 = binExp.getRHS();
        }
        Type op1 = ArithmeticTypeAnalyzer.getType(exp1);
        Type op2 = ArithmeticTypeAnalyzer.getType(exp2);
        if (op1 == null || op2 == null) {
            return exp.getType();
        }
        if (!ArithmeticTypeAnalyzer.needsComputedType(binExp, op1, op2)) {
            return exp.getType();
        }
        int dmax = ArithmeticTypeAnalyzer.getDmax(op1, op2, operator);
        int i1 = ArithmeticTypeAnalyzer.getIntDigits(exp1, op1);
        int i2 = ArithmeticTypeAnalyzer.getIntDigits(exp2, op2);
        int d1 = ArithmeticTypeAnalyzer.getDecimals(op1);
        int d2 = ArithmeticTypeAnalyzer.getDecimals(op2);
        if (operator.equals("%")) {
            int d3;
            if (d1 == 0) {
                return op2;
            }
            int i3 = ArithmeticTypeAnalyzer.min(i1, i2);
            if (i3 + (d3 = dmax) <= 32) {
                return IRUtils.getEGLPrimitiveType("eglx.lang.EDecimal", i3 + d3, d3);
            }
            return IRUtils.getEGLPrimitiveType("eglx.lang.EDecimal", 32, dmax);
        }
        if (operator.equals("**")) {
            ConstantField constant;
            IntegerLiteral lit = null;
            if (binExp.getRHS() instanceof IntegerLiteral) {
                lit = (IntegerLiteral)binExp.getRHS();
            } else if (binExp.getRHS() instanceof Name && ((Name)binExp.getRHS()).getNamedElement() instanceof ConstantField && (constant = (ConstantField)((Name)binExp.getRHS()).getNamedElement()).getValue() instanceof IntegerLiteral) {
                lit = (IntegerLiteral)constant.getValue();
            }
            if (lit != null) {
                int d4;
                int value = Integer.parseInt(lit.getUnsignedValue());
                int i4 = i1 * value;
                if (i4 + (d4 = d1 * value) <= 32) {
                    return IRUtils.getEGLPrimitiveType("eglx.lang.EDecimal", i4 + d4, d4);
                }
                return IRUtils.getEGLPrimitiveType("eglx.lang.EDecimal", 32, dmax);
            }
            return IRUtils.getEGLPrimitiveType("eglx.lang.EDecimal", 32, dmax);
        }
        if (operator.equals("+") || operator.equals("-")) {
            i = ArithmeticTypeAnalyzer.max(i1, i2) + 1;
            d = ArithmeticTypeAnalyzer.max(d1, d2);
        } else if (operator.equals("*")) {
            i = i1 + i2;
            d = d1 + d2;
        } else {
            i = i2 + d1;
            d = ArithmeticTypeAnalyzer.max(d2 - d1, dmax);
        }
        if (i + d <= 32) {
            return IRUtils.getEGLPrimitiveType("eglx.lang.EDecimal", i + d, d);
        }
        if (d <= dmax) {
            return IRUtils.getEGLPrimitiveType("eglx.lang.EDecimal", 32, d);
        }
        if (i + dmax <= 32) {
            return IRUtils.getEGLPrimitiveType("eglx.lang.EDecimal", 32, 32 - i);
        }
        return IRUtils.getEGLPrimitiveType("eglx.lang.EDecimal", 32, dmax);
    }

    private static int getDmax(Type op1, Type op2, String operator) {
        if (operator.equals("/")) {
            return ArithmeticTypeAnalyzer.getDecimals(op2);
        }
        if (operator.equals("**")) {
            return ArithmeticTypeAnalyzer.getDecimals(op1);
        }
        return ArithmeticTypeAnalyzer.max(ArithmeticTypeAnalyzer.getDecimals(op1), ArithmeticTypeAnalyzer.getDecimals(op2));
    }

    private static int max(int i1, int i2) {
        if (i1 > i2) {
            return i1;
        }
        return i2;
    }

    private static int min(int i1, int i2) {
        if (i1 > i2) {
            return i2;
        }
        return i1;
    }

    private static int getIntDigits(Expression expr, Type type) {
        if (expr instanceof IntegerLiteral) {
            IntegerLiteral lit = (IntegerLiteral)expr;
            return lit.getUnsignedValue().length();
        }
        return ArithmeticTypeAnalyzer.getLength(type) - ArithmeticTypeAnalyzer.getDecimals(type);
    }

    private static int getLength(Type type) {
        String key = type.getClassifier().getMofSerializationKey();
        if (key.equalsIgnoreCase("egl:eglx.lang.EInt") || key.equalsIgnoreCase("egl:eglx.lang.EInt")) {
            return 9;
        }
        if (key.equalsIgnoreCase("egl:eglx.lang.ESmallint")) {
            return 4;
        }
        if (key.equalsIgnoreCase("egl:eglx.lang.EBigint")) {
            return 18;
        }
        if (type instanceof FixedPrecisionType) {
            return ((FixedPrecisionType)type).getLength();
        }
        return 0;
    }

    private static int getDecimals(Type type) {
        if (type instanceof FixedPrecisionType) {
            return ((FixedPrecisionType)type).getDecimals();
        }
        return 0;
    }
}

