/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.html;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.CommandResources;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.dom.html.TableUtil;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TableInsertColumnCommand
extends DesignerCommand {
    private Element _tableEle;
    private int _columnIndex;
    private TableUtil _tableUtil;

    public TableInsertColumnCommand(IHTMLGraphicalViewer viewer, Element dataTable, int index) {
        super(CommandResources.getString("TableInsertColumnCommand.Label.InsertColumn"), viewer);
        this._tableEle = dataTable;
        this._columnIndex = index;
        this._tableUtil = new TableUtil(this._tableEle);
    }

    public boolean canExecute() {
        ArrayList trList = new ArrayList();
        TableUtil.getTrElements(this._tableEle, trList);
        if (trList == null || trList.isEmpty()) {
            return false;
        }
        if (this._columnIndex < 0 && this._columnIndex != -10) {
            return false;
        }
        boolean isAffectedByColSpan = this._tableUtil.isAffectedByColSpan(this._columnIndex);
        if (isAffectedByColSpan) {
            return false;
        }
        return super.canExecute();
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._tableEle);
    }

    protected void doExecute() {
        ArrayList trList = new ArrayList();
        TableUtil.getTrElements(this._tableEle, trList);
        List[] lists = this._tableUtil.getTrCellLists();
        int maxColumn = this._tableUtil.getColumnCount();
        boolean isAtLastColumn = false;
        if (this._columnIndex >= maxColumn) {
            isAtLastColumn = true;
        }
        int i = 0;
        int size = trList.size();
        while (i < size) {
            Element tr = (Element)trList.get(i);
            boolean hasTH = DOMUtil.getChildElementsByTagIgnoreCase(tr, "th").size() > 0;
            List cells = lists[i];
            if (isAtLastColumn || cells.size() <= this._columnIndex) {
                int index = this._columnIndex + 1;
                int k = cells.size();
                while (k < index) {
                    tr.appendChild(this.createDefaultElement(hasTH));
                    ++k;
                }
            } else if (this._columnIndex != -10) {
                Element cell = (Element)cells.get(this._columnIndex);
                if (!cell.getTagName().equalsIgnoreCase("fake")) {
                    tr.insertBefore(this.createDefaultElement(hasTH), cell);
                } else {
                    boolean hasRealElement = false;
                    int k = this._columnIndex + 1;
                    while (k < cells.size()) {
                        Element td = (Element)cells.get(k);
                        if (!td.getTagName().equalsIgnoreCase("fake")) {
                            hasRealElement = true;
                            tr.insertBefore(this.createDefaultElement(hasTH), td);
                            break;
                        }
                        ++k;
                    }
                    if (!hasRealElement) {
                        tr.appendChild(this.createDefaultElement(hasTH));
                    }
                }
            } else {
                tr.appendChild(this.createDefaultElement(hasTH));
            }
            ++i;
        }
        this.formatNode(this._tableEle);
    }

    private Element createDefaultElement(boolean createTH) {
        Document doc = this._tableEle.getOwnerDocument();
        Element td = null;
        td = createTH ? doc.createElement("th") : doc.createElement("td");
        Text node = doc.createTextNode(CommandResources.getString("TableInsertColumnCommand.Text.Default"));
        td.appendChild(node);
        return td;
    }
}

